<?php

if(!function_exists('dtdr_generate_skin_colors')) {

	function dtdr_generate_skin_colors() {

		$output = '';

		$skin_settings = get_option('dtdr-skin-settings');

		$primary_color = ( isset($skin_settings['primary-color']) && '' !=  $skin_settings['primary-color'] ) ? $skin_settings['primary-color'] : '#1e306e';
		$primary_color_rgba = dtdr_hex2rgb( $primary_color );
		$primary_color_rgba = implode(',', $primary_color_rgba);

		$secondary_color = ( isset($skin_settings['secondary-color']) && '' !=  $skin_settings['secondary-color'] ) ? $skin_settings['secondary-color'] : '#2fa5fb';
		$secondary_color_rgba = dtdr_hex2rgb( $secondary_color );
		$secondary_color_rgba = implode(',', $secondary_color_rgba);

		$tertiary_color = ( isset($skin_settings['tertiary-color']) && '' !=  $skin_settings['tertiary-color'] ) ? $skin_settings['tertiary-color'] : '#d2edf8';
		$tertiary_color_rgba = dtdr_hex2rgb( $tertiary_color );
		$tertiary_color_rgba = implode(',', $tertiary_color_rgba);

		$primary_alternate_color = ( isset($skin_settings['primary-alternate-color']) && '' !=  $skin_settings['primary-alternate-color'] ) ? $skin_settings['primary-alternate-color'] : '';
		$primary_alternate_color_rgba = dtdr_hex2rgb( $primary_alternate_color );
		$primary_alternate_color_rgba = implode(',', $primary_alternate_color_rgba);

		$secondary_alternate_color = ( isset($skin_settings['secondary-alternate-color']) && '' !=  $skin_settings['secondary-alternate-color'] ) ? $skin_settings['secondary-alternate-color'] : '';
		$secondary_alternate_color_rgba = dtdr_hex2rgb( $secondary_alternate_color );
		$secondary_alternate_color_rgba = implode(',', $secondary_alternate_color_rgba);

		$tertiary_alternate_color = ( isset($skin_settings['tertiary-alternate-color']) && '' !=  $skin_settings['tertiary-alternate-color'] ) ? $skin_settings['tertiary-alternate-color'] : '';
		$tertiary_alternate_color_rgba = dtdr_hex2rgb( $tertiary_alternate_color );
		$tertiary_alternate_color_rgba = implode(',', $tertiary_alternate_color_rgba);


		// Primary
		$output .= 'a, .dtdr-dashbord-container .dtdr-dashbord-section-holder .dtdr-dashbord-section-title,	.dtdr-dashbord-section-holder-content .ui-sortable .dtdr-social-item-section div[class*="section-options"] span:hover, .dtdr-add-listing .dtdr-dashbord-section-holder-content .dtdr-dashboard-option-item div[class*="dtdr-dashboard-option-item"] input[type="checkbox"]:checked ~ label:before, .dtdr-my-ads-container .dtdr-dashbord-section-holder-content .dtdr-dashbord-ads-addnew-wrapper .dtdr-dashbord-ad-details input[type="checkbox"]:checked ~ label:before, .dtdr-dashboard-addincharge-form .dtdr-dashbord-section-holder-content .dtdr-dashboard-option-item input[type="checkbox"]:checked ~ label:before, .dtdr-dashbord-reviews-listing-wrapper .dtdr-dashbord-reviews-listing .dtdr-ratings-holder span, .dtdr-listings-item-wrapper.type1 .dtdr-listings-item-bottom-section-content .custom-button-style.dtdr-listing-view-details, .dtdr-listings-item-wrapper.type2 .dtdr-listings-item-bottom-section-content > div.dtdr-listings-item-bottom-pricing-holder .custom-button-style, .dtdr-packages-item-wrapper .dtdr-item-pricing-details ins, .dtdr-packages-item-wrapper.type1 .dtdr-packagelist-view-details-button span, .dtdr-packages-item-wrapper.type1 .dtdr-item-status-details .dtdr-proceed-button .custom-button-style span, .dtdr-packages-item-wrapper.type2 .dtdr-packagelist-view-details .custom-button-style span, .dtdr-packages-item-wrapper.type2 .dtdr-packagelist-view-details .custom-button-style:hover, .dtdr-packages-item-wrapper.type2 .dtdr-item-status-details .custom-button-style, .dtdr-packages-item-wrapper.type2 .dtdr-item-status-details .added_to_cart, .dtdr-packages-item-wrapper.type3 .dtdr-item-status-details .custom-button-style, .dtdr-packages-item-wrapper.type3 .dtdr-item-status-details .added_to_cart, .dtdr-packages-item-wrapper.type3 .dtdr-packagelist-view-details .custom-button-style, ul.dtdr-dashboard-menus li a, .dtdr-packages-item-wrapper.type3 .dtdr-item-status-details .dtdr-purchased, .dtdr-listings-item-wrapper.type3 .dtdr-listings-item-bottom-section a.custom-button-style, .dtdr-listings-item-wrapper.type4 .dtdr-listings-item-bottom-section>div.dtdr-listings-item-bottom-pricing-holder .custom-button-style:before, .dtdr-listings-item-wrapper.type5 .dtdr-listings-item-bottom-section a.custom-button-style, .dtdr-listings-item-wrapper.type4 .dtdr-listings-item-top-section .dtdr-listings-item-top-section-content > div a, .dtdr-listings-item-wrapper.type4 .dtdr-listings-item-top-section .dtdr-listings-item-top-section-content > div.dtdr-listings-utils-item-holder .dtdr-listings-utils-item > *, .dtdr-listing-taxonomy-item .dtdr-listing-taxonomy-meta-data h3 a, dtdr-sf-fields-holder input[type="checkbox"].dtdr-sf-field:checked ~ label:before, .dtdr-sf-location-field-holder .dtdr-sf-location-field-inner-holder .dtdr-detect-location, .dtdr-sf-fields-holder input[type="checkbox"].dtdr-sf-field:checked ~ label::before, .dtdr-sf-fields-holder .ui-widget.ui-widget-content .dtdr-sf-radius-slider-handle, .dtdr-sf-features-field-holder > div > div[class*="-handle"], .dtdr-custom-login, .dtdr-custom-login li a, .dtdr-swiper-arrow-pagination a:hover, .dtdr-sf-others-field-holder div.dtdr-sf-others-list, .dtdr-marker-addition-info.dtdr-marker-addition-info-totalviews, .dtdr-marker-addition-info.dtdr-marker-addition-info-averageratings, .dtdr-marker-addition-info.dtdr-marker-addition-info-startdate, .dtdr-marker-addition-info.dtdr-marker-addition-info-distance, .dtdr-listing-taxonomy-item.type2 .dtdr-listing-taxonomy-icon-image > span, .dtdr-listing-taxonomy-item .dtdr-listing-taxonomy-starting-price-html ins > span, .dtdr-listings-item-wrapper:hover .dtdr-listings-item-top-section .dtdr-listings-item-ad-section, .dtdr-listings-item-wrapper:hover .dtdr-listings-item-top-section .dtdr-listings-featured-item-container, .dtdr-listings-item-wrapper.type2 .dtdr-listings-item-top-section .dtdr-listings-featured-item-container a:after, .dtdr-listings-item-wrapper.type2:hover .dtdr-listings-item-top-section .dtdr-listings-featured-item-container:before, .dtdr-listings-item-wrapper.type7 .dtdr-listings-item-top-section .dtdr-listings-item-ad-section, .dtdr-listings-item-wrapper.type7 .dtdr-listings-item-top-section .dtdr-listings-featured-item-container, .dtdr-listings-item-wrapper.type5 .dtdr-listings-item-top-section .dtdr-listings-featured-item-container:before, .dtdr-listings-item-wrapper.type5:hover .dtdr-listings-item-top-section .dtdr-listings-featured-item-container:after, .dtdr-listings-item-wrapper.type3 .dtdr-listings-item-top-section div.dtdr-listings-item-ad-section, .dtdr-listings-item-wrapper.type3 .dtdr-listings-item-top-section div.dtdr-listings-featured-item-container a, .dtdr-listings-item-wrapper.type3:hover .dtdr-listings-item-top-section div.dtdr-listings-item-ad-section:before, .dtdr-listings-item-wrapper.type3:hover .dtdr-listings-item-top-section div.dtdr-listings-featured-item-container a:before, .dtdr-listings-item-wrapper.type1:not(.has-post-thumbnail) .dtdr-listings-item-top-section .dtdr-listings-item-top-section-content .dtdr-listings-utils-item-holder > div a, .dtdr-listings-item-wrapper.type1:not(.has-post-thumbnail) .dtdr-listings-item-top-section .dtdr-listings-item-top-section-content .dtdr-listings-utils-item-holder > div div, .dtdr-dashbord-section-holder-content ul.dtdr-dashbord-inbox-listing-messages-wrapper li:hover, .dtdr-dashbord-section-holder-content ul.dtdr-dashbord-inbox-listing-messages-wrapper li.active, .dtdr-listings-comment-list-holder .commentlist li.comment .comment-body .reply a.comment-reply-link, .comment-form .dtdr-comment-form-fields-holder>p.comment-form-cookies-consent input[type="checkbox"]:checked~label:before, .dtdr-listings-countdown-timer-container.type2 .dtdr-listings-countdown-timer-holder .dtdr-listings-countdown-timer-notice span, .dtdr-listings-item-wrapper ul.dtdr-listings-contactdetails-list li span, .single-dtdr_packages .dtdr-item-pricing-details ins, .single-dtdr_packages .dtdr-item-pricing-details span.amount, .single-dtdr_packages .dtdr-packagelist-features li:before, .dtdr-listings-item-wrapper.type2:hover .dtdr-listings-item-top-section .dtdr-listings-featured-item-container a:before, .dtdr-listings-item-wrapper.type5:hover .dtdr-listings-item-top-section .dtdr-listings-featured-item-container a:after, .dtdr-listings-item-wrapper.type8:hover .dtdr-listings-item-top-section div.dtdr-listings-featured-item-container a, .dtdr-listing-taxonomy-item.type6 .dtdr-category-total-items a:hover, .dtdr-comment-form-fields-holder input#dtdr_media+label:before, .dtdr-listings-item-wrapper.type5 .dtdr-listings-item-top-section .dtdr-listings-featured-item-container a, .dtdr-listings-item-wrapper.type7 .dtdr-listings-item-top-section .dtdr-listings-featured-item-container a, .dtdr-listings-item-wrapper.type7:hover .dtdr-listings-item-top-section .dtdr-listings-featured-item-container a, .dtdr-swiper-arrow-pagination a:before, .dtdr-packages-item-wrapper .dtdr-packagelist-details > h5 a, .dtdr-listings-item-wrapper .dtdr-listings-item-bottom-section-content .dtdr-listings-item-title a, .dtdr-listings-item-wrapper.type7 .dtdr-listings-item-bottom-section .dtdr-listings-item-title a, .dtdr-user-list-item .dtdr-user-item-meta-data h4 a, .dtdr-user-list-item.type1 .dtdr-user-sociallinks-list li a, .dtdr-user-list-item.type2 .dtdr-user-contactdetails-list li a, .dtdr-user-list-item.type3 .dtdr-user-contactdetails-list li span, .dtdr-user-list-item.type2 .dtdr-user-contactdetails-list li span, .dtdr-listings-item-wrapper.type3 .dtdr-listings-taxonomy-container li a, .dtdr-listings-taxonomy-container.type3 li a, .dtdr-listings-utils-container .dtdr-listings-utils-item h3.dtdr-listings-utils-title-item a, .dtdr-listings-item-wrapper .dtdr-listings-excerpt span, .dtdr-listings-item-wrapper.type7 .dtdr-listings-item-bottom-section-content .dtdr-listings-item-bottom-left-content div[class*="dtdr-listings-"] label[class*="dtdr-listings-"], .dtdr-comment-form-fields-holder input#dtdr_media + label, p.tpl-forget-pwd a, .dtdr-listings-item-wrapper.type5 .dtdr-listings-item-bottom-section-content > div .dtdr-listings-utils-item-holder a, .dtdr-dashbord-recent-activites-holder .dtdr-dashbord-recent-activites-content p a, .dtdr-dashbord-recent-activites-holder .dtdr-dashbord-recent-activites-content p strong, .dtdr-dashbord-container .dtdr-my-listings-container .dtdr-listing-details h5 a, .dtdr-dashbord-container .dtdr-my-listings-container .dtdr-listing-dashboard-owner a, .dtdr-dashbord-container .dtdr-my-listings-container .dtdr-listing-details .dtdr-mylisting-options-container > a[data-tooltip]:after, .dtdr-dashbord-inbox-listing-conversation-wrapper ul.dtdr-dashbord-inbox-conversation-list li>span:before, .dtdr-listings-dates-container [class*="date-container"] > :not(:last-child), .dtdr-listings-dates-container [class*="date-container"] > div:not(:last-child) > :not(:last-child), .dtdr-listings-post-dates-container.type1 .dtdr-listings-post-date-container span, .dtdr-listings-dates-container.type2 [class*="date-container"] > span, p.login-remember input[type="checkbox"]:checked~label:before, .dtdr-login-title h2, .dtdr-claim-form-container .dtdr-claimform-secure-note > span { color:'.$primary_color.'}';

		// Pagination Color
		$output .= '.dtdr-pagination.dtdr-ajax-pagination ul.page-numbers li span, .dtdr-pagination.dtdr-ajax-pagination ul.page-numbers li a:hover, .dtdr-pagination.dtdr-ajax-pagination .prev-post a:hover, .dtdr-pagination.dtdr-ajax-pagination .next-post a:hover { color:'.$primary_color.'}';

		// Border Color
		$output .= '.dtdr-pagination.dtdr-ajax-pagination .prev-post a, .dtdr-pagination.dtdr-ajax-pagination .next-post a, .dtdr-pagination.dtdr-ajax-pagination ul.page-numbers li span, .dtdr-pagination.dtdr-ajax-pagination ul.page-numbers li a { border-color:'.$primary_color.'}';

		// BG Color
		$output .= '.dtdr-dashbord-container .woocommerce-orders-table th, .dtdr-pagination.dtdr-ajax-pagination .prev-post a, .dtdr-pagination.dtdr-ajax-pagination .next-post a, .dtdr-pagination.dtdr-ajax-pagination ul.page-numbers li a { background-color:'.$primary_color.'}';
		

		// Single Page Shortcode Color

		$output .= '.dtdr-packages-item-wrapper .dtdr-packagelist-features li:before, .dtdr-listings-average-rating-container .dtdr-listings-average-rating-holder span, .dtdr-listings-average-rating-container .dtdr-listings-average-rating-overall, .dtdr-listings-featured-item-container.type1 > span, .dtdr-listings-dates-container.type2 .dtdr-listings-post-date-container span, .dtdr-listings-nearby-places-container .dtdr-listings-nearby-places-item .dtdr-listings-nearby-places-content .dtdr-listings-nearby-places-title, .dtdr-listings-nearby-places-container .dtdr-listings-nearby-places-item .dtdr-listings-nearby-places-content .dtdr-listings-nearby-places-ratings:before, .dtdr-listings-nearby-places-container .dtdr-listings-nearby-places-item .dtdr-listings-nearby-places-content .dtdr-listings-nearby-places-distance:before, .dtdr-listings-nearby-places-container .dtdr-listings-nearby-places-item .dtdr-listings-nearby-places-content .dtdr-listings-nearby-places-address:before, .dtdr-listings-contactdetails-container.type2 .dtdr-listings-contactdetails-list > li span, .dtdr-announcement-listing-holder.booknow span, .dtdr-announcement-listing-holder.booknow a:hover, .dtdr-announcement-listing-holder.contactus:hover h2, .dtdr-announcement-listing-holder.contactus:hover p, .dtdr-claim-form-container .dtdr-claim-form .dtdr-claim-form-title, .dtdr-listings-dates-container.type4 [class*="date-container"] span, .dtdr-listings-countdown-timer-container.type2 .dtdr-countdown-wrapper .dtdr-countdown-icon-wrapper, .dtdr-listings-countdown-timer-container.type2 .dtdr-listings-countdown-timer-holder .dtdr-listings-countdown-timer-holder .dtdr-listings-countdown-timer-notice span, .dtdr-listings-attachment-holder.type3 .dtdr-listings-attachment-box-item span, [class*="dtdr-listings-utils-"] .dtdr-listings-price-container .dtdr-listings-price-item ins, .dtdr-yelp-places-container .dtdr-yelp-places-item .dtdr-yelp-places-content .dtdr-yelp-places-title, .dtdr-yelp-places-container .dtdr-yelp-places-item .dtdr-yelp-places-content .dtdr-yelp-places-ratings:before, .dtdr-yelp-places-container .dtdr-yelp-places-item .dtdr-yelp-places-content .dtdr-yelp-places-distance:before, .dtdr-yelp-places-container .dtdr-yelp-places-item .dtdr-yelp-places-content .dtdr-yelp-places-address:before, div[class*="-output-data-container"] .dtdr-ajax-load-image .dtdr-loader-inner, .dtdr-sf-fields-holder input[type="text"] ~ span:not(.dtdr-detect-location), .dtdr-listings-contactform input ~ span, .dtdr-listings-contactform textarea ~ span,.dtdr-comment-form-fields-holder p input[type="text"]~span, .dtdr-comment-form-fields-holder p input[type="email"]~span, .dtdr-comment-form-fields-holder p textarea~span, .dtdr-listings-item-wrapper:hover .dtdr-listings-item-top-section .dtdr-listings-featured-item-container a, form.lidd_mc_form .lidd_mc_input input[type="text"]~span:not(#lidd_mc_total_amount-error):before, form.lidd_mc_form .lidd_mc_input input[type="text"]~span:not(#lidd_mc_total_amount-error):after, .dtdr-user-list-item.type3 .dtdr-user-sociallinks-list li a, .dtdr-user-list-item.type3 .dtdr-user-contactdetails-list li a, .dtdr-listings-social-share-container .dtdr-listings-social-share-list li a, .dtdr-user-list-item.type3 .dtdr-user-item-meta-data .dtdr-listings-social-share-container .dtdr-listings-social-share-list li a, .dtdr-listings-contactdetails-container .dtdr-listings-contactdetails-list > li a, .dtdr-listings-item-wrapper.type7 .dtdr-listings-item-bottom-section-content .dtdr-listings-item-bottom-right-content .dtdr-listings-utils-item-holder a, .dtdr-listings-features-box-container.type3 .dtdr-listings-features-box-item .dtdr-listings-features-box-item-icon, .dtdr-announcement-listing-holder.announcement, [class*="dtdr-listings-utils-"] .dtdr-listings-taxonomy-container .dtdr-listings-taxonomy-list li a:hover span[class*="dtdr"], .dtdr-listings-item-wrapper.type6 .dtdr-listings-item-bottom-section .dtdr-listings-utils-item-holder a.dtdr-listings-utils-favourite-item, .dtdr-listings-post-dates-container.type3 .dtdr-listings-post-date-container, .dtdr-listings-attachment-holder.type1 .dtdr-listings-attachment-box-item span, #loginform .dtdr-login-field-item input~span, .dtdr-listings-claim-form>.dtdr-listings-claim-form-item input~span, .dtdr-listings-claim-form>.dtdr-listings-claim-form-item textarea~span, .dtdr-listings-comment-list-holder .comment-body .comment-meta .comment-author b.fn, .dtdr-listings-business-hours-container .dtdr-listings-business-hours-list li span.dtdr-business-hours-label, .dtdr-listings-claim-form>.dtdr-listings-claim-form-item input#dtdr-claimform-verification-file+label, .dtdr-listings-item-wrapper.type5 .dtdr-listings-item-bottom-section-content>div .dtdr-listings-utils-item-holder [class*="dtdr-listings-utils-"] a.dtdr-listings-utils-favourite-item span { color:'.$primary_color.'}';

		// Shortcode BG Color

		$output .= 'ul.dtdr-dashboard-menus li a span, .dtdr-dashboard-user-package-details .dtdr-dashboard-package-detail span.dtdr-dashboard-package-detail-value, .dtdr-dashboard-user-package-details .dtdr-dashboard-package-detail span.dtdr-dashboard-package-detail-title, .dtdr-dashbord-container .dtdr-dashbord-section-holder .dtdr-dashbord-statistics-counter-label, .custom-button-style, .dtdr-dashbord-container .dtdr-my-listings-container .dtdr-listing-details .dtdr-mylisting-options-container > a, .dtdr-dashbord-section-holder-content ul.dtdr-dashbord-reviews-listing-options-wrapper li:hover, .dtdr-dashbord-section-holder-content ul.dtdr-dashbord-reviews-listing-options-wrapper li.dtdr-active, .dtdr-dashboard-container .woocommerce-button.view, .dtdr-listings-item-wrapper.type1:hover .dtdr-listings-item-bottom-section-content .custom-button-style.dtdr-listing-view-details:hover, .dtdr-listings-item-wrapper.type2 .dtdr-listings-item-bottom-section-content > div.dtdr-listings-item-bottom-pricing-holder .custom-button-style:hover,	.dtdr-dashbord-container .dtdr-packages-container .dtdr-packages-item-wrapper .dtdr-packagelist-details .dtdr-item-status-details .dtdr-proceed-button a.custom-button-style, .dtdr-packages-item-wrapper.type1 .dtdr-packagelist-view-details-button:hover, .dtdr-packages-item-wrapper.type1 .dtdr-item-status-details .dtdr-proceed-button .custom-button-style:hover,  .dtdr-packages-item-wrapper.type1 .dtdr-item-status-details .dtdr-proceed-button .added_to_cart:hover, .dtdr-packages-item-wrapper.type2 .dtdr-item-status-details .custom-button-style:hover, .dtdr-packages-item-wrapper.type2 .dtdr-item-status-details .added_to_cart:hover, .dtdr-packages-item-wrapper.type3 .dtdr-item-status-details .custom-button-style:hover, .dtdr-packages-item-wrapper.type3 .dtdr-item-status-details .added_to_cart:hover, .dtdr-packages-item-wrapper.type3 .dtdr-packagelist-view-details .custom-button-style:hover, .dtdr-packages-item-wrapper.type3 .dtdr-item-status-details .dtdr-purchased:hover, .dtdr-listings-item-wrapper.type3 .dtdr-listings-item-bottom-section a.custom-button-style:hover, .dtdr-listings-item-wrapper.type4 .dtdr-listings-item-bottom-section>div.dtdr-listings-item-bottom-pricing-holder .custom-button-style:hover, .dtdr-sf-orderby-field-holder ul.dtdr-sf-orderby-list li a:hover, .dtdr-sf-orderby-field-holder ul.dtdr-sf-orderby-list li a.active, .dtdr-sf-fields-holder .ui-widget-content .ui-state-default.ui-state-active, .dtdr-sf-fields-holder.dtdr-sf-features-field-holder .ui-widget.ui-widget-content, div[class*="-output-data-container"] .dtdr-swiper-pagination-holder .dtdr-swiper-bullet-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover, div[class*="-output-data-container"] .dtdr-swiper-pagination-holder .dtdr-swiper-bullet-pagination.swiper-pagination-bullets .swiper-pagination-bullet.swiper-pagination-bullet-active, .dtdr-sf-others-field-holder div.dtdr-sf-others-list:hover, .dtdr-dashbord-ads-addnew-wrapper ul.dtdr-addtocart-purhcase-preview-wrapper li:not(.duration):not(.total-amount) span.active, .dtdr-marker-container, .dtdr-marker-addition-info.dtdr-marker-addition-info-categoryimage .dtdr-marker-addition-info-categoryimage-inner, table.dtdr-my-incharges-table thead tr th, .dtdr-dashbord-load-buyer-listings-content table thead tr th, table.dtdr-custom-table > tbody:first-child > tr > th, .dtdr-dashbord-ads-listing table.dtdr-custom-table tbody tr td:last-child a:hover, .dtdr-listings-item-wrapper .dtdr-listings-item-top-section .dtdr-listings-featured-item-container a, .dtdr-listings-item-wrapper .dtdr-listings-item-top-section .dtdr-listings-item-ad-section, .dtdr-listings-item-wrapper.type3 .dtdr-listings-item-top-section div.dtdr-listings-item-ad-section:before, .dtdr-listings-item-wrapper.type3 .dtdr-listings-item-top-section div.dtdr-listings-featured-item-container a:before, .dtdr-listings-item-wrapper.type8 .dtdr-listings-item-top-section .dtdr-listings-featured-item-container a, .dtdr-listings-item-wrapper.type7 .dtdr-listings-item-top-section .dtdr-listings-item-ad-section span:before, .dtdr-listings-item-wrapper.type7 .dtdr-listings-item-top-section .dtdr-listings-featured-item-container span:before, table.dtdr-user-claimed-posts-table thead tr th, .dtdr-dashbord-load-favourite-listings-content table th, .dtdr-dashbord-inbox-listing-conversation-wrapper ul.dtdr-dashbord-inbox-conversation-list li a.dtdr-dashbord-inbox-conversation-reply-loader, .dtdr-dashbord-inbox-listing-conversation-wrapper ul.dtdr-dashbord-inbox-conversation-list li .dtdr-dashbord-inbox-conversation-reply-wrapper .dtdr-inbox-conversation-reply-submit, div[class*="-apply-isotope"] div[class*="-isotope-filter"] a, .dtdr-dashbord-ads-addnew-wrapper ul.dtdr-addtocart-purhcase-preview-wrapper li.duration span, .dtdr-dashbord-ads-addnew-wrapper ul.dtdr-addtocart-purhcase-preview-wrapper li.total-amount span, .dtdr-listings-contactform a.dtdr-contactform-submit-button, .dtdr-listings-floorplan-top-section .dtdr-listings-floorplan-expand-bottom-section, .dtdr-listings-author-container[class*=swiper-container-] .dtdr-listings-swiper-pagination-holder.type1 .dtdr-swiper-bullet-pagination .swiper-pagination-bullet-active, .dtdr-listings-item-wrapper.type2 .dtdr-listings-item-top-section div.dtdr-listings-item-ad-section:after, .dtdr-listings-item-wrapper.type2 .dtdr-listings-item-top-section div.dtdr-listings-item-ad-section:before, .dtdr-listings-item-wrapper.type3.dtdr-list:hover .dtdr-listings-item-top-section div.dtdr-listings-item-ad-section:after, .dtdr-listings-item-wrapper.type3.dtdr-list:hover .dtdr-listings-item-top-section div.dtdr-listings-featured-item-container:after, .dtdr-listing-taxonomy-item.type7:hover .dtdr-listing-taxonomy-starting-price:after, .dtdr-listings-social-share-container.type2.active .dtdr-listings-social-share-item-icon > span, .dtdr-listings-social-share-container.type2:hover .dtdr-listings-social-share-item-icon > span, .dtdr-listings-item-wrapper.type5 .dtdr-listings-item-top-section div.dtdr-listings-taxonomy-container ul.dtdr-listings-taxonomy-list li>a:before, .dtdr-sf-pricerange-field-holder .ui-widget.ui-widget-content .ui-widget-header, .dtdr-comment-form-fields-holder .comment-form-media span:hover input#dtdr_media + label, .dtdr-listings-item-wrapper.type4:hover .dtdr-listings-item-top-section .dtdr-listings-featured-item-container a:hover, .dtdr-user-list-item.type3 .dtdr-user-item-meta-data .dtdr-listings-social-share-container.active .dtdr-listings-social-share-item-icon span, .dtdr-user-list-item.type3 .dtdr-user-item-meta-data .dtdr-listings-social-share-container .dtdr-listings-social-share-item-icon:hover span, .dtdr-user-list-item.type3 .dtdr-user-item-meta-data .dtdr-listings-utils-favourite .dtdr-listings-utils-favourite-author:hover span, .dtdr-listings-nearby-places-container .dtdr-listings-nearby-places-item .dtdr-listings-nearby-places-image .dtdr-listings-nearby-places-icon, form.lidd_mc_form .lidd_mc_input input[type="submit"], .comment-form .dtdr-comment-form-fields-holder p.form-submit input[type="submit"], .logged-in .dtdr-listings-comment-list-holder p.form-submit input[type="submit"], #loginform .login-submit input[type="submit"], .dtdr-listings-features-box-container.type1 .dtdr-listings-features-box-item .dtdr-listings-features-box-item-title:first-child:before, .dtdr-announcement-listing-holder.contactus span, .dtdr-listings-claim-wrapper .dtdr-listings-claim-item, .dtdr-dashbord-container .dtdr-my-listings-container .dtdr-listing-details .dtdr-mylisting-options-container>a[data-tooltip]:before, .dtdr-sf-fields-holder .ui-widget-content .ui-widget-header, .dtdr-listings-post-dates-container.type2 .dtdr-listings-post-date-container span, .dtdr-listings-attachment-holder.type2 .dtdr-listings-attachment-box-item span, .dtdr-listings-dates-container.type3 [class*="date-container"] span, .dtdr-listings-utils-container .dtdr-listings-utils-item .dtdr-listings-date-container:hover>span, .dtdr-dashbord-ads-listing table.dtdr-custom-table tbody tr td:last-child>*, .dtdr-announcement-listing-holder.announcement h2:after, .dtdr-announcement-listing-holder.announcement a { background-color:'.$primary_color.'}';

		// Single Page Shortcode Bg

		$output .= '.dtdr-listings-sociallinks-container.type1 .dtdr-listings-sociallinks-list li a, .dtdr-listings-sociallinks-container.type2 .dtdr-listings-sociallinks-list li a, .dtdr-listings-sociallinks-container.type3 .dtdr-listings-sociallinks-list li a, .dtdr-listings-sociallinks-container.type7 .dtdr-listings-sociallinks-list li a, .dtdr-listings-sociallinks-container.type4 .dtdr-listings-sociallinks-list li a:hover, .dtdr-listings-sociallinks-container.type5 .dtdr-listings-sociallinks-list li a:hover, .dtdr-listings-sociallinks-container.type6 .dtdr-listings-sociallinks-list li a:hover, .dtdr-listings-sociallinks-container.type8 .dtdr-listings-sociallinks-list li a:hover, .dtdr-listings-average-rating-container.type2 .dtdr-listings-average-rating-holder, .dtdr-listings-average-rating-container.type2 .dtdr-listings-average-rating-overall, .dtdr-listings-average-rating-container.type2 .dtdr-listings-average-rating-reviews-count, .dtdr-listings-average-rating-container.type3 .dtdr-listings-average-rating-overall, .dtdr-listings-mls-number-container span, .dtdr-listings-mls-number-container.type3 > span:before, .dtdr-listings-featured-item-container.type2 > span, .dtdr-listings-featured-item-container.type3 > span:before, .dtdr-listings-price-container.type1 .dtdr-listings-price-label-holder ins:before, .dtdr-listings-price-container.type1 .dtdr-listings-price-label-holder del:before, .dtdr-listings-price-container.type3 .dtdr-price-currency-symbol, .dtdr-listings-price-container.type3 .dtdr-listings-price-label-holder .dtdr-listings-price-item, .dtdr-listings-dates-container.type4 .dtdr-listings-post-date-container, .dtdr-listings-dates-container.type5 .dtdr-listings-post-date-container a:hover, .dtdr-listings-contactdetails-request-container.type1 > a, .dtdr-listings-contactdetails-request-container.type2 > a:hover, .dtdr-listings-address-directions, .dtdr-listings-utils-container .dtdr-listings-utils-item .dtdr-listings-date-container:hover span:before, .dtdr-listings-utils-container .dtdr-listings-utils-item .dtdr-listings-contactdetails-list li:hover span, .dtdr-listings-utils-container .dtdr-listings-utils-item .dtdr-listings-utils-favourite-item:hover span, .dtdr-listings-utils-container .dtdr-listings-utils-item .dtdr-listings-utils-pageview-item:hover span, .dtdr-listings-utils-container .dtdr-listings-utils-item .dtdr-listings-utils-print-item:hover span, .dtdr-listings-utils-container .dtdr-listings-utils-item .dtdr-listings-social-share-item-icon:hover span, .dtdr-listings-utils-container .dtdr-listings-utils-item .dtdr-listings-social-share-container.active .dtdr-listings-social-share-item-icon span, .dtdr-listings-utils-container .dtdr-listings-utils-item .dtdr-listings-average-rating-container:hover .dtdr-listings-average-rating-overall span, .dtdr-listings-utils-container .dtdr-listings-utils-item .dtdr-listings-featured-item-container:hover span:before, [class*="dtdr-listings-utils-"] .dtdr-listings-dates-container [class*="-date-container"]:hover span:before, .dtdr-listings-contactdetails-container.type1 .dtdr-listings-contactdetails-list > li:hover span, .dtdr-announcement-listing-holder.booknow a, .dtdr-announcement-listing-holder.booknow:hover span, .dtdr-claim-form-container .dtdr-listings-claim-form .dtdr-claimform-submit-button, .dtdr-listings-dates-container.type5 [class*="date-container"], .dtdr-listings-countdown-timer-container.type1 .dtdr-countdown-wrapper .dtdr-countdown-icon-wrapper, .dtdr-listings-countdown-timer-container.type1 .dtdr-listings-countdown-timer-holder .dtdr-listings-countdown-timer-notice, .dtdr-listings-attachment-holder.type4 .dtdr-listings-attachment-box-item, .dtdr-listings-attachment-holder.type5 .dtdr-listings-attachment-box-item a:hover, .dtdr-listings-image-gallery-container .dtdr-swiper-bullet-pagination.swiper-pagination-bullets .swiper-pagination-bullet.swiper-pagination-bullet-active, .swiper-pagination-progressbar .swiper-pagination-progressbar-fill, .dtdr-swiper-scrollbar .swiper-scrollbar-drag, .dtdr-listings-image-gallery-container .dtdr-listings-swiper-pagination-holder .dtdr-swiper-fraction-pagination, .dtdr-listings-media-videos-container .dtdr-swiper-bullet-pagination.swiper-pagination-bullets .swiper-pagination-bullet.swiper-pagination-bullet-active, .swiper-pagination-progressbar .swiper-pagination-progressbar-fill, .dtdr-swiper-scrollbar .swiper-scrollbar-drag, .dtdr-listings-media-videos-container .dtdr-listings-swiper-pagination-holder .dtdr-swiper-fraction-pagination, .dtdr-listings-media-videos-container.swiper-container div[class*="dtdr-swiper-arrow-pagination"].type1 a[class*="dtdr-swiper-arrow-"]:after, .dtdr-sf-others-field-holder div.dtdr-sf-others-list div.active, .ui-datepicker th, .single-dtdr_packages .dtdr-payment-details a.added_to_cart, .dtdr-sf-fields-holder .ui-state-default, .dtdr-sf-fields-holder .ui-widget-content .ui-state-default, .dtdr-listings-taxonomy-container.type5 .dtdr-listings-taxonomy-list li a:before, .dtdr-listings-post-dates-container.type4 .dtdr-listings-post-date-container, .dtdr-listings-claim-form>.dtdr-listings-claim-form-item input#dtdr-claimform-verification-file:hover+label { background-color:'.$primary_color.'}';

		// Shortcode Border Color
		
		$output .= '.dtdr-listings-item-wrapper.type2 .dtdr-listings-item-bottom-section-content > div.dtdr-listings-item-bottom-pricing-holder .custom-button-style:hover, .dtdr-listings-item-wrapper.type3 .dtdr-listings-item-bottom-section a.custom-button-style:hover, .dtdr-packages-item-wrapper.type1 .dtdr-packagelist-view-details-button:hover, .dtdr-packages-item-wrapper.type1 .dtdr-item-status-details .dtdr-proceed-button .custom-button-style:hover,  .dtdr-packages-item-wrapper.type1 .dtdr-item-status-details .dtdr-proceed-button .added_to_cart:hover, .dtdr-sf-orderby-field-holder ul.dtdr-sf-orderby-list li a:hover, .dtdr-sf-orderby-field-holder ul.dtdr-sf-orderby-list li a.active, .dtdr-sf-fields-holder .ui-widget-content .ui-state-default.ui-state-active, .dtdr-login-form-container p input:focus, .dtdr-sf-others-field-holder div.dtdr-sf-others-list div:hover, .dtdr-sf-others-field-holder div.dtdr-sf-others-list div.active, .dtdr-dashbord-ads-listing table.dtdr-custom-table tbody tr td:last-child a:hover, .comment-form .dtdr-comment-form-fields-holder input:focus, .comment-form .dtdr-comment-form-fields-holder textarea:focus, .dtdr-listings-contactform input:focus, .dtdr-listings-contactform textarea:focus, .logged-in .comment-form p>input:not(#dtdr_media):focus, .logged-in .comment-form p>textarea:focus, .dtdr-sf-fields-holder input[type="text"]~span:not(.dtdr-detect-location), form.lidd_mc_form .lidd_mc_input input[type="text"] ~ span:not(#lidd_mc_total_amount-error) { border-color:'.$primary_color.'}';

		// Single Page Shortcode Border Color

		$output .= '.dtdr-listings-sociallinks-container.type4 .dtdr-listings-sociallinks-list li a, .dtdr-listings-sociallinks-container.type5 .dtdr-listings-sociallinks-list li a, .dtdr-listings-sociallinks-container.type6 .dtdr-listings-sociallinks-list li a, .dtdr-listings-sociallinks-container.type4 .dtdr-listings-sociallinks-list li a:hover, .dtdr-listings-sociallinks-container.type5 .dtdr-listings-sociallinks-list li a:hover, .dtdr-listings-sociallinks-container.type6 .dtdr-listings-sociallinks-list li a:hover, .dtdr-listings-sociallinks-container.type8 .dtdr-listings-sociallinks-list li a, .dtdr-listings-contactdetails-request-container.type2 > a, .dtdr-listings-contactdetails-request-container.type3 > a, .dtdr-announcement-listing-holder.booknow, .dtdr-announcement-listing-holder.contactus, .dtdr-announcement-listing-holder.contactus a, .dtdr-announcement-listing-holder.booknow  a, .dtdr-claim-form-container .dtdr-listings-claim-form textarea:focus, .dtdr-listings-dates-container.type4 [class*="date-container"], .dtdr-listings-attachment-holder.type3 .dtdr-listings-attachment-box-item, .dtdr-listings-image-gallery-holder .dtdr-listings-image-gallery-thumb-container .dtdr-listings-image-gallery-thumb .swiper-slide-active:after, .dtdr-listings-media-videos-holder .dtdr-listings-media-videos-thumb-container .dtdr-listings-media-videos-thumb .swiper-slide-active:after, .dtdr-listings-media-videos-container.swiper-container div[class*="dtdr-swiper-arrow-pagination"].type1 a[class*="dtdr-swiper-arrow-"]:last-child:before, .dtdr-listings-media-videos-container.swiper-container div[class*="dtdr-swiper-arrow-pagination"].type1 a[class*="dtdr-swiper-arrow-"]:first-child:before { border-color:'.$primary_color.'}';

		// Shortcode Box Shadow Color
		
		$output .= '.dtdr-packages-item-wrapper.type2 .dtdr-item-status-details .custom-button-style, .dtdr-packages-item-wrapper.type2 .dtdr-item-status-details .added_to_cart, .dtdr-packages-item-wrapper.type3 .dtdr-item-status-details .custom-button-style, .dtdr-packages-item-wrapper.type3 .dtdr-item-status-details .added_to_cart, .dtdr-packages-item-wrapper.type3 .dtdr-packagelist-view-details .custom-button-style, .dtdr-packages-item-wrapper.type3 .dtdr-item-status-details .dtdr-purchased,
		.dtdr-listings-item-wrapper.type3:not(.dtdr-list) .dtdr-listings-item-top-section div.dtdr-listings-item-ad-section:before,
		.dtdr-listings-item-wrapper.type3:not(.dtdr-list) .dtdr-listings-item-top-section div.dtdr-listings-featured-item-container a { box-shadow: inset 0 0 0 2px '.$primary_color.' }';

		// Remove this set, if you wish to change the Default values as like your theme
		
		$output .= 'input[type="submit"], button, input[type="button"], input[type="reset"] { background-color:'.$primary_color.'}';
		$output .= 'input[type="text"]:focus, input[type="text"]:active, input[type="password"]:focus, input[type="password"]:active, input[type="email"]:focus, input[type="email"]:active, input[type="url"]:focus, input[type="url"]:active, input[type="tel"]:focus, input[type="tel"]:active, input[type="number"]:focus, input[type="number"]:active, input[type="range"]:focus, input[type="range"]:active, input[type="date"]:focus, input[type="date"]:active, textarea:focus, textarea:active, input.text:focus, input.text:active, input[type="search"]:focus, input[type="search"]:active { border-color:'.$primary_color.'}';


		// Secondary
		$output .= 'a:hover, .dtdr-dashbord-container .dtdr-my-listings-container .dtdr-listing-dashboard-status:after, .dtdr-dashbord-container .dtdr-packages-container .dtdr-packages-item-wrapper .dtdr-packagelist-details .dtdr-item-status-details .dtdr-purchased:after, .dtdr-dashbord-container .dtdr-packages-container .dtdr-packages-item-wrapper .dtdr-packagelist-details .dtdr-item-status-details .dtdr-active:after, .dtdr-listings-item-wrapper:hover .dtdr-listings-item-bottom-section-content>div .dtdr-listings-price-container .dtdr-listings-price-label-holder ins, ul.dtdr-dashboard-menus li a:hover, ul.dtdr-dashboard-menus li a.dtdr-active, .dtdr-packages-item-wrapper .dtdr-item-status-details .dtdr-purchased:after, .dtdr-listings-item-wrapper.type3 .dtdr-listings-item-bottom-section-content > div .dtdr-listings-price-container .dtdr-listings-price-label-holder ins, .dtdr-listings-item-wrapper.type5 .dtdr-listings-item-bottom-section a.custom-button-style:hover, .dtdr-listings-item-wrapper.type6.has-post-thumbnail .dtdr-listings-item-bottom-section .dtdr-listings-item-bottom-section-content a:hover, .dtdr-custom-login li a:hover, .dtdr-listing-taxonomy-item .dtdr-listing-taxonomy-meta-data h3 a:hover, .dtdr-listings-comment-list-holder .commentlist li.comment .comment-body .reply a.comment-reply-link:hover, .dtdr-packages-item-wrapper .dtdr-packagelist-details > h5 a:hover,
		.dtdr-listings-item-wrapper .dtdr-listings-item-bottom-section-content .dtdr-listings-item-title a:hover, .dtdr-listings-item-wrapper.type7 .dtdr-listings-item-bottom-section .dtdr-listings-item-title a:hover, .dtdr-user-list-item .dtdr-user-item-meta-data h4 a:hover, .dtdr-user-list-item.type2 .dtdr-user-contactdetails-list li a:hover, .dtdr-user-list-item.type3 .dtdr-user-sociallinks-list li a:hover, .dtdr-user-list-item.type3 .dtdr-user-contactdetails-list li a:hover, .dtdr-listings-item-wrapper.type3 .dtdr-listings-taxonomy-container li a:hover, .dtdr-listings-taxonomy-container.type3 li a:hover, .dtdr-listings-contactdetails-container .dtdr-listings-contactdetails-list > li a:hover, p.tpl-forget-pwd a:hover, .dtdr-listings-item-wrapper.type5 .dtdr-listings-item-bottom-section-content > div .dtdr-listings-utils-item-holder a:hover, .dtdr-listings-item-wrapper.type7 .dtdr-listings-item-bottom-section-content .dtdr-listings-item-bottom-right-content .dtdr-listings-utils-item-holder a:hover, .dtdr-listings-item-wrapper.type1.has-post-thumbnail .dtdr-listings-item-top-section .dtdr-listings-item-top-section-content .dtdr-listings-utils-item-holder > div a:hover, .dtdr-dashbord-recent-activites-holder .dtdr-dashbord-recent-activites-content p a:hover, .dtdr-dashbord-container .dtdr-my-listings-container .dtdr-listing-details h5 a:hover, .dtdr-dashbord-container .dtdr-my-listings-container .dtdr-listing-dashboard-owner a:hover, .dtdr-listings-item-wrapper.type5 .dtdr-listings-item-bottom-section-content > div .dtdr-listings-utils-item-holder [class*="dtdr-listings-utils-"] a.dtdr-listings-utils-favourite-item span:hover, .dtdr-listings-item-wrapper.type1:not(.has-post-thumbnail) .dtdr-listings-item-top-section .dtdr-listings-item-top-section-content .dtdr-listings-utils-item-holder .dtdr-listings-utils-item:first-child>* span:hover, .dtdr-listings-item-wrapper.type1:not(.has-post-thumbnail) .dtdr-listings-item-top-section .dtdr-listings-item-top-section-content .dtdr-listings-utils-item-holder > div a:hover, .dtdr-listings-item-wrapper.type1.has-post-thumbnail .dtdr-listings-item-top-section .dtdr-listings-item-top-section-content > div.dtdr-listings-utils-item-holder .dtdr-listings-utils-item > * > span:hover, .dtdr-listings-social-share-container.type1 .dtdr-listings-social-share-list li a:hover span { color:'.$secondary_color.'}';

		// Single Page Shortcode color

		$output .= '.dtdr-listings-social-share-container .dtdr-listings-social-share-list li a:hover, .dtdr-listings-social-share-container .dtdr-listings-social-share-list li a:hover, .dtdr-user-list-item.type3 .dtdr-user-item-meta-data .dtdr-listings-social-share-container .dtdr-listings-social-share-list li a:hover { color:'.$secondary_color.'}';

		// Single Page Shortcode color Ends

		$output .= 'ul.dtdr-dashboard-menus li a:hover span, ul.dtdr-dashboard-menus li a.dtdr-active span, .dtdr-dashbord-container .dtdr-my-listings-container .dtdr-listing-dashboard-status, .dtdr-dashbord-container .dtdr-my-listings-container .dtdr-listing-details .dtdr-mylisting-options-container > a:hover, .custom-button-style:hover, .dtdr-dashbord-container .dtdr-packages-container .dtdr-packages-item-wrapper .dtdr-packagelist-details .dtdr-item-status-details .dtdr-purchased, .dtdr-dashbord-container .dtdr-packages-container .dtdr-packages-item-wrapper .dtdr-packagelist-details .dtdr-item-status-details .dtdr-active, .dtdr-dashboard-container .woocommerce-button.view:hover, .dtdr-dashbord-container .dtdr-packages-container .dtdr-packages-item-wrapper .dtdr-packagelist-details .dtdr-item-status-details .dtdr-proceed-button a.custom-button-style:hover, .dtdr-packages-item-wrapper .dtdr-item-status-details .dtdr-purchased, .dtdr-listings-item-wrapper .dtdr-listings-features-box-item>div.dtdr-listings-features-box-item-title:first-child:before, .dtdr-listings-item-wrapper.type6:hover .dtdr-listings-item-bottom-section .dtdr-listings-utils-item-holder a.dtdr-listings-utils-favourite-item, .dtdr-user-list-item.type1 .dtdr-user-sociallinks-list li a:hover, div[class*="-output-data-container"] .dtdr-swiper-pagination-holder .dtdr-swiper-bullet-pagination.swiper-pagination-bullets .swiper-pagination-bullet, .dtdr-dashbord-inbox-listing-conversation-wrapper ul.dtdr-dashbord-inbox-conversation-list li a.dtdr-dashbord-inbox-conversation-reply-loader:hover, .dtdr-dashbord-inbox-listing-conversation-wrapper ul.dtdr-dashbord-inbox-conversation-list li .dtdr-dashbord-inbox-conversation-reply-wrapper .dtdr-inbox-conversation-reply-submit:hover, div[class*="-apply-isotope"] div[class*="-isotope-filter"] a:hover, div[class*="-apply-isotope"] div[class*="-isotope-filter"] a.active-sort, .dtdr-listings-contactform a.dtdr-contactform-submit-button:hover, .dtdr-listings-floorplan-top-section .dtdr-listings-floorplan-expand-bottom-section:hover, .dtdr-announcement-listing-holder a:hover, .single-dtdr_packages .dtdr-payment-details a.added_to_cart:hover, form.lidd_mc_form .lidd_mc_input input[type="submit"]:hover, .comment-form .dtdr-comment-form-fields-holder p.form-submit input[type="submit"]:hover, .logged-in .dtdr-listings-comment-list-holder p.form-submit input[type="submit"]:hover, #loginform .login-submit input[type="submit"]:hover, .dtdr-listings-contactdetails-request-container.type2 > a:hover, .dtdr-listings-claim-wrapper .dtdr-listings-claim-item:hover, .dtdr-listings-post-dates-container.type2 .dtdr-listings-post-date-container:hover span, .dtdr-dashbord-ads-listing table.dtdr-custom-table tbody tr td:last-child > a:hover, .dtdr-claim-form-container .dtdr-listings-claim-form .dtdr-claimform-submit-button:hover, .dismissButton:hover:hover, .dtdr-announcement-listing-holder.announcement a:hover { background-color:'.$secondary_color.'}';

		// Single Page Shortcode BG Color

		$output .= '.dtdr-listings-sociallinks-container.type1 .dtdr-listings-sociallinks-list li a:hover, .dtdr-listings-sociallinks-container.type2 .dtdr-listings-sociallinks-list li a:hover, .dtdr-listings-sociallinks-container.type3 .dtdr-listings-sociallinks-list li a:hover, .dtdr-listings-sociallinks-container.type7 .dtdr-listings-sociallinks-list li a:hover, .dtdr-listings-average-rating-container.type3, .dtdr-listings-mls-number-container.type3 > span, .dtdr-listings-featured-item-container.type3 > span, .dtdr-listings-price-container.type2 .dtdr-listings-price-label-holder .dtdr-listings-price-item, .dtdr-listings-dates-container.type4 .dtdr-listings-post-date-container:hover, .dtdr-listings-contactdetails-request-container > a:hover, .dtdr-listings-contactdetails-request-container.type3 > a:hover, .dtdr-listings-address-directions:hover, .dtdr-listings-contactdetails-container.type2 .dtdr-listings-contactdetails-list > li:hover span, .dtdr-claim-form-container .dtdr-listings-claim-form .dtdr-claimform-submit-button:hover, .dtdr-listings-dates-container.type3 [class*="date-container"]:hover span, .dtdr-listings-dates-container.type4 [class*="date-container"]:hover, .dtdr-listings-dates-container.type5 [class*="date-container"]:hover, .dtdr-listings-attachment-holder.type2 .dtdr-listings-attachment-box-item:hover span, .dtdr-listings-attachment-holder.type3 .dtdr-listings-attachment-box-item:hover, .dtdr-listings-attachment-holder.type4 .dtdr-listings-attachment-box-item:hover,.dtdr-listings-image-gallery-container .dtdr-swiper-bullet-pagination.swiper-pagination-bullets .swiper-pagination-bullet, .dtdr-listings-media-videos-container .dtdr-swiper-bullet-pagination.swiper-pagination-bullets .swiper-pagination-bullet, .dtdr-listings-item-wrapper.type4 .dtdr-listings-item-top-section .dtdr-listings-item-top-section-content > div.dtdr-listings-utils-item-holder .dtdr-listings-utils-item > *:hover, .dtdr-listings-item-wrapper.type4 .dtdr-listings-item-top-section .dtdr-listings-item-top-section-content > div:not(.dtdr-listings-taxonomy-container) a.dtdr-listings-utils-favourite-item:hover span,
		.dtdr-listings-item-wrapper.type4 .dtdr-listings-item-top-section .dtdr-listings-item-top-section-content > div a:hover, .dtdr-listings-item-wrapper.type6:not(.has-post-thumbnail):hover .dtdr-listings-item-top-section div.dtdr-listings-item-ad-section, .dtdr-listings-item-wrapper.type6:not(.has-post-thumbnail):hover .dtdr-listings-item-top-section div.dtdr-listings-featured-item-container a { background-color:'.$secondary_color.'}';

		$output .= '.dtdr-listings-author-container[class*=swiper-container-] .dtdr-listings-author-details-holder:hover, .dtdr-announcement-listing-holder.contactus a:hover, .dtdr-listings-contactdetails-request-container.type2 > a:hover, .dtdr-listings-contactdetails-request-container.type3 > a:hover, .dtdr-listings-attachment-holder.type3 .dtdr-listings-attachment-box-item:hover, .dtdr-listings-dates-container.type4 [class*="date-container"]:hover, .dismissButton:hover:hover { border-color:'.$secondary_color.'}';

		// Remove this set, if you wish to change the Input values as like your theme
		$output .= 'input[type="submit"]:hover, button:hover, input[type="button"]:hover, input[type="reset"]:hover { background-color:'.$secondary_color.'}';


		// Tertiary

		$output .= '.dtdr-packages-item-wrapper.type2 .dtdr-packagelist-view-details .custom-button-style, .dtdr-listings-item-wrapper.type6:not(.has-post-thumbnail) .dtdr-listings-item-bottom-section .dtdr-listings-utils-item-holder, .dtdr-listings-item-wrapper.type2 .dtdr-listings-item-top-section .dtdr-listings-featured-item-container a:before, .dtdr-listings-item-wrapper.type5:hover .dtdr-listings-item-top-section .dtdr-listings-featured-item-container:before, .comment-form .dtdr-comment-form-fields-holder>p.comment-form-cookies-consent input[type="checkbox"]~label:before, .single-dtdr_packages .dtdr_packages>img, .dtdr-listings-social-share-container .dtdr-listings-social-share-list:before, .dtdr-listings-item-wrapper.type1 .dtdr-listings-item-top-section .dtdr-listings-item-top-section-content .dtdr-listings-utils-item-holder>div a:hover, .dtdr-listings-item-wrapper.type5:hover .dtdr-listings-item-top-section .dtdr-listings-featured-item-container a:before, .dtdr-user-list-item.type3 .dtdr-user-item-meta-data .dtdr-listings-social-share-container .dtdr-listings-social-share-list:before, p.login-remember input[type="checkbox"]~label:before { color:'.$tertiary_color.'}';

		$output .= '.dtdr-packages-item-wrapper h5:before, .dtdr-listings-item-wrapper.type1:hover .dtdr-listings-item-bottom-section-content .custom-button-style.dtdr-listing-view-details, .dtdr-listings-item-wrapper.type4 .dtdr-listings-item-bottom-section>div.dtdr-listings-item-bottom-pricing-holder .custom-button-style, .dtdr-listings-item-wrapper.type8 .dtdr-listings-item-bottom-section ul.dtdr-listings-taxonomy-list li a, .dtdr-listings-item-wrapper.type4 .dtdr-listings-item-top-section .dtdr-listings-item-top-section-content>div a, .dtdr-listings-item-wrapper.type4 .dtdr-listings-item-top-section .dtdr-listings-item-top-section-content>div.dtdr-listings-utils-item-holder .dtdr-listings-utils-item>*, .dtdr-listings-item-wrapper.type6:not(.has-post-thumbnail):hover .dtdr-listings-item-bottom-section .dtdr-listings-utils-item-holder a.dtdr-listings-utils-favourite-item, .dtdr-sf-pricerange-field-holder > div > div[class*="-handle"], .dtdr-sf-features-field-holder > div > div[class*="-handle"], .dtdr-sf-features-field-holder .ui-widget.ui-widget-content .ui-widget-header, .dtdr-swiper-arrow-pagination a:hover, .dtdr-marker-addition-info.dtdr-marker-addition-info-totalviews, .dtdr-marker-addition-info.dtdr-marker-addition-info-averageratings, .dtdr-marker-addition-info.dtdr-marker-addition-info-startdate, .dtdr-marker-addition-info.dtdr-marker-addition-info-distance, .dtdr-listing-taxonomy-item.type7 .dtdr-listing-taxonomy-starting-price:after, .dtdr-listings-item-wrapper:hover .dtdr-listings-item-top-section .dtdr-listings-item-ad-section, .dtdr-listings-item-wrapper:hover .dtdr-listings-item-top-section .dtdr-listings-featured-item-container a, .dtdr-listings-item-wrapper.type7 .dtdr-listings-item-top-section .dtdr-listings-item-ad-section, .dtdr-listings-item-wrapper.type7 .dtdr-listings-item-top-section .dtdr-listings-featured-item-container, .dtdr-listings-item-wrapper.type3 .dtdr-listings-item-top-section div.dtdr-listings-item-ad-section:after, .dtdr-listings-item-wrapper.type3 .dtdr-listings-item-top-section div.dtdr-listings-featured-item-container a:after, .dtdr-listings-item-wrapper.type3:hover .dtdr-listings-item-top-section div.dtdr-listings-item-ad-section:before, .dtdr-listings-item-wrapper.type3:hover .dtdr-listings-item-top-section div.dtdr-listings-featured-item-container a:before, .dtdr-listings-floorplan-top-section, .dtdr-listings-contactdetails-request-container.type3 > a, .dtdr-listings-contactdetails-container.type2 .dtdr-listings-contactdetails-list > li span, .dtdr-announcement-listing-holder.contactus:hover, .dtdr-listings-dates-container.type4 [class*="date-container"], .dtdr-listings-countdown-timer-container.type2 .dtdr-listings-countdown-timer-holder .dtdr-listings-countdown-timer-notice span, .dtdr-listings-attachment-holder.type2 .dtdr-listings-attachment-box-item:hover span, .dtdr-listings-attachment-holder.type3 .dtdr-listings-attachment-box-item, .dtdr-listings-image-gallery-container .dtdr-listings-swiper-pagination-holder .dtdr-swiper-progress-pagination, .dtdr-listings-image-gallery-container .dtdr-listings-swiper-pagination-holder .dtdr-swiper-scrollbar, .dtdr-listings-media-videos-container .dtdr-listings-swiper-pagination-holder .dtdr-swiper-progress-pagination, .dtdr-listings-media-videos-container .dtdr-listings-swiper-pagination-holder .dtdr-swiper-scrollbar, .dtdr-packages-item-wrapper:before, .single-dtdr_packages .dtdr-packagelist-items h3:before, .single-dtdr_packages .dtdr-payment-details .dtdr-item-status-details>span, .dtdr-listings-item-wrapper.type2:hover .dtdr-listings-item-top-section div.dtdr-listings-item-ad-section:after, .dtdr-listings-social-share-container .dtdr-listings-social-share-list, .dtdr-listings-item-wrapper.type2:hover .dtdr-listings-item-top-section div.dtdr-listings-item-ad-section:before, .dtdr-sf-fields-holder.dtdr-sf-pricerange-field-holder .ui-widget.ui-widget-content, .dtdr-listing-taxonomy-item.type6 .dtdr-category-total-items a:hover, .dtdr-comment-form-fields-holder input#dtdr_media+label, .dtdr-user-list-item.type3 .dtdr-user-contactdetails-list li:hover span, .dtdr-user-list-item.type3 .dtdr-user-item-meta-data .dtdr-listings-social-share-container.active .dtdr-listings-social-share-list, .dtdr-listings-features-box-container.type5 .dtdr-listings-features-box-item, .dtdr-announcement-listing-holder, .dtdr-listings-item-wrapper.type4 .dtdr-listings-item-top-section .dtdr-listings-item-top-section-content > div:not(.dtdr-listings-taxonomy-container) a.dtdr-listings-utils-favourite-item span, .dtdr-listings-item-wrapper.type6 .dtdr-listings-item-bottom-section .dtdr-listings-utils-item-holder a.dtdr-listings-utils-favourite-item span:hover, .dtdr-sf-fields-holder .ui-widget.ui-widget-content, .dtdr-listings-post-dates-container.type3 .dtdr-listings-post-date-container, .dtdr-dashbord-section-holder-content ul.dtdr-dashbord-inbox-listing-messages-wrapper li.active, .dtdr-dashbord-section-holder-content ul.dtdr-dashbord-inbox-listing-messages-wrapper li:hover, .dtdr-listings-business-hours-container .dtdr-listings-business-hours-currenttime, .dtdr-listings-claim-form > .dtdr-listings-claim-form-item input#dtdr-claimform-verification-file + label { background-color:'.$tertiary_color.'}';

		// Single Page Shortcode Border Color

		$output .= '.dtdr-listings-nearby-places-container .dtdr-listings-nearby-places-item:not(:last-child), .dtdr-listings-author-container .dtdr-listings-author-details-holder, .dtdr-packages-item-wrapper.type2 .dtdr-packagelist-details, #primary.page-with-sidebar .dtdr-packages-item-wrapper.type2 .dtdr-packagelist-details, .dtdr-listings-features-box-container:not(.listing).type7 .dtdr-listings-features-box-item { border-color:'.$tertiary_color.'}';

		// Single Page Shortcode Border Color Ends

		$output .= '.dtdr-user-list-item.type3 .dtdr-user-contactdetails-list li span, .dtdr-listings-author-container .dtdr-listings-author-details-holder .dtdr-listings-author-details .dtdr-listings-contactdetails-list li span { box-shadow: inset 0 0 0 2px '.$tertiary_color.' }';

		// RGBA Colors

		$output .= '.dtdr-listings-media-videos-container.swiper-container div[class*="dtdr-swiper-arrow-pagination"].type2 > a[class*="dtdr-swiper-arrow"] { background-color:rgba('.$primary_color_rgba.', 0.5)}';

		$output .= '.dtdr-listings-media-videos-container.swiper-container div[class*="dtdr-swiper-arrow-pagination"].type2>a[class*="dtdr-swiper-arrow"]:hover, .dtdr-listings-image-gallery-container.swiper-container div[class*="dtdr-swiper-arrow-pagination"].type2>a[class*="dtdr-swiper-arrow"]:hover { background-color:rgba('.$primary_color_rgba.', 0.6)}';

		$output .= '.dtdr-listings-image-gallery-container.swiper-container div[class*="dtdr-swiper-arrow-pagination"].type2>a[class*="dtdr-swiper-arrow"] { background-color:rgba('.$primary_color_rgba.', 0.15)}';

		$output .= '.lidd_mc_details .lidd_mc_summary p:not(:last-child), .lidd_mc_details .lidd_mc_results p, .dtdr-listing-taxonomy-item.type4:hover, .dtdr-listing-taxonomy-item.type4:hover .dtdr-listing-taxonomy-starting-price, .dtdr-user-list-item.type2 .dtdr-user-image img, .dtdr-dashbord-section-holder-content ul.dtdr-dashbord-inbox-listing-messages-wrapper li:hover span, .dtdr-dashbord-section-holder-content ul.dtdr-dashbord-inbox-listing-messages-wrapper li.active span { border-color:rgba('.$secondary_color_rgba.', 0.2)}';

		$output .= '.dtdr-dashbord-container .dtdr-packages-container .dtdr-packages-item-wrapper:hover, .dtdr-dashbord-container .dtdr-my-listings-container .dtdr-listing-item-wrapper:hover { background-color:rgba('.$tertiary_color_rgba.', 0.135)}';

		$output .= '.lidd_mc_details, .dtdr-listing-taxonomy-item.type4:hover, .dtdr-listings-nearby-places-container:hover .dtdr-listings-nearby-places-item .dtdr-listings-nearby-places-image { background-color:rgba('.$tertiary_color_rgba.', 0.5)}';


		wp_register_style ( 'dtdr-skin', false );
		wp_add_inline_style( 'dtdr-skin', $output );

		wp_enqueue_style ( 'dtdr-skin' );

	}

	add_action( 'wp_enqueue_scripts', 'dtdr_generate_skin_colors', 140 );

}

?>