<?php

// Schedule event to seller listings status
if( !function_exists('dtdr_ad_module_setup_daily_user_schedule') ) {
    function  dtdr_ad_module_setup_daily_user_schedule() {
    	wp_clear_scheduled_hook('dtdr_ad_module_check_for_users_event');
        if ( ! wp_next_scheduled( 'dtdr_ad_module_check_for_users_event' ) ) {
            wp_schedule_event( time(), 'twicedaily', 'dtdr_ad_module_check_for_users_event');
        }
    }
}

// Check seller listings status
add_action( 'dtdr_ad_module_check_for_users_event', 'dtdr_ad_module_check_user_membership_status' );
if( !function_exists('dtdr_ad_module_check_user_membership_status') ) {
    function dtdr_ad_module_check_user_membership_status(){

		// For Ad

		$listings_args = array (
			'posts_per_page' => -1,
			'post_type'      => 'dtdr_listings',
			'post_status'    => 'publish',
			'fields'		 => 'ids'
		);
		$listings = get_posts( $listings_args );
		wp_reset_postdata();

		if(is_array($listings) && !empty($listings)) {
			foreach($listings as $listing) {

				$dtdr_ad_campaigns      = get_post_meta($listing, 'dtdr_ad_campaigns', true);
				$dtdr_ad_process_status = get_post_meta($listing, 'dtdr_ad_process_status', true);
				$dtdr_enddate           = get_post_meta($listing, 'dtdr_enddate', true);

				if($dtdr_ad_campaigns != '' && is_array($dtdr_ad_campaigns) && !empty($dtdr_ad_campaigns) && $dtdr_ad_process_status == 'active') {

					$current_timestamp = strtotime(current_time(get_option('date_format')));
					if($current_timestamp > $dtdr_enddate) {

						delete_post_meta($listing, 'dtdr_ad_campaigns');
						delete_post_meta($listing, 'dtdr_limelight');
						delete_post_meta($listing, 'dtdr_singlepage');
						delete_post_meta($listing, 'dtdr_topofsearch');
						delete_post_meta($listing, 'dtdr_ad_process_status');
						delete_post_meta($listing, 'dtdr_ad_status');
						delete_post_meta($listing, 'dtdr_startdate');
						delete_post_meta($listing, 'dtdr_enddate');

					}

				}

			}
		}

    }
}

?>