<?php

if (!class_exists ( 'DTDirectoryRegisterAdsModule' )) {

	class DTDirectoryRegisterAdsModule extends DTDirectoryAddon {

		private $module_name;
		private $module_url;

		/**
		 * Instance variable
		 */
		private static $_instance = null;

		/**
		 * Instance
		 *
		 * Ensures only one instance of the class is loaded or can be loaded.
		 */
		public static function instance() {

			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}

			return self::$_instance;
		}

		function __construct() {

			$this->dtdr_define_constants( 'DTDR_ADS_PLUGIN_PATH', DTDR_PLUGIN_PATH . 'modules/ads/' );
			$this->dtdr_define_constants( 'DTDR_ADS_PLUGIN_URL', DTDR_PLUGIN_URL . 'modules/ads/' );

			add_action ( 'admin_notices', array( $this, 'dtdr_pb_plugin_notice' ) );

			add_action ( 'wp_enqueue_scripts', array ( $this, 'dtdr_enqueue_scripts' ), 130 );
			add_filter ( 'dtdr_settings', array ( $this, 'dtdr_add_settings' ) );

			require_once DTDR_ADS_PLUGIN_PATH . 'shortcode-listings-listing.php';
			require_once DTDR_ADS_PLUGIN_PATH . 'shortcode-output-data-container.php';
			require_once DTDR_ADS_PLUGIN_PATH . 'shortcodes.php';

			require_once DTDR_ADS_PLUGIN_PATH . 'dashboard.php';
			require_once DTDR_ADS_PLUGIN_PATH . 'utils-woocommerce.php';
			require_once DTDR_ADS_PLUGIN_PATH . 'events.php';

		}

		function dtdr_pb_plugin_notice() {

			if ( !class_exists( 'WooCommerce' ) ) {

				echo '<div class="updated notice is-dismissible">';
					echo '<p>';
						echo sprintf(esc_html__('%1$s - %2$s requires %3$s plugin to be installed and activated on your site.','dtdr'), '<strong>'.DTDR_PLUGIN_NAME.'\'s</strong>', '<strong>'.esc_html__('Ads Module', 'dtdr').'</strong>', '<strong><a href="https://wordpress.org/plugins/woocommerce/" target="_blank">'.esc_html__('WooCommerce', 'dtdr').'</a></strong>' );
					echo '</p>';
					echo '<button type="button" class="notice-dismiss">';
						echo '<span class="screen-reader-text">'.esc_html__('Dismiss this notice.','dtdr').'</span>';
					echo '</button>';
				echo '</div>';

			}

		}

		function dtdr_enqueue_scripts() {

			$this->dtdr_register_dependent_files();

			if(is_page_template('tpl-dashboard.php')) {
				wp_enqueue_style ( 'dtdr-ads-dashboard' );

				wp_enqueue_script ( 'dtdr-ads-dashboard' );
			}

		}

		function dtdr_register_dependent_files() {

			wp_register_style ( 'dtdr-ads-dashboard', DTDR_ADS_PLUGIN_URL . 'assets/ads-dashboard.css', array ( 'dtdr-dashboard-frontend' ) );

			wp_register_script ( 'dtdr-ads-dashboard', DTDR_ADS_PLUGIN_URL . 'assets/dashboard.js', array ('jquery', 'dtdr-dashboard-frontend'), false, true );

		}

		function dtdr_add_settings($tabs) {

			$tabs['ads'] = array (
				'label' => esc_html__('Ads', 'dtdr'),
				'path' => DTDR_ADS_PLUGIN_PATH . 'settings.php'
			);

			return $tabs;

		}

	}

}

if( !function_exists('dtdrAdsModule') ) {
	function dtdrAdsModule() {
		return DTDirectoryRegisterAdsModule::instance();
	}
}

dtdrAdsModule();

?>