<?php

function dtdr_settings_ads_content() {

	$output = '';

	$listing_singular_label = apply_filters( 'listing_label', 'singular' );
	$listing_plural_label = apply_filters( 'listing_label', 'plural' );

	$output .= '<form name="formOptionSettings" class="formOptionSettings" method="post">';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.esc_html__( 'Limelight Ads', 'dtdr') .'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';
				$checked = ( 'true' ==  dtdr_option('ads','enable-limelight-ads') ) ? ' checked="checked"' : '';
				$switchclass = ( 'true' ==  dtdr_option('ads','enable-limelight-ads') ) ? 'checkbox-switch-on' :'checkbox-switch-off';
				$output .= '<div data-for="enable-limelight-ads" class="dtdr-checkbox-switch '.$switchclass.'"></div>';
				$output .= '<input id="enable-limelight-ads" class="hidden" type="checkbox" name="dtdr[ads][enable-limelight-ads]" value="true" '.$checked.' />';
			$output .= '</div>';
		$output .= '</div>';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.esc_html__( 'Limelight Ads - Associated Product', 'dtdr' ).'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';

				$limelight_ads_product = dtdr_option('ads','limelight-ads-product');

				$product_args = array(
					'post_type' 		=> array( 'product' ),
					'posts_per_page' 	=> -1,
					'orderby'         	=> 'title',
					'order'           	=> 'ASC',
					'post_status'		=> array( 'publish' ),
					'suppress_filters' 	=> 0
				);
				$products_list = get_posts( $product_args );

				$output .= '<select name="dtdr[ads][limelight-ads-product]" id="limelight-ads-product" class="dtdr-chosen-select">';
					$output .= '<option value="">'.esc_html__( 'None', 'dtdr' ).'</option>';
					foreach($products_list as $product) {
						$output .= '<option value="'.$product->ID.'" '.selected( $limelight_ads_product, $product->ID, false ).'>'.esc_html($product->post_title).'</option>';
					}
				$output .= '</select>';

				$output .= '<div class="dtdr-note">'.esc_html__('Product that you like to use for limelight ads. Amount added in product will be treated as per day amount. Purhcasing that product will enable you the limelight ads.', 'dtdr').'</div>';

			$output .= '</div>';
		$output .= '</div>';


		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.esc_html__( 'Single Page Ads', 'dtdr') .'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';
				$checked = ( 'true' ==  dtdr_option('ads','enable-singlepage-ads') ) ? ' checked="checked"' : '';
				$switchclass = ( 'true' ==  dtdr_option('ads','enable-singlepage-ads') ) ? 'checkbox-switch-on' :'checkbox-switch-off';
				$output .= '<div data-for="enable-singlepage-ads" class="dtdr-checkbox-switch '.$switchclass.'"></div>';
				$output .= '<input id="enable-singlepage-ads" class="hidden" type="checkbox" name="dtdr[ads][enable-singlepage-ads]" value="true" '.$checked.' />';
			$output .= '</div>';
		$output .= '</div>';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.esc_html__( 'Single Page Ads - Associated Product', 'dtdr' ).'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';

				$singlepage_ads_product = dtdr_option('ads','singlepage-ads-product');

				$product_args = array(
					'post_type' 		=> array( 'product' ),
					'posts_per_page' 	=> -1,
					'orderby'         	=> 'title',
					'order'           	=> 'ASC',
					'post_status'		=> array( 'publish' ),
					'suppress_filters' 	=> 0
				);
				$products_list = get_posts( $product_args );

				$output .= '<select name="dtdr[ads][singlepage-ads-product]" id="singlepage-ads-product" class="dtdr-chosen-select">';
					$output .= '<option value="">'.esc_html__( 'None', 'dtdr' ).'</option>';
					foreach($products_list as $product) {
						$output .= '<option value="'.$product->ID.'" '.selected( $singlepage_ads_product, $product->ID, false ).'>'.esc_html($product->post_title).'</option>';
					}
				$output .= '</select>';

				$output .= '<div class="dtdr-note">'.esc_html__('Product that you like to use for single page ads. Amount added in product will be treated as per day amount. Purhcasing that product will enable you the single page ads.', 'dtdr').'</div>';

			$output .= '</div>';
		$output .= '</div>';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.esc_html__( 'Top Of Search Ads', 'dtdr') .'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';
				$checked = ( 'true' ==  dtdr_option('ads','enable-topofsearch-ads') ) ? ' checked="checked"' : '';
				$switchclass = ( 'true' ==  dtdr_option('ads','enable-topofsearch-ads') ) ? 'checkbox-switch-on' :'checkbox-switch-off';
				$output .= '<div data-for="enable-topofsearch-ads" class="dtdr-checkbox-switch '.$switchclass.'"></div>';
				$output .= '<input id="enable-topofsearch-ads" class="hidden" type="checkbox" name="dtdr[ads][enable-topofsearch-ads]" value="true" '.$checked.' />';
			$output .= '</div>';
		$output .= '</div>';

		$output .= '<div class="dtdr-settings-options-holder">';
			$output .= '<div class="dtdr-column dtdr-one-fifth first">';
				$output .= '<label>'.esc_html__( 'Top Of Search Ads - Associated Product', 'dtdr' ).'</label>';
			$output .= '</div>';
			$output .= '<div class="dtdr-column dtdr-four-fifth">';

				$topofsearch_ads_product = dtdr_option('ads','topofsearch-ads-product');

				$product_args = array(
					'post_type' 		=> array( 'product' ),
					'posts_per_page' 	=> -1,
					'orderby'         	=> 'title',
					'order'           	=> 'ASC',
					'post_status'		=> array( 'publish' ),
					'suppress_filters' 	=> 0
				);
				$products_list = get_posts( $product_args );

				$output .= '<select name="dtdr[ads][topofsearch-ads-product]" id="topofsearch-ads-product" class="dtdr-chosen-select">';
					$output .= '<option value="">'.esc_html__( 'None', 'dtdr' ).'</option>';
					foreach($products_list as $product) {
						$output .= '<option value="'.$product->ID.'" '.selected( $topofsearch_ads_product, $product->ID, false ).'>'.esc_html($product->post_title).'</option>';
					}
				$output .= '</select>';

				$output .= '<div class="dtdr-note">'.esc_html__('Product that you like to use for top of search ads. Amount added in product will be treated as per day amount. Purhcasing that product will enable you the top of search ads.', 'dtdr').'</div>';

			$output .= '</div>';
		$output .= '</div>';

		$output .= '<div class="dtdr-option-settings-response-holder"></div>';

		$output .= '<a href="#" class="custom-button-style dtdr-save-options-settings" data-settings="ads">'.esc_html__('Save Settings', 'dtdr').'</a>';

	$output .= '</form>';

	return $output;

}

echo dtdr_settings_ads_content();

?>