<?php
global $post;
$claim_id = $post->ID;
echo '<input type="hidden" name="dtdr_claims_meta_nonce" value="'.wp_create_nonce('dtdr_claims_nonce').'" />';

$listing_singular_label = apply_filters( 'listing_label', 'singular' );

$listing_id  = get_post_meta($claim_id, 'dtdr_listing_id', true);
$author_id   = get_post_field( 'post_author', $listing_id );
$author_name = get_the_author_meta( 'display_name', $author_id );

$dtdr_approved_claimer_id = get_post_meta($claim_id, 'dtdr_approved_claimer_id', true);

$dtdr_claimers = get_post_meta($claim_id, 'dtdr_claimers', true);


$requires_package = esc_html__('No', 'dtdr');
if(dtdr_option('claims','claim-requires-package') == 'true') {
    $requires_package = esc_html__('Yes', 'dtdr');
}
?>

<div class="dtdr-custom-box">

    <div class="dtdr-column dtdr-one-third first">
        <label><?php echo esc_html($listing_singular_label); ?></label>
    </div>
    <div class="dtdr-column dtdr-two-third">
        <strong><?php echo get_the_title($listing_id); ?></strong>
    </div>

</div>

<div class="dtdr-custom-box">

    <div class="dtdr-column dtdr-one-third first">
        <label><?php echo esc_html__('Current Author', 'dtdr'); ?></label>
    </div>
    <div class="dtdr-column dtdr-two-third">
        <strong><?php echo esc_html($author_name); ?></strong>
    </div>

</div>

<div class="dtdr-custom-box">

    <div class="dtdr-column dtdr-one-third first">
        <label><?php echo esc_html__('Requires Active Package', 'dtdr'); ?></label>
    </div>
    <div class="dtdr-column dtdr-two-third">
        <strong><?php echo esc_html($requires_package); ?></strong>
    </div>

</div>

<div class="dtdr-custom-box">

    <div class="dtdr-column dtdr-one-column first">

        <label><?php echo esc_html__('Claimer Details', 'dtdr'); ?></label>

        <?php echo "<br><br>"; ?>

        <?php
        echo '<input class="dtdr_approved_claimer_id" name="dtdr_approved_claimer_id" type="hidden" value="'.esc_attr($dtdr_approved_claimer_id).'" />';
        echo '<input class="dtdr_approved_old_claimer_id" name="dtdr_approved_old_claimer_id" type="hidden" value="'.esc_attr($dtdr_approved_claimer_id).'" />';
        echo '<input class="dtdr_listing_id" name="dtdr_listing_id" type="hidden" value="'.esc_attr($listing_id).'" />';
        ?>

        <table border="0" cellpadding="0" cellspacing="0" class="dtdr-custom-table">
            <thead>
                <tr>
                    <th><?php echo esc_html__('#', 'dtdr'); ?></th>
                    <th><?php echo esc_html__('User', 'dtdr'); ?></th>
                    <th><?php echo esc_html__('Email', 'dtdr'); ?></th>
                    <th><?php echo esc_html__('Contact Details', 'dtdr'); ?></th>
                    <th><?php echo esc_html__('Message', 'dtdr'); ?></th>
                    <th><?php echo esc_html__('Attachments', 'dtdr'); ?></th>
                    <th><?php echo esc_html__('Package Details', 'dtdr'); ?></th>
                    <th><?php echo esc_html__('Approve', 'dtdr'); ?></th>
                </tr>
            </thead>
            <tbody class="dtdr-custom-table-content">
                <?php
                if(is_array($dtdr_claimers) && !empty($dtdr_claimers)) {
                    $i = 1;
                    foreach($dtdr_claimers as $dtdr_claimer) {

                        $dtdr_seller_active_package_id = get_user_meta($dtdr_claimer['user_id'], 'dtdr_seller_active_package_id', true);
                        $dtdr_seller_active_package_id = (isset($dtdr_seller_active_package_id) && !empty($dtdr_seller_active_package_id)) ? $dtdr_seller_active_package_id : -1;

                        $claim_requires_package = false;
                        if(dtdr_option('claims','claim-requires-package') == 'true') {
                            $claim_requires_package = true;
                        }

                        $package_required_n_active = false;
                        if($claim_requires_package && function_exists('dtdr_check_user_seller_package_is_active') && dtdr_check_user_seller_package_is_active($dtdr_claimer['user_id'], $dtdr_seller_active_package_id)) {

                            $dtdr_seller_package_listings_count = get_user_meta($dtdr_claimer['user_id'], 'dtdr_seller_package_listings_count', true);
                            $dtdr_seller_package_listings_count = (isset($dtdr_seller_package_listings_count) && !empty($dtdr_seller_package_listings_count)) ? $dtdr_seller_package_listings_count : 0;

                            $dtdr_seller_package_used_listings_count = get_user_meta($dtdr_claimer['user_id'], 'dtdr_seller_package_used_listings_count', true);
                            $dtdr_seller_package_used_listings_count = (isset($dtdr_seller_package_used_listings_count) && !empty($dtdr_seller_package_used_listings_count)) ? $dtdr_seller_package_used_listings_count : 0;

                            if($dtdr_seller_package_listings_count == -1) {
                                $dtdr_seller_package_listings_count   = esc_html__('Unlimited', 'dtdr');
                                $dtdr_seller_remaining_listings_count = esc_html__('Unlimited', 'dtdr');
                                $package_required_n_active = true;
                            } else {
                                $dtdr_seller_remaining_listings_count = ($dtdr_seller_package_listings_count - $dtdr_seller_package_used_listings_count);
                            }

                            if($dtdr_seller_remaining_listings_count > 0) {
                                $package_required_n_active = true;
                            }

                        }

                        $checkbox_attr = 'data-radioswitch="dtdr-custom-table"';

                        $package_not_required = false;
                        if(!$claim_requires_package) {
                            $package_not_required = true;
                        }

                        ?>
                        <tr>
                            <td><?php echo esc_html($i); ?></td>
                            <td><?php echo sprintf(esc_html__('%1$s ( ID - %2$s )', 'dtdr'), $dtdr_claimer['claimer_name'], '<a href="'.get_edit_user_link($dtdr_claimer['user_id']).'">'.$dtdr_claimer['user_id'].'</a>'); ?></td>
                            <td><?php echo esc_html($dtdr_claimer['claimer_email']); ?></td>
                            <td><?php echo sprintf(esc_html__('Phone - %1$s %2$s Mobile - %3$s', 'dtdr'), $dtdr_claimer['claimer_phone'], "<br>", $dtdr_claimer['claimer_mobile']); ?></td>
                            <td><?php echo esc_html($dtdr_claimer['claimer_message']); ?></td>
                            <td>
                                <?php
                                if(isset($dtdr_claimer['claimer_files']) && !empty($dtdr_claimer['claimer_files'])) {
                                    echo '<ul>';
                                    foreach($dtdr_claimer['claimer_files'] as $dtdr_claimer_file) {
                                        $attachment_url = wp_get_attachment_url($dtdr_claimer_file);
                                        $attachment_basename = wp_basename($attachment_url);
                                        echo '<li>';
                                            echo '<a href="'.esc_url($attachment_url).'" target="_blank">';
                                                echo esc_attr($attachment_basename);
                                            echo '</a>';
                                        echo '</li>';
                                    }
                                    echo '</ul>';
                                }
                                ?>
                            </td>
                            <td>
                                <?php
                                if($claim_requires_package) {
                                    if($package_required_n_active) {
                                        echo esc_html__('Status', 'dtdr').' : <strong>'.esc_html__('Active', 'dtdr').'</strong>';
                                        echo "<br>";
                                        echo esc_html__('Package', 'dtdr').' : <strong>'.get_the_title($dtdr_seller_active_package_id).'</strong>';
                                        echo "<br>";
                                        echo esc_html__('Remaining Listings', 'dtdr').' : <strong class="dtdr-remaining-listings-label">'.$dtdr_seller_remaining_listings_count.'</strong>';
                                        echo '<input class="dtdr-package-listings" name="dtdr-package-listings[]" type="hidden" value="'.esc_attr($dtdr_seller_package_listings_count).'" />';
                                        echo '<input class="dtdr-package-used-listings" name="dtdr-package-used-listings[]" type="hidden" value="'.esc_attr($dtdr_seller_package_used_listings_count).'" />';
                                        echo '<input class="dtdr-package-used-listings-updated" name="dtdr-package-used-listings-updated[]" type="hidden" value="'.esc_attr($dtdr_seller_package_used_listings_count).'" />';
                                        echo '<input class="dtdr-user-id" name="dtdr-user-id[]" type="hidden" value="'.esc_attr($dtdr_claimer['user_id']).'" />';
                                    } else {
                                        echo '<strong>'.esc_html__('No Active Package Found!', 'dtdr').'</strong>';
                                    }
                                }
                                ?>
                            </td>
                            <td>
                                <?php
                                if($package_required_n_active || $package_not_required) {
                                    $checked = ( $dtdr_claimer['user_id'] ==  $dtdr_approved_claimer_id ) ? ' checked="checked"' : '';
                                    $switchclass = ( $dtdr_claimer['user_id'] ==  $dtdr_approved_claimer_id ) ? 'radio-switch-on' :'radio-switch-off';
                                    echo '<div data-for="approve-claim-'.$dtdr_claimer['user_id'].'" class="dtdr-radio-switch '.$switchclass.'" '.$checkbox_attr.'></div>';
                                    echo '<input id="approve-claim-'.$dtdr_claimer['user_id'].'" class="dtdr-radio-switch-field hidden" type="checkbox" name="dtdr-approve-claimer" value="'.$dtdr_claimer['user_id'].'" '.$checked.' />';
                                }
                                ?>
                            </td>
                        </tr>
                        <?php
                        $i++;
                    }
                }
                ?>
            </tbody>
        </table>

    </div>

</div>