<?php

// Claim Form Generator
if(!function_exists('dtdr_generate_claimform')) {
	function dtdr_generate_claimform() {

		$output = '';

		$user_id    = (isset($_REQUEST['user_id']) && $_REQUEST['user_id'] != '') ? dtdr_recursive_sanitize_text_field($_REQUEST['user_id']) : -1;
		$listing_id = (isset($_REQUEST['listing_id']) && $_REQUEST['listing_id'] != '') ? dtdr_recursive_sanitize_text_field($_REQUEST['listing_id']) : -1;
		$author_id  = (isset($_REQUEST['author_id']) && $_REQUEST['author_id'] != '') ? dtdr_recursive_sanitize_text_field($_REQUEST['author_id']) : -1;
		$claim_submitted = (isset($_REQUEST['claim_submitted']) && $_REQUEST['claim_submitted'] == 'true') ? true : false;

		$listing_singular_label  = apply_filters( 'listing_label', 'singular' );


		if($claim_submitted) {

			$output .= '<div class="dtdr-claim-form-container">';
				$output .= '<div class="dtdr-claim-form">';

					$output .= '<div class="dtdr-claim-form-title">';
						$output .= sprintf(esc_html__('Claim your %1$s', 'dtdr'), $listing_singular_label);
					$output .= '</div>';

					$output .= '<div class="dtdr-claim-form-info">';
						$output .= esc_html__('Your claim have been submitted already.', 'dtdr');
					$output .= '</div>';

				$output .= '</div>';
			$output .= '</div>';
			$output .= '<div class="dtdr-claim-form-overlay"></div>';

		} else if($user_id > 0 && $listing_id > 0) {

			$dtdr_seller_active_package_id = get_user_meta($user_id, 'dtdr_seller_active_package_id', true);
			$dtdr_seller_active_package_id = (isset($dtdr_seller_active_package_id) && !empty($dtdr_seller_active_package_id)) ? $dtdr_seller_active_package_id : -1;

			$output .= '<div class="dtdr-claim-form-container">';
				$output .= '<div class="dtdr-claim-form">';

					$package_active = false;
					if(dtdr_option('claims','claim-requires-package') == 'true' && function_exists('dtdr_check_user_seller_package_is_active') && dtdr_check_user_seller_package_is_active($user_id, $dtdr_seller_active_package_id)) {
						$package_active = true;
					}

					if($package_active || dtdr_option('claims','claim-requires-package') != 'true') {

						$dtdr_user_phone = get_the_author_meta('dtdr_user_phone', $user_id);
						$dtdr_user_phone = isset($dtdr_user_phone) ? $dtdr_user_phone : '';

						$dtdr_user_mobile = get_the_author_meta('dtdr_user_mobile', $user_id);
						$dtdr_user_mobile = isset($dtdr_user_mobile) ? $dtdr_user_mobile : '';

						$output .= '<h2 class="dtdr-claim-form-title">';
							$output .= sprintf(esc_html__('Claim your %1$s', 'dtdr'), $listing_singular_label.' <strong>'.get_the_title($listing_id).'</strong>');
						$output .= '</h2>';

						if($package_active) {

							$output .= '<div class="dtdr-claim-form-info">';
								$output .= sprintf(esc_html__('%1$s will be claimed from your active %2$s package, if it is active until approval.', 'dtdr'), $listing_singular_label.' <strong>'.get_the_title($listing_id).'</strong>', '<strong>'.get_the_title($dtdr_seller_active_package_id).'</strong>');
								$output .= '<span>'.sprintf(esc_html__('Your package details will be updated once your %1$s claim is approved.', 'dtdr'), $listing_singular_label).'</span>';
							$output .= '</div>';

						}

						$output .= '<div class="dtdr-claim-form-details">';

							$output .= '<form method="post" class="dtdr-listings-claim-form" name="dtdr-listings-claim-form" enctype="multipart/form-data">';

								$output .= '<div class="dtdr-listings-claim-form-item">';
									$output .= '<input class="dtdr-claimform-phone" name="dtdr_claimform_phone" type="text" placeholder="'.esc_html__('Phone', 'dtdr').'" value="'.esc_attr($dtdr_user_phone).'" />';
									$output .= '<span></span>';
								$output .= '</div>';

								$output .= '<div class="dtdr-listings-claim-form-item">';
									$output .= '<input class="dtdr-claimform-mobile" name="dtdr_claimform_mobile" type="text" placeholder="'.esc_html__('Mobile *', 'dtdr').'" value="'.esc_attr($dtdr_user_mobile).'" />';
									$output .= '<span></span>';
								$output .= '</div>';

								$output .= '<div class="dtdr-listings-claim-form-item">';
									$output .= '<textarea class="dtdr-claimform-verification-details" name="dtdr_claimform_verification_details" rows="5" placeholder="'.esc_html__('Verification Details *', 'dtdr').'"></textarea>';
									$output .= '<span></span>';
								$output .= '</div>';

								$output .= '<div class="dtdr-listings-claim-form-item">';
									$output .= '<span>';
										$output .= '<input id="dtdr-claimform-verification-file" class="dtdr-claimform-verification-file-upload" name="dtdr_claimform_verification_files[]" type="file" multiple="multiple" />';
										$output .= '<label for="dtdr-claimform-verification-file" class="dtdr-claimform-verification-file-label">'.esc_html__('Attach File', 'dtdr').'</label>';
									$output .= '</span>';
								$output .= '</div>';

								$output .= '<input class="dtdr-claimform-userid" name="dtdr_claimform_userid" type="hidden" value="'.esc_attr($user_id).'" />';
								$output .= '<input class="dtdr-claimform-listingid" name="dtdr_claimform_listingid" type="hidden" value="'.esc_attr($listing_id).'" />';
								$output .= '<input class="dtdr-claimform-authorid" name="dtdr_claimform_authorid" type="hidden" value="'.esc_attr($author_id).'" />';
								$output .= '<input class="dtdr-claimform-packageid" name="dtdr_claimform_packageid" type="hidden" value="'.esc_attr($dtdr_seller_active_package_id).'" />';
								$output .= '<input class="dtdr-claimform-nonce" name="dtdr_claimform_nonce" type="hidden" value="'.wp_create_nonce('claim_form_listing_'.$listing_id).'" />';

								$output .= '<div class="dtdr-claimform-notification-box"></div>';

								$output .= '<a class="dtdr-claimform-submit-button">'.esc_html__('Claim Now', 'dtdr').'</a>';

								$output .= '<p class="dtdr-claimform-secure-note"><span class="fa fa-lock"></span>'.esc_html__('Secure Claim Process', 'dtdr').'</p>';

							$output .= '</form>';

						$output .= '</div>';

					} else {

						$output .= sprintf(esc_html__('You don\'t have any active packages to claim this %1$s.', 'dtdr'), strtolower($listing_singular_label));

					}

				$output .= '</div>';
			$output .= '</div>';
			$output .= '<div class="dtdr-claim-form-overlay"></div>';

		}

		echo dtdr_html_output($output);

		die();

	}
	add_action( 'wp_ajax_dtdr_generate_claimform', 'dtdr_generate_claimform' );
	add_action( 'wp_ajax_nopriv_dtdr_generate_claimform', 'dtdr_generate_claimform' );
}

// Listing Claim Form
if(!function_exists('dtdr_process_listing_claimform')) {
	function dtdr_process_listing_claimform() {

		$dtdr_claimform_nonce      = dtdr_recursive_sanitize_text_field ( $_POST['dtdr_claimform_nonce'] );
		$user_id                   = isset($_REQUEST['dtdr_claimform_userid']) ? dtdr_recursive_sanitize_text_field ( $_REQUEST['dtdr_claimform_userid'] ) : -1;
		$listing_id                = isset($_REQUEST['dtdr_claimform_listingid']) ? dtdr_recursive_sanitize_text_field ( $_REQUEST['dtdr_claimform_listingid'] ) : -1;
		$author_id                 = isset($_REQUEST['dtdr_claimform_authorid']) ? dtdr_recursive_sanitize_text_field ( $_REQUEST['dtdr_claimform_authorid'] ) : -1;
		$claimer_phone             = (isset($_REQUEST['dtdr_claimform_phone']) && !empty($_REQUEST['dtdr_claimform_phone'])) ? dtdr_recursive_sanitize_text_field ( $_REQUEST['dtdr_claimform_phone'] ) : '';
		$claimer_mobile            = (isset($_REQUEST['dtdr_claimform_mobile']) && !empty($_REQUEST['dtdr_claimform_mobile'])) ? dtdr_recursive_sanitize_text_field ( $_REQUEST['dtdr_claimform_mobile'] ) : '';
		$verification_details      = wp_kses_post($_REQUEST['dtdr_claimform_verification_details']);
		$verification_files_exists = (isset($_FILES['dtdr_claimform_verification_files']['name']['0']) && !empty($_FILES['dtdr_claimform_verification_files']['name']['0'])) ? true : false;


		$errors = false;
		$error_msg = array ();

		if($user_id <= 0 || $listing_id <= 0) {
			$errors = true;
			array_push($error_msg, esc_html__('Required data not found!', 'dtdr'));
		}

		if(!wp_verify_nonce( $dtdr_claimform_nonce, 'claim_form_listing_'.$listing_id)) {
			$errors = true;
			array_push($error_msg, esc_html__('Unverified Nonce!', 'dtdr'));
		}

		if($user_id > 0) {

			$claimer_name          = get_the_author_meta( 'display_name', $user_id );
			$claimer_email         = get_the_author_meta( 'user_email', $user_id );

		}

		if(!empty($claimer_phone)) {
			$claimer_phone = str_replace(array('-','(',')', ' ', '+'), '', $claimer_phone);
			if(is_numeric($claimer_phone) === FALSE) {
				$errors = true;
				array_push($error_msg, esc_html__('Phone number is not valid!', 'dtdr'));
			}
		}

		if(empty($claimer_mobile)) {
			$errors = true;
			array_push($error_msg, esc_html__('Mobile field is empty!', 'dtdr'));
		} else {
			$claimer_mobile = str_replace(array('-','(',')', ' ', '+'), '', $claimer_mobile);
			if(is_numeric($claimer_mobile) === FALSE) {
				$errors = true;
				array_push($error_msg, esc_html__('Mobile number is not valid!', 'dtdr'));
			}
		}

		if(empty($verification_details)) {
			$errors = true;
			array_push($error_msg, esc_html__('Provide us with verification details!', 'dtdr'));
		}

		if(!$verification_files_exists) {
			$errors = true;
			array_push($error_msg, esc_html__('Attach verification file(s)!', 'dtdr'));
		}

		// Throw error message
		if($errors) {

			$error_content = '<ul class="dtdr-claimform-errorlist"><li>';
			$error_content .= implode('</li><li>', $error_msg);
			$error_content .= '</li></ul>';

			echo json_encode(array(
				'success' => false,
				'message' => $error_content
			));
			wp_die();

		}


		// Composing mail

		$listing_singular_label  = apply_filters( 'listing_label', 'singular' );

			# Mail - Admin

			$admin_email  = get_option('admin_email');
			$dtdr_subject = esc_html__('New claim has been submitted', 'dtdr');
			$dtdr_body    = sprintf(esc_html__('You have received a new claim on a %1$s %2$s. Please login to your dashboard for further details.', 'dtdr'), strtolower($listing_singular_label), '<a href = "'.get_permalink($listing_id).'">'.get_the_title($listing_id).'</a>');
			$dtdr_header  = 'Content-type: text/html; charset=utf-8' . "\r\n";

			wp_mail($admin_email, $dtdr_subject, $dtdr_body, $dtdr_header);


			# Mail - Author

			$author_email = get_the_author_meta( 'user_email' , $author_id );
			$dtdr_subject = sprintf(esc_html__('A claim has been submitted on your %1$s', 'dtdr'), strtolower($listing_singular_label));
			$dtdr_body    = sprintf(esc_html__('A claim has been submitted on your %1$s %2$s. Please contact admin for further details.', 'dtdr'), strtolower($listing_singular_label), '<a href = "'.get_permalink($listing_id).'">'.get_the_title($listing_id).'</a>');
			$dtdr_header  = 'Content-type: text/html; charset=utf-8' . "\r\n";

			wp_mail($author_email, $dtdr_subject, $dtdr_body, $dtdr_header);


			# Mail - User

			$dtdr_subject = esc_html__('Your claim is submitted', 'dtdr');
			$dtdr_body    = sprintf(esc_html__('Your claim on %1$s %2$s has been submitted.', 'dtdr'), strtolower($listing_singular_label), '<a href = "'.get_permalink($listing_id).'">'.get_the_title($listing_id).'</a>');
			$dtdr_header  = 'Content-type: text/html; charset=utf-8' . "\r\n";

			wp_mail($claimer_email, $dtdr_subject, $dtdr_body, $dtdr_header);


		// Update Claim Form

		$claim_prev_args = array (
			'posts_per_page' => -1,
			'post_type'      => 'dtdr_claims',
			'post_status'    => 'publish',
			'meta_key'		 => 'dtdr_listing_id',
			'meta_compare'	 => '=',
			'meta_value'	 => $listing_id,
			'fields'		 => 'ids'
		);

		$claim_posts = get_posts($claim_prev_args);
		$claim_id = (isset($claim_posts[0]) && !empty($claim_posts[0])) ? $claim_posts[0] : -1;

		if(!($claim_id > 0)) {

			$claim_args = array (
				'post_title'  => get_the_title($listing_id),
				'post_type'   => 'dtdr_claims',
				'post_status' => 'publish'
			);

			$claim_id =  wp_insert_post($claim_args);

		}

		update_post_meta($claim_id, 'dtdr_listing_id', $listing_id);


		// Upload Verification Files

			$verification_files  = dtdr_recursive_sanitize_text_field ( $_FILES['dtdr_claimform_verification_files'] );
			$verification_file_ids = array ();
			if(is_array($verification_files) && !empty($verification_files)) {

				require_once ABSPATH . 'wp-admin/includes/image.php';
				require_once ABSPATH . 'wp-admin/includes/file.php';
				require_once ABSPATH . 'wp-admin/includes/media.php';

				foreach ($verification_files['name'] as $key => $value) {
					if ($verification_files['name'][$key]) {

						$file = array (
									'name'     => $verification_files['name'][$key],
									'type'     => $verification_files['type'][$key],
									'tmp_name' => $verification_files['tmp_name'][$key],
									'error'    => $verification_files['error'][$key],
									'size'     => $verification_files['size'][$key]
								);

						$_FILES = array ('verification-files' => $file);

						foreach ($_FILES as $file => $array) {
							$file_id = media_handle_upload( $file, $claim_id );
							array_push($verification_file_ids, $file_id);
						}

					}
				}

			}

		$dtdr_claimers = get_post_meta($claim_id, 'dtdr_claimers', true);
		$dtdr_claimers = (isset($dtdr_claimers) && !empty($dtdr_claimers)) ? $dtdr_claimers : array ();

		$claimData                    = array ();
		$claimData['user_id']         = $user_id;
		$claimData['package_id']      = $package_id;
		$claimData['claimer_name']    = $claimer_name;
		$claimData['claimer_email']   = $claimer_email;
		$claimData['claimer_mobile']  = $claimer_mobile;
		$claimData['claimer_phone']   = $claimer_phone;
		$claimData['claimer_message'] = $verification_details;
		$claimData['claimer_files']   = $verification_file_ids;

		array_push($dtdr_claimers, $claimData);

		update_post_meta($claim_id, 'dtdr_claimers', $dtdr_claimers);


		$dtdr_claimer_ids = get_post_meta($claim_id, 'dtdr_claimer_ids', true);
		$dtdr_claimer_ids = (isset($dtdr_claimer_ids) && !empty($dtdr_claimer_ids)) ? $dtdr_claimer_ids : array ();
		array_push($dtdr_claimer_ids, $user_id);
		update_post_meta($claim_id, 'dtdr_claimer_ids', $dtdr_claimer_ids);


		update_user_meta( $user_id, 'dtdr_user_phone', $claimer_phone);
		update_user_meta( $user_id, 'dtdr_user_mobile', $claimer_mobile);


		// Final Notification

		echo json_encode(array (
			'success' => true,
			'message' => esc_html__('Your claim submitted successfully!', 'dtdr')
		));

		wp_die();

	}
	add_action( 'wp_ajax_dtdr_process_listing_claimform', 'dtdr_process_listing_claimform' );
	add_action( 'wp_ajax_nopriv_dtdr_process_listing_claimform', 'dtdr_process_listing_claimform' );
}

?>