<?php

namespace DTElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

class DTDirectoryDfYelpPlaces extends Widget_Base {

	public function get_categories() {
		return [ 'dtdr-default-widgets' ];
	}

	public function get_name() {
		return 'dtdr-widget-df-yelp-places';
	}

	public function get_title() {
		return esc_html__( 'Yelp Places', 'dtdr' );
	}

	public function get_style_depends() {
		return array ('dtdr-location-frontend');
	}

	public function get_script_depends() {
		return array ();
	}

	protected function register_controls(){

		$listing_singular_label = apply_filters( 'listing_label', 'singular' );

		$this->start_controls_section( 'yelp_places_default_section', array(
			'label' => esc_html__( 'General', 'dtdr' ),
		) );

			$this->add_control( 'categories', array(
				'label'   => esc_html__( 'Categories', 'dtdr' ),
				'type'    => Controls_Manager::TEXT,
				'description' => sprintf( esc_html__('%1$s 1) Please specify categories you like to show. %2$s %1$s 2) Refer https://www.yelp.com/developers/documentation/v3/business_search for details. %2$s', 'dtdr'), '<p>', '</p>' ),
				'default' => ''
			) );

			$this->add_control( 'term', array(
				'label'   => esc_html__( 'Term', 'dtdr' ),
				'type'    => Controls_Manager::TEXT,
				'description' => sprintf( esc_html__('%1$s 1) Please specify term you like to show. %2$s %1$s 2) Refer https://www.yelp.com/developers/documentation/v3/business_search for details. %2$s', 'dtdr'), '<p>', '</p>' ),
				'default' => ''
			) );

			$this->add_control( 'location_type', array(
				'label'       => esc_html__( 'Location Type', 'dtdr' ),
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					'location' => esc_html__('Location', 'dtdr'),
					'lat_n_long'  => esc_html__('Latitude & Longitude', 'dtdr')
				),
				'description' => esc_html__('Choose whether you like to show Location or Latitude & Longitude', 'dtdr'),
				'default'      => 'location',
			) );

			$this->add_control( 'location', array(
				'label'   => esc_html__( 'Location', 'dtdr' ),
				'type'    => Controls_Manager::TEXT,
				'description' => esc_html__( 'Please specify location to display.', 'dtdr' ),
				'default' => ''
			) );

			$this->add_control( 'latitude', array(
				'label'   => esc_html__( 'Latitude', 'dtdr' ),
				'type'    => Controls_Manager::TEXT,
				'description' => esc_html__( 'Please specify latitude of the location to display.', 'dtdr' ),
				'default' => ''
			) );

			$this->add_control( 'longitude', array(
				'label'   => esc_html__( 'Longitude', 'dtdr' ),
				'type'    => Controls_Manager::TEXT,
				'description' => esc_html__( 'Please specify longitude of the location to display.', 'dtdr' ),
				'default' => ''
			) );

			$this->add_control( 'count', array(
				'label'       => esc_html__( 'Number Of Items to Show', 'dtdr' ),
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					1 => 1,
					2 => 2,
					3 => 3,
					4 => 4,
					5 => 5,
				),
				'description' => esc_html__('Total number of items to show.', 'dtdr'),
				'default'      => 2,
			) );

			$this->add_control( 'api_key', array(
				'label'   => esc_html__( 'Yelp API Key', 'dtdr' ),
				'type'    => Controls_Manager::TEXT,
				'description' => esc_html__( 'Provide Yelp API key here.', 'dtdr' ),
				'default' => ''
			) );

			$this->add_control( 'class', array(
				'label'   => esc_html__( 'Class', 'dtdr' ),
				'type'    => Controls_Manager::TEXT,
				'description' => esc_html__( 'If you wish you can add additional class name here.', 'dtdr' ),
				'default' => ''
			) );

		$this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings();
		$attributes = dtdirectory_elementor_instance()->dtdr_parse_shortcode_attrs( $settings );
		echo do_shortcode('[dtdr_yelp_places '.$attributes.' /]');

	}

}