<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( !class_exists( 'AdvenxPlusCustomizerSite404' ) ) {
    class AdvenxPlusCustomizerSite404 {

        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        function __construct() {
            add_action( 'customize_register', array( $this, 'register' ), 15);
        }

        function register( $wp_customize ) {

            /**
             * 404 Page
             */
            $wp_customize->add_section(
                new Advenx_Customize_Section(
                    $wp_customize,
                    'site-404-page-section',
                    array(
                        'title'    => esc_html__('404 Page', 'advenx-plus'),
                        'priority' => advenx_customizer_panel_priority( '404' )
                    )
                )
            );

            if ( ! defined( 'ADVENX_PRO_VERSION' ) ) {
                $wp_customize->add_control(
                    new Advenx_Customize_Control_Separator(
                        $wp_customize, ADVENX_CUSTOMISER_VAL . '[advenx-plus-site-404-separator]',
                        array(
                            'type'        => 'wdt-separator',
                            'section'     => 'site-404-page-section',
                            'settings'    => array(),
                            'caption'     => ADVENX_PLUS_REQ_CAPTION,
                            'description' => ADVENX_PLUS_REQ_DESC,
                        )
                    )
                );
            }

        }

    }
}

AdvenxPlusCustomizerSite404::instance();