<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( !class_exists( 'AdvenxPlusMainBGSecondaryColor' ) ) {
    class AdvenxPlusMainBGSecondaryColor {
        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        function __construct() {
            add_filter( 'advenx_plus_customizer_default', array( $this, 'default' ) );
            add_action( 'customize_register', array( $this, 'register' ), 15);

            add_filter( 'advenx_body_bg_secondary_color_css_var', array( $this, 'body_bg_secondary_color_var' ) );
            add_filter( 'advenx_body_bg_secondary_rgb_color_css_var', array( $this, 'body_bg_secondary_rgb_color_var' ) );
            add_filter( 'advenx_add_inline_style', array( $this, 'base_style' ) );
        }

        function default( $option ) {
            $theme_defaults = function_exists('advenx_theme_defaults') ? advenx_theme_defaults() : array ();
            $option['body_bg_secondary_color'] = $theme_defaults['body_bg_secondary_color'];
            return $option;
        }

        function register( $wp_customize ) {

            /**
             * Option : Primary Color
             */
            $wp_customize->add_setting(
                ADVENX_CUSTOMISER_VAL . '[body_bg_secondary_color]', array(
                    'type'    => 'option',
                )
            );

            $wp_customize->add_control(
                new Advenx_Customize_Control_Color(
                    $wp_customize, ADVENX_CUSTOMISER_VAL . '[body_bg_secondary_color]', array(
                        'section' => 'site-skin-main-section',
                        'label'   => esc_html__( 'Main Background Secondary Color', 'advenx-plus' ),
                    )
                )
            );
        }

        function body_bg_secondary_color_var( $var ) {
            $body_bg_secondary_color = advenx_customizer_settings( 'body_bg_secondary_color' );
            if( !empty( $body_bg_secondary_color ) ) {
                $var = '--wdtBodyBGSecondaryColor:'.esc_attr($body_bg_secondary_color).';';
            }

            return $var;
        }

        function body_bg_secondary_rgb_color_var( $var ) {
            $body_bg_secondary_color = advenx_customizer_settings( 'body_bg_secondary_color' );
            if( !empty( $body_bg_secondary_color ) ) {
                $var = '--wdtBodyBGSecondaryColorRgb:'.advenx_hex2rgba($body_bg_secondary_color, false).';';
            }

            return $var;
        }

        function base_style( $style ) {
            return $style;
        }
    }
}

AdvenxPlusMainBGSecondaryColor::instance();