<?php

namespace AdvenxElementor\Widgets;
use AdvenxElementor\Widgets\Advenx_Shop_Widget_Product_Summary;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;


class Advenx_Shop_Widget_Product_Summary_Extend extends Advenx_Shop_Widget_Product_Summary {

	function dynamic_register_controls() {

		$this->start_controls_section( 'product_summary_extend_section', array(
			'label' => esc_html__( 'Social Options', 'advenx-pro' ),
		) );

			$this->add_control( 'share_follow_type', array(
				'label'   => esc_html__( 'Share / Follow Type', 'advenx-pro' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'share',
				'options' => array(
					''       => esc_html__('None', 'advenx-pro'),
					'share'  => esc_html__('Share', 'advenx-pro'),
					'follow' => esc_html__('Follow', 'advenx-pro'),
				),
				'description' => esc_html__( 'Choose between Share / Follow you would like to use.', 'advenx-pro' ),
			) );

			$this->add_control( 'social_icon_style', array(
				'label'   => esc_html__( 'Social Icon Style', 'advenx-pro' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					'simple'        => esc_html__( 'Simple', 'advenx-pro' ),
					'bgfill'        => esc_html__( 'BG Fill', 'advenx-pro' ),
					'brdrfill'      => esc_html__( 'Border Fill', 'advenx-pro' ),
					'skin-bgfill'   => esc_html__( 'Skin BG Fill', 'advenx-pro' ),
					'skin-brdrfill' => esc_html__( 'Skin Border Fill', 'advenx-pro' ),
				),
				'description' => esc_html__( 'This option is applicable for all buttons used in product summary.', 'advenx-pro' ),
				'condition'   => array( 'share_follow_type' => array ('share', 'follow') )
			) );

			$this->add_control( 'social_icon_radius', array(
				'label'   => esc_html__( 'Social Icon Radius', 'advenx-pro' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					'square'  => esc_html__( 'Square', 'advenx-pro' ),
					'rounded' => esc_html__( 'Rounded', 'advenx-pro' ),
					'circle'  => esc_html__( 'Circle', 'advenx-pro' ),
				),
				'condition'   => array(
					'social_icon_style' => array ('bgfill', 'brdrfill', 'skin-bgfill', 'skin-brdrfill'),
					'share_follow_type' => array ('share', 'follow')
				),
			) );

			$this->add_control( 'social_icon_inline_alignment', array(
				'label'        => esc_html__( 'Social Icon Inline Alignment', 'advenx-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'yes', 'advenx-pro' ),
				'label_off'    => esc_html__( 'no', 'advenx-pro' ),
				'default'      => '',
				'return_value' => 'true',
				'description'  => esc_html__( 'This option is applicable for all buttons used in product summary.', 'advenx-pro' ),
				'condition'   => array( 'share_follow_type' => array ('share', 'follow') )
			) );

		$this->end_controls_section();

	}

}