<?php
add_action( 'vc_before_init', 'wdt_sf_categories_field_vc_map' );

function wdt_sf_categories_field_vc_map() {

	$destination_listing_singular_label = apply_filters( 'destination_listing_label', 'singular' );

	vc_map( array(
		"name" => esc_html__( 'Categories','wdt-destination'),
		"base" => "wdt_sf_categories_field",
		"icon" => "wdt_sf_categories_field",
		"category" => WDT_PB_MODULE_SEARCHFORM_TITLE,
		"params" => array(

			// Field Type
			array(
				'type' => 'dropdown',
				'heading' => esc_html__('Field Type','wdt-destination'),
				'param_name' => 'field_type',
				'value' => array(
					esc_html__('List','wdt-destination') => '',
					esc_html__('Dropdown','wdt-destination') => 'dropdown',
				),
				'description' => esc_html__( 'Choose type of field you like to use.','wdt-destination'),
				'std' => '',
				'edit_field_class' => 'vc_column vc_col-sm-6',
				'admin_label' => true
			),

			// Placeholder Text
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Placeholder Text','wdt-destination'),
				'param_name' => 'placeholder_text',
				'description' => esc_html__( 'You can provide your own text for placeholder of this item.','wdt-destination'),
				'dependency' => array( 'element' => 'field_type', 'value' => 'dropdown'),
				'edit_field_class' => 'vc_column vc_col-sm-6'
			),

			// Dropdown Type
			array(
				'type' => 'dropdown',
				'heading' => esc_html__('Dropdown Type','wdt-destination'),
				'param_name' => 'dropdown_type',
				'value' => array(
					esc_html__('Single','wdt-destination') => '',
					esc_html__('Multiple','wdt-destination') => 'multiple',
				),
				'description' => esc_html__( 'Choose type of dropdown you like to use.','wdt-destination'),
				'dependency' => array( 'element' => 'field_type', 'value' => 'dropdown'),
				'std' => '',
				'edit_field_class' => 'vc_column vc_col-sm-6'
			),

			// Ajax Load
			array(
				'type' => 'dropdown',
				'heading' => esc_html__('Ajax Load','wdt-destination'),
				'description' => esc_html__('If you want to display the output in same page choose "True" here.','wdt-destination'),
				'param_name' => 'ajax_load',
				'value' => array(
					esc_html__( 'False','wdt-destination') => 'false',
					esc_html__( 'True','wdt-destination') => 'true',
				),
				'edit_field_class' => 'vc_column vc_col-sm-6'
			),

			// Default Item Id
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Default Item Id','wdt-destination'),
				'param_name' => 'default_item_id',
				'description' => esc_html__( 'Set item id here, by default it will be set.','wdt-destination'),
				'edit_field_class' => 'vc_column vc_col-sm-6'
			),

			// Show Parent Items Alone
			array(
				'type' => 'dropdown',
				'heading' => esc_html__('Show Parent Items Alone','wdt-destination'),
				'param_name' => 'show_parent_items_alone',
				'value' => array(
					esc_html__( 'False','wdt-destination') => 'false',
					esc_html__( 'True','wdt-destination') => 'true',
				),
				'description' => esc_html__( 'If you like to show parent items alone choose "True".','wdt-destination'),
				'std' => 'false',
				'edit_field_class' => 'vc_column vc_col-sm-6',
			),

			// Child Of
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Child Of','wdt-destination'),
				'param_name' => 'child_of',
				'description' => esc_html__( 'If you like to show child of any parent item, provide id of your taxonomy here.','wdt-destination'),
				'dependency' => array( 'element' => 'show_parent_items_alone', 'value' => 'false' ),
				'edit_field_class' => 'vc_column vc_col-sm-6',
			),

			// Class
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Class','wdt-destination'),
				'param_name' => 'class',
				'description' => esc_html__( 'If you wish you can add additional class name here.','wdt-destination'),
				'edit_field_class' => 'vc_column vc_col-sm-6'
			)

		)
	) );
}
?>