<?php

// For Visual Composer Options Update
if(!function_exists('dtdr_listings_listing_vc_map_ads_module_args')) {
	function dtdr_listings_listing_vc_map_ads_module_args($args) {

		$args = array (
					'type' => 'dropdown',
					'heading' => esc_html__('Ad Items','dtdr'),
					'param_name' => 'ad_items',
					'value' => array(
						esc_html__('None', 'dtdr')                 => '',
						esc_html__('Prioritize Ad Items', 'dtdr')  => 'ad_items_prioritize',
						esc_html__('Show Ad Items Alone', 'dtdr') => 'ad_items_alone'
					),
					'description' => esc_html__('Choose true if you like to display ad items.', 'dtdr'),
					'group' => 'Ads',
					'edit_field_class' => 'vc_column vc_col-sm-6',
				);

		return $args;

	}
	add_filter( 'dtdr_listings_listing_vc_map_module_args', 'dtdr_listings_listing_vc_map_ads_module_args', 10, 1 );
}

// Updating Shortcode Attributes
if(!function_exists('dtdr_shortcode_atts_dtdr_listings_listing_from_ads_modules')) {
	function dtdr_shortcode_atts_dtdr_listings_listing_from_ads_modules($out, $pairs, $atts, $shortcode) {

		$out['ad_items'] = isset($atts['ad_items']) ? $atts['ad_items'] : '';

		return $out;

	}
	add_filter( 'shortcode_atts_dtdr_listings_listing', 'dtdr_shortcode_atts_dtdr_listings_listing_from_ads_modules', 10, 4 ); 
}

// Updating Shortcode HTML Data Attributes
if(!function_exists('dtdr_listings_listing_data_attrs_from_ads_modules')) {
	function dtdr_listings_listing_data_attrs_from_ads_modules($data_attr_encoded, $attrs) {

		$data_attr_decoded = json_decode($data_attr_encoded, true);

		$data_attr_decoded['ad_items'] = $attrs['ad_items'];

		if(is_singular('dtdr_listings')) {

			global $post;
			$single_post_id = $post->ID;

			$data_attr_decoded['ad_location'] = 'single';
			$data_attr_decoded['single_post_id'] = $single_post_id;

		} else {
			$data_attr_decoded['ad_location'] = 'listing';
		}

		$data_attr_encoded = json_encode($data_attr_decoded);

		return $data_attr_encoded;

	}
	add_filter( 'dtdr_listings_listing_data_attrs_from_modules', 'dtdr_listings_listing_data_attrs_from_ads_modules', 10, 2 ); 
}

?>