<?php

// Modifying Listing Query Arguments
if(!function_exists('dtdr_modify_listings_args_from_ads_modules')) {
	function dtdr_modify_listings_args_from_ads_modules($args, $custom_options) {

		$ad_items       = (isset($custom_options['ad_items']) && !empty($custom_options['ad_items']) ) ? $custom_options['ad_items']         : '';
		$ad_location    = (isset($custom_options['ad_location']) && !empty($custom_options['ad_location']) ) ? $custom_options['ad_location']: '';
		$single_post_id = (isset($custom_options['single_post_id']) && !empty($custom_options['single_post_id']) ) ? $custom_options['single_post_id'] : '';

		if($ad_items != '' && $ad_location != '') {
			if($ad_location == 'listing') {

				if($ad_items == 'ad_items_prioritize') {

					$args['meta_query'][] = array (

												'relation' => 'OR',
												array (
													'key'     => 'dtdr_limelight',
													'compare' => 'NOT EXISTS',
												),
												array (
													'relation' => 'AND',
													array(
														'key'     => 'dtdr_limelight',
														'value'   => true,
													),
													array (
														'key'     => 'dtdr_ad_status',
														'value'   => 'active',
														'compare' => '='
													)
												)

											);

					$args['orderby'] = array (
										'dtdr_limelight' => 'DESC'
									);

				} else if($ad_items == 'ad_items_alone') {

					$args['meta_query'][] = array (

												'relation' => 'AND',
												array(
													'key'     => 'dtdr_limelight',
													'value'   => true,
												),
												array (
													'key'     => 'dtdr_ad_status',
													'value'   => 'active',
													'compare' => '='
												)

										);

				}

			} else if($ad_location == 'single') {

				if($ad_items == 'ad_items_prioritize') {

					$args['meta_query'][] = array (

												'relation' => 'OR',
												array (
													'key'     => 'dtdr_singlepage',
													'compare' => 'NOT EXISTS',
												),
												array (
													'relation' => 'AND',
													array(
														'key'     => 'dtdr_singlepage',
														'value'   => true,
													),
													array (
														'key'     => 'dtdr_ad_status',
														'value'   => 'active',
														'compare' => '='
													)
												)

											);

					$args['orderby'] = array (
										'dtdr_singlepage' => 'DESC'
									);

				} else if($ad_items == 'ad_items_alone') {

					$args['meta_query'][] = array (

												'relation' => 'AND',
												array(
													'key'     => 'dtdr_singlepage',
													'value'   => true,
												),
												array (
													'key'     => 'dtdr_ad_status',
													'value'   => 'active',
													'compare' => '='
												)

										);

				}

				if($single_post_id) {
					$args['post__not_in'] = array ($single_post_id);
				}

			} else if($ad_location == 'search') {

				if($ad_items == 'ad_items_prioritize') {

					$args['meta_query'][] = array (

												'relation' => 'OR',
												array (
													'key'     => 'dtdr_topofsearch',
													'compare' => 'NOT EXISTS',
												),
												array (
													'relation' => 'AND',
													array(
														'key'     => 'dtdr_topofsearch',
														'value'   => true,
													),
													array (
														'key'     => 'dtdr_ad_status',
														'value'   => 'active',
														'compare' => '='
													)
												)

											);

					$args['orderby'] = array (
										'dtdr_topofsearch' => 'DESC'
									);

				} else if($ad_items == 'ad_items_alone') {

					$args['meta_query'][] = array (

												'relation' => 'AND',
												array(
													'key'     => 'dtdr_topofsearch',
													'value'   => true,
												),
												array (
													'key'     => 'dtdr_ad_status',
													'value'   => 'active',
													'compare' => '='
												)

										);

				}

			}
		}

		return $args;

	}
	add_filter( 'dtdr_modify_listings_args_from_modules', 'dtdr_modify_listings_args_from_ads_modules', 10, 2 );
}

// Updating Listings Listing HTML
if(!function_exists('dtdr_listing_custom_html_from_ads_modules')) {
	function dtdr_listing_custom_html_from_ads_modules($custom_html, $listing_id) {

		$dtdr_limelight = get_post_meta($listing_id, 'dtdr_limelight', true);
		$dtdr_singlepage = get_post_meta($listing_id, 'dtdr_singlepage', true);
		$dtdr_topofsearch = get_post_meta($listing_id, 'dtdr_topofsearch', true);
		if($dtdr_limelight == true || $dtdr_singlepage == true || $dtdr_topofsearch == true) {
			$custom_html .= '<div class="dtdr-listings-item-ad-section"><span>'.esc_html__('Ad', 'dtdr').'</span></div>';
		}

		return $custom_html;

	}
	add_filter( 'dtdr_listing_custom_html_from_modules', 'dtdr_listing_custom_html_from_ads_modules', 10, 2 );
}

?>