<?php

// On Order Completion
if(!function_exists('dtdr_on_order_status_completion_from_ads_module')) {
	function dtdr_on_order_status_completion_from_ads_module($order_id) {

		$order = new WC_Order( $order_id );
		$user_id = get_post_meta($order_id, '_customer_user', true);

		$ad_data = array ();

		$items = $order->get_items();
		foreach ( $items as $item_id => $item ) {

			$dtdr_ads = wc_get_order_item_meta($item_id, 'dtdr_ads');
			if(is_array($dtdr_ads) && !empty($dtdr_ads)) {

				if(array_key_exists($dtdr_ads['listing_id'], $ad_data)) {
					array_push($ad_data[$dtdr_ads['listing_id']]['ads'], $dtdr_ads['ad_type']);
				} else {
					$ad_data[$dtdr_ads['listing_id']]['ads'] = array ( $dtdr_ads['ad_type'] );
				}

				$ad_data[$dtdr_ads['listing_id']]['duration'] = $dtdr_ads['ad_duration'];

			}

		}

		if(is_array($ad_data) && !empty($ad_data)) {
			foreach($ad_data as $key => $addata) {

				$dtdr_ad_campaigns = get_post_meta($key, 'dtdr_ad_campaigns', true);

				if(dtdr_compare_arrays($addata['ads'], $dtdr_ad_campaigns, count($addata['ads']), count($dtdr_ad_campaigns))) {

					$dtdr_ad_process_status = get_post_meta($key, 'dtdr_ad_process_status', true);

					if($dtdr_ad_process_status == 'incart' || $dtdr_ad_process_status == 'cancelled') {

						foreach($dtdr_ad_campaigns as $ad_campaign) {
							update_post_meta($key, $ad_campaign, true);
						}

						$current_timestamp = strtotime(current_time(get_option('date_format')));

						$add_date = '+'.$addata['duration'].' days';
						$expiry_timestamp = strtotime($add_date, $current_timestamp);

						update_post_meta($key, 'dtdr_ad_process_status', 'active');
						update_post_meta($key, 'dtdr_ad_status', 'active');
						update_post_meta($key, 'dtdr_startdate', $current_timestamp);
						update_post_meta($key, 'dtdr_enddate', $expiry_timestamp);

					}

				}

			}
			dtdr_ad_module_setup_daily_user_schedule();
		}

	}
	add_action('woocommerce_order_status_completed', 'dtdr_on_order_status_completion_from_ads_module');
}

// On Order Cancellation
if(!function_exists('dtdr_on_order_status_cancellation_from_ads_module')) {
	function dtdr_on_order_status_cancellation_from_ads_module($order_id) {

		$order = new WC_Order( $order_id );
		$user_id = get_post_meta($order_id, '_customer_user', true);

		$ad_data = array ();

		$items = $order->get_items();
		foreach ( $items as $item_id => $item ) {

			$dtdr_item_id = wc_get_order_item_meta($item_id, 'dtdr_item_id');

			$dtdr_ads = wc_get_order_item_meta($item_id, 'dtdr_ads');
			if(is_array($dtdr_ads) && !empty($dtdr_ads)) {

				if(array_key_exists($dtdr_ads['listing_id'], $ad_data)) {
					array_push($ad_data[$dtdr_ads['listing_id']]['ads'], $dtdr_ads['ad_type']);
				} else {
					$ad_data[$dtdr_ads['listing_id']]['ads'] = array ( $dtdr_ads['ad_type'] );
				}

				$ad_data[$dtdr_ads['listing_id']]['duration'] = $dtdr_ads['ad_duration'];

			}

		}

		// For Ads
		if(is_array($ad_data) && !empty($ad_data)) {
			foreach($ad_data as $key => $addata) {

				$dtdr_ad_campaigns = get_post_meta($key, 'dtdr_ad_campaigns', true);

				if(dtdr_compare_arrays($addata['ads'], $dtdr_ad_campaigns, count($addata['ads']), count($dtdr_ad_campaigns))) {

					$dtdr_ad_process_status = get_post_meta($key, 'dtdr_ad_process_status', true);

					if($dtdr_ad_process_status == 'incart' || $dtdr_ad_process_status == 'active') {

						foreach($dtdr_ad_campaigns as $ad_campaign) {
							delete_post_meta($key, $ad_campaign);
						}

						update_post_meta($key, 'dtdr_ad_process_status', 'cancelled');
						delete_post_meta($key, 'dtdr_ad_status');
						delete_post_meta($key, 'dtdr_startdate');
						delete_post_meta($key, 'dtdr_enddate');

					}

				}

			}
			dtdr_ad_module_setup_daily_user_schedule();
		}

	}
	add_action('woocommerce_order_status_cancelled', 'dtdr_on_order_status_cancellation_from_ads_module');
	add_action('woocommerce_order_status_refunded', 'dtdr_on_order_status_cancellation_from_ads_module');
}

// Upate Order Item Data
if(!function_exists('dtdr_update_order_item_data_from_ads_module')) {
	function dtdr_update_order_item_data_from_ads_module( $item_id, $values ) {

		wc_add_order_item_meta($item_id, 'dtdr_ads', $values['dtdr_ads'] );

		$dtdr_item_id = wc_get_order_item_meta($item_id, 'dtdr_item_id');
		if(!isset($dtdr_item_id)) {
			wc_add_order_item_meta($item_id, 'dtdr_item_id', $values['product_id'] );
		}

	}
	add_action ( 'woocommerce_add_order_item_meta', 'dtdr_update_order_item_data_from_ads_module', 60, 2 );
}

// On removing product from cart - Update listing meta key
if(!function_exists('dtdr_woocommerce_remove_cart_item')) {
	function dtdr_woocommerce_remove_cart_item( $cart_item_key, $cart ) {

		$listing_id = $cart->cart_contents[$cart_item_key]['dtdr_ads']['listing_id'];
		$ad_type    = $cart->cart_contents[$cart_item_key]['dtdr_ads']['ad_type'];

		if($listing_id != '' && $ad_type != '') {

			$dtdr_ad_campaigns = get_post_meta($listing_id, 'dtdr_ad_campaigns', true);

			if(in_array($ad_type, $dtdr_ad_campaigns)) {
				unset($dtdr_ad_campaigns[array_search($ad_type, $dtdr_ad_campaigns)]);
			}

			if(empty($dtdr_ad_campaigns) && count($dtdr_ad_campaigns) == 0) {
				delete_post_meta($listing_id, 'dtdr_ad_campaigns');
				delete_post_meta($listing_id, 'dtdr_ad_process_status');
				delete_post_meta($listing_id, 'dtdr_ad_status');
			} else {
				update_post_meta($listing_id, 'dtdr_ad_campaigns', $dtdr_ad_campaigns);
			}

		}

	};
	add_action( 'woocommerce_remove_cart_item', 'dtdr_woocommerce_remove_cart_item', 10, 2 );
}


// Compare 2 arrays and check they are same
if(!function_exists('dtdr_compare_arrays')) {
	function dtdr_compare_arrays($arr1, $arr2, $n, $m) {

		if ($n != $m) {
			return false;
		}

		sort($arr1);
		sort($arr2);

		for($i = 0; $i < $n; $i++) {
			if($arr1[$i] != $arr2[$i]) {
				return false;
			}
		}

		return true;

	}
}

?>