<?php

if (!class_exists ( 'DTDirectoryRegisterAnnouncementsModule' )) {

	class DTDirectoryRegisterAnnouncementsModule extends DTDirectoryAddon {

		private $module_name;
		private $module_url;

		/**
		 * Instance variable
		 */
		private static $_instance = null;

		/**
		 * Instance
		 *
		 * Ensures only one instance of the class is loaded or can be loaded.
		 */
		public static function instance() {

			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}

			return self::$_instance;
		}

		function __construct() {

			$this->dtdr_define_constants( 'DTDR_ANNOUNCEMENTS_PLUGIN_PATH', DTDR_PLUGIN_PATH . 'modules/announcements/' );
			$this->dtdr_define_constants( 'DTDR_ANNOUNCEMENTS_PLUGIN_URL', DTDR_PLUGIN_URL . 'modules/announcements/' );

			add_action ( 'wp_enqueue_scripts', array ( $this, 'dtdr_enqueue_scripts' ), 130 );

			require_once DTDR_ANNOUNCEMENTS_PLUGIN_PATH . 'shortcodes.php';
			require_once DTDR_ANNOUNCEMENTS_PLUGIN_PATH . 'dashboard.php';

		}

		function dtdr_enqueue_scripts() {

			$this->dtdr_register_dependent_files();
			$this->dtdr_localize_registered_dependent_files();
			$this->dtdr_enqueue_registered_files();

			if(is_page_template('tpl-dashboard.php')) {
				wp_enqueue_style ( 'dtdr-announcements-dashboard' );

				wp_enqueue_script ( 'dtdr-announcements-dashboard' );
			}

		}

		function dtdr_register_dependent_files() {

			wp_register_style ( 'dtdr-announcements-dashboard', DTDR_ANNOUNCEMENTS_PLUGIN_URL . 'assets/announcements-dashboard.css', array ( 'dtdr-dashboard-frontend' ) );
			wp_register_style ( 'dtdr-announcements-frontend', DTDR_ANNOUNCEMENTS_PLUGIN_URL . 'assets/announcements-frontend.css', array ( 'fontawesome', 'material-icon', 'dtdr-base', 'dtdr-common', 'swiper' ) );

			wp_register_script ( 'dtdr-announcements-dashboard', DTDR_ANNOUNCEMENTS_PLUGIN_URL . 'assets/dashboard.js', array ('jquery', 'dtdr-dashboard-frontend'), false, true );

		}

		function dtdr_localize_registered_dependent_files() {

			wp_localize_script ( 'dtdr-announcements-dashboard', 'dtdrannouncementsdashboardobject', array (
				'ajaxurl'                          => admin_url('admin-ajax.php'),
				'addAnnouncementSuccess'           => '<p>'.esc_html__('Successfully posted your announcment!', 'dtdr').'</p>',
				'confirmDeleteAnnouncement'        => esc_html__('Are you sure, you wish to delete this Announcement ?', 'dtdr')
			));

		}

		function dtdr_enqueue_registered_files() {

			wp_enqueue_style ( 'dtdr-announcements-frontend' );

		}

	}

}

if( !function_exists('dtdrAnnouncementsModule') ) {
	function dtdrAnnouncementsModule() {
		return DTDirectoryRegisterAnnouncementsModule::instance();
	}
}

dtdrAnnouncementsModule();

?>