<?php

// Filter Dashboard Modules
if(!function_exists('dtdr_update_claims_dashboard_modules')) {
	function dtdr_update_claims_dashboard_modules($modules) {

	    $modules['claims'] = array (
			'slug' => 'claims',
			'label' => esc_html__('Claims', 'dtdr'),
			'icon' => 'fas fa-shield-alt',
			'callback' => 'dtdr_dashboard_claims_page_content',
			'callback_args' => ''
		);

	    return $modules;

	}
	add_filter( 'dashboard_modules', 'dtdr_update_claims_dashboard_modules', 10, 1 );
}

// Filter Seller Modules
if(!function_exists('dashboard_update_claims_seller_modules')) {
	function dashboard_update_claims_seller_modules($modules) {

	    array_push($modules, 'claims');

	    return $modules;

	}
	add_filter( 'dashboard_seller_modules', 'dashboard_update_claims_seller_modules', 10, 1 );
}


// Dashboard Content
if(!function_exists('dtdr_dashboard_claims_page_content')) {
	function dtdr_dashboard_claims_page_content() {

		$listing_plural_label = apply_filters( 'listing_label', 'plural' );

		$seller_id = get_current_user_id();

		$user_claimed_posts =  array ();

		$claim_prev_args = array (
			'posts_per_page' => -1,
			'post_type'      => 'dtdr_claims',
			'fields'		 => 'ids'
		);
		$claimed_post_ids = get_posts($claim_prev_args);

		if(is_array($claimed_post_ids) && !empty($claimed_post_ids)) {
			foreach($claimed_post_ids as $claimed_post_id) {

				$dtdr_claimer_ids = get_post_meta($claimed_post_id, 'dtdr_claimer_ids', true);
				$dtdr_claimer_ids = (isset($dtdr_claimer_ids) && !empty($dtdr_claimer_ids)) ? $dtdr_claimer_ids : array ();

				if(in_array($seller_id, $dtdr_claimer_ids)) {
					array_push($user_claimed_posts, $claimed_post_id);
				}

			}
		}

		// User Claimed Posts

		$output = '';

		$output .= '<div class="dtdr-dashbord-section-holder">';

			$output .= '<div class="dtdr-dashbord-section-holder-intro">';
				$output .= '<div class="dtdr-dashbord-section-title">'.esc_html__('Your Claims', 'dtdr').'</div>';
				$output .= '<div class="dtdr-dashbord-section-title-notes">'.sprintf( esc_html__('%1$s claimed by you and its status.', 'dtdr'), $listing_plural_label).'</div>';
			$output .= '</div>';

			$output .= '<div class="dtdr-dashbord-section-holder-content">';

				$output .= '<table class="dtdr-user-claimed-posts-table">
								<thead>
									<tr>
										<th class="dtdr-claim-listing">'.sprintf( esc_html__( '%1$s', 'dtdr' ), $listing_plural_label ).'</th>
										<th class="dtdr-claim-details">'.esc_html__('Your Verification Details', 'dtdr').'</th>
										<th class="dtdr-claim-status">'.esc_html__('Status', 'dtdr').'</th>
										<th class="dtdr-claim-status">'.esc_html__('Approved To', 'dtdr').'</th>
									</tr>
								</thead>
								<tbody>';

				if(is_array($user_claimed_posts) && !empty($user_claimed_posts)) {
					foreach($user_claimed_posts as $user_claimed_post) {

						$verification_details = '';
						$dtdr_claimers = get_post_meta($user_claimed_post, 'dtdr_claimers', true);
						$dtdr_claimers = (isset($dtdr_claimers) && !empty($dtdr_claimers)) ? $dtdr_claimers : array ();
						if(is_array($dtdr_claimers) && !empty($dtdr_claimers)) {
							foreach($dtdr_claimers as $dtdr_claimer) {
								if($seller_id == $dtdr_claimer['user_id']) {
									$verification_details = $dtdr_claimer['claimer_message'];
								}
							}
						}

						$claim_status = '';
						$dtdr_approved_claimer_id = get_post_meta($user_claimed_post, 'dtdr_approved_claimer_id', true);
						if($dtdr_approved_claimer_id != '') {
							$claim_status = esc_html__('Verified & Approved', 'dtdr');
						} else {
							$claim_status = esc_html__('Pending', 'dtdr');
						}

						$approved_to = get_the_author_meta( 'display_name', $dtdr_approved_claimer_id );
						if($dtdr_approved_claimer_id == $seller_id) {
							$approved_to = '<span class="dtdr-claim-approved-indication">'.esc_html__('You', 'dtdr').'</span>';
						}

						$output .= '<tr>';
							$output .= '<td class="dtdr-claim-listing"><a href="'.get_permalink($user_claimed_post).'" title="'.get_the_title($user_claimed_post).'">'.get_the_title($user_claimed_post).'</a></td>';
							$output .= '<td class="dtdr-claim-details">'.esc_html($verification_details).'</td>';
							$output .= '<td class="dtdr-claim-status">'.esc_html($claim_status).'</td>';
							$output .= '<td class="dtdr-claim-approved-to">'.$approved_to.'</td>';
						$output .= '</tr>';

					}
				} else {
					$output .= '<tr>';
						$output .= '<td colspan="4">'.esc_html__('No Records Found!', 'dtdr').'</td>';
					$output .= '</tr>';
				}

				$output .= '</tbody>
						</table>';

			$output .= '</div>';

		$output .= '</div>';


	    return $output;

	}
}


?>