<?php

if (!class_exists ( 'DTDirectoryRegisterClaimsModule' )) {

	class DTDirectoryRegisterClaimsModule extends DTDirectoryAddon {

		private $module_name;
		private $module_url;

		/**
		 * Instance variable
		 */
		private static $_instance = null;

		/**
		 * Instance
		 *
		 * Ensures only one instance of the class is loaded or can be loaded.
		 */
		public static function instance() {

			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}

			return self::$_instance;
		}

		function __construct() {

			$this->dtdr_define_constants( 'DTDR_CLAIMS_PLUGIN_PATH', DTDR_PLUGIN_PATH . 'modules/claims/' );
			$this->dtdr_define_constants( 'DTDR_CLAIMS_PLUGIN_URL', DTDR_PLUGIN_URL . 'modules/claims/' );

			add_filter ( 'dtdr_settings', array ( $this, 'dtdr_add_settings' ) );

			add_action ( 'admin_enqueue_scripts', array ( $this, 'dtdr_admin_enqueue_scripts' ), 120 );
			add_action ( 'wp_enqueue_scripts', array ( $this, 'dtdr_enqueue_scripts' ), 130 );

			require_once DTDR_CLAIMS_PLUGIN_PATH . 'utils.php';
			require_once DTDR_CLAIMS_PLUGIN_PATH . 'shortcodes.php';
			require_once DTDR_CLAIMS_PLUGIN_PATH . 'post-type.php';
			require_once DTDR_CLAIMS_PLUGIN_PATH . 'dashboard.php';

		}

		function dtdr_add_settings($tabs) {

			$tabs['claims'] = array (
				'label' => esc_html__('Claims', 'dtdr'),
				'path' => DTDR_CLAIMS_PLUGIN_PATH . 'settings.php'
			);

			return $tabs;

		}

		function dtdr_admin_enqueue_scripts() {

			$this->dtdr_register_dependent_files();

			$current_screen = get_current_screen();
			if($current_screen->id == 'dtdr_claims') {

				wp_enqueue_style ( 'dtdr-common' );
				wp_enqueue_style ( 'dtdr-claims-backend' );

				wp_enqueue_script ( 'dtdr-claims-backend' );

			}

		}

		function dtdr_enqueue_scripts() {

			$this->dtdr_register_dependent_files();
			$this->dtdr_enqueue_registered_files();

			if(is_page_template('tpl-dashboard.php')) {
				wp_enqueue_style ( 'dtdr-claims-dashboard' );
			}

		}

		function dtdr_register_dependent_files() {

			wp_register_style ( 'dtdr-claims-backend', DTDR_CLAIMS_PLUGIN_URL . 'assets/claims-backend.css', array ( 'dtdr-backend' ) );
			wp_register_style ( 'dtdr-claims-frontend', DTDR_CLAIMS_PLUGIN_URL . 'assets/claims-frontend.css', array ( 'fontawesome', 'material-icon', 'dtdr-base', 'dtdr-common' ) );
			wp_register_style ( 'dtdr-claims-dashboard', DTDR_CLAIMS_PLUGIN_URL . 'assets/claims-dashboard.css', array ( 'dtdr-dashboard-frontend' ) );

			wp_register_script ( 'dtdr-claims-backend', DTDR_CLAIMS_PLUGIN_URL . 'assets/backend.js', array ('jquery'), false, true );
			wp_register_script ( 'dtdr-claims-frontend', DTDR_CLAIMS_PLUGIN_URL . 'assets/frontend.js', array ( 'jquery', 'dtdr-modules-singlepage' ), false, true );

		}

		function dtdr_enqueue_registered_files() {

			wp_enqueue_style ( 'dtdr-claims-frontend' );

			wp_enqueue_script ( 'dtdr-claims-frontend' );

		}

	}

}

if( !function_exists('dtdrClaimsModule') ) {
	function dtdrClaimsModule() {
		return DTDirectoryRegisterClaimsModule::instance();
	}
}

dtdrClaimsModule();

?>