<?php

// Single Page - Claim Listing
if(!function_exists('dtdr_sp_claim_listing')) {
	function dtdr_sp_claim_listing($attrs, $content = null) {

		$attrs = shortcode_atts ( array (

			'listing_id' => '',
			'type' => 'claim_link',
			'show_verified_notice' => 'false',
			'class' => '',

		), $attrs, 'dtdr_sp_claim_listing' );

		$output = '';

		if($attrs['listing_id'] == '' && is_singular('dtdr_listings')) {
			global $post;
			$attrs['listing_id'] = $post->ID;
		}

		if($attrs['listing_id'] != '') {

			$dtdr_verified_listing = get_post_meta($attrs['listing_id'], 'dtdr_verified_listing', true);

			if($dtdr_verified_listing == 'true') {
				if(($attrs['type'] == 'claim_link' && $attrs['show_verified_notice'] == 'true') || ($attrs['type'] == 'claim_verified_notice')) {
					$output .= '<div class="dtdr-listings-claim-wrapper">';
						$output .= '<a class="dtdr-listings-claim-item claim-verified">'.esc_html__('Verified', 'dtdr').'</a>';
					$output .= '</div>';
				}
			} else if($attrs['type'] == 'claim_link') {

				$current_user = wp_get_current_user();
				$user_id = $current_user->ID;

				if($user_id > 0) {

					$claim_prev_args = array (
						'posts_per_page' => -1,
						'post_type'      => 'dtdr_claims',
						'post_status'    => 'publish',
						'meta_key'		 => 'dtdr_listing_id',
						'meta_compare'	 => '=',
						'meta_value'	 => $attrs['listing_id'],
						'fields'		 => 'ids'
					);

					$claim_posts = get_posts($claim_prev_args);
					$claim_id = (isset($claim_posts[0]) && !empty($claim_posts[0])) ? $claim_posts[0] : -1;

					$dtdr_approved_claimer_id = get_post_meta($claim_id, 'dtdr_approved_claimer_id', true);
					$dtdr_approved_claimer_id = (isset($dtdr_approved_claimer_id) && !empty($dtdr_approved_claimer_id)) ? $dtdr_approved_claimer_id : -1;

					if(!($dtdr_approved_claimer_id > 0)) {

						$author_id = get_post_field( 'post_author', $attrs['listing_id'] );

						$user_meta	= get_userdata($user_id);
						$user_roles	= $user_meta->roles;

						if((dtdr_option('claims','claim-requires-package') == 'true' && in_array('seller', $user_roles)) || dtdr_option('claims','claim-requires-package') != 'true') {

							$claim_submitted = $claim_approved = false;
							$dtdr_claimers = get_post_meta($claim_id, 'dtdr_claimers', true);
							if(is_array($dtdr_claimers) && !empty($dtdr_claimers)) {
								foreach($dtdr_claimers as $dtdr_claimer) {
									if($dtdr_claimer['user_id'] == $user_id) {
										$claim_submitted = true;
									}
								}
							}

							if($claim_submitted) {

								$output .= '<div class="dtdr-listings-claim-wrapper">';
									$output .= '<a class="dtdr-listings-claim-item dtdr-generate-claimform" data-userid="'.$user_id.'" data-listingid="'.$attrs['listing_id'].'" data-authorid="'.$author_id.'" data-claimsubmitted="true">'.esc_html__('Claim Now', 'dtdr').'</a>';
								$output .= '</div>';

							} else {

								$output .= '<div class="dtdr-listings-claim-wrapper">';
									$output .= '<a class="dtdr-listings-claim-item dtdr-generate-claimform" data-userid="'.$user_id.'" data-listingid="'.$attrs['listing_id'].'" data-authorid="'.$author_id.'" data-claimsubmitted="false">'.esc_html__('Claim Now', 'dtdr').'</a>';
								$output .= '</div>';

							}

						}

					}

				} else {

					$output .= '<div class="dtdr-listings-claim-wrapper">';
						$output .= '<a class="dtdr-listings-claim-item dtdr-login-link">'.esc_html__('Claim Now', 'dtdr').'</a>';
					$output .= '</div>';

				}

			}


		}

		return $output;

	}
	add_shortcode ( 'dtdr_sp_claim_listing', 'dtdr_sp_claim_listing' );
}

?>