<?php

// Single Page - Floor Plan
if(!function_exists('dtdr_sp_floor_plan')) {
	function dtdr_sp_floor_plan( $attrs, $content = null ) {

		$attrs = shortcode_atts ( array (

					'listing_id' => '',
					'class' => '',

				), $attrs, 'dtdr_sp_floor_plan' );


		$output = '';

		if($attrs['listing_id'] == '' && is_singular('dtdr_listings')) {
			global $post;
			$attrs['listing_id'] = $post->ID;
		}

		if($attrs['listing_id'] != '') {

			$output .= '<div class="dtdr-listings-floorplan-box-container '.$attrs['class'].'">';

				$dtdr_floorplan_title = $dtdr_floorplan_description = $dtdr_floorplan_image = $dtdr_floorplan_size = $dtdr_floorplan_rooms = $dtdr_floorplan_baths = $dtdr_floorplan_price = '';
				if($attrs['listing_id'] > 0) {

					$dtdr_floorplan_title       = get_post_meta($attrs['listing_id'], 'dtdr_floorplan_title', true);
					$dtdr_floorplan_description = get_post_meta($attrs['listing_id'], 'dtdr_floorplan_description', true);
					$dtdr_floorplan_image       = get_post_meta($attrs['listing_id'], 'dtdr_floorplan_image', true);
					$dtdr_floorplan_size        = get_post_meta($attrs['listing_id'], 'dtdr_floorplan_size', true);
					$dtdr_floorplan_rooms       = get_post_meta($attrs['listing_id'], 'dtdr_floorplan_rooms', true);
					$dtdr_floorplan_baths       = get_post_meta($attrs['listing_id'], 'dtdr_floorplan_baths', true);
					$dtdr_floorplan_price       = get_post_meta($attrs['listing_id'], 'dtdr_floorplan_price', true);

				}

				$j = 0;
				if(is_array($dtdr_floorplan_title) && !empty($dtdr_floorplan_title)) {
					foreach($dtdr_floorplan_title as $dtdr_floorplantitle) {

						$style_attr = '';

						$image_url = wp_get_attachment_image_src($dtdr_floorplan_image[$j], 'full');
						if($image_url != '') {
							$style_attr .= 'style="background-image:url('.esc_url($image_url[0]).')";';
						}

						$output .= '<div class="dtdr-listings-floorplan-box-item">
										<div class="dtdr-listings-floorplan-top-section">
											<div class="dtdr-listings-floorplan-box-item-title">'.esc_attr($dtdr_floorplantitle).'</div>
											<div class="dtdr-listings-floorplan-box-item-size">'.esc_attr($dtdr_floorplan_size[$j]).'</div>
											<div class="dtdr-listings-floorplan-box-item-rooms">'.esc_attr($dtdr_floorplan_rooms[$j]).'</div>
											<div class="dtdr-listings-floorplan-box-item-baths">'.esc_attr($dtdr_floorplan_baths[$j]).'</div>
											<div class="dtdr-listings-floorplan-box-item-price">'.esc_attr($dtdr_floorplan_price[$j]).'</div>
											<div class="dtdr-listings-floorplan-expand-bottom-section"><span class="dtdr-open">'.esc_html__('Open', 'dtdr').'</span><span class="dtdr-close">'.esc_html__('Close', 'dtdr').'</span></div>
										</div>
										<div class="dtdr-listings-floorplan-bottom-section dtdr-hidden">
											<div class="dtdr-listings-floorplan-box-item-container">
												<div class="dtdr-listings-floorplan-box-item-image">
													<img src="'.esc_url($image_url[0]).'" alt="'.esc_html__('Floor Plan', 'dtdr').'" title="'.esc_html__('Floor Plan', 'dtdr').'" />
												</div>
												<div class="dtdr-listings-floorplan-box-item-description">'.esc_attr($dtdr_floorplan_description[$j]).'</div>
											</div>
										</div>
									</div>';

						$j++;

					}
				}

			$output .= '</div>';

		} else {

			$listing_singular_label = apply_filters( 'listing_label', 'singular' );

			$output .= sprintf( esc_html__('Please provide %1$s id to display corresponding data!', 'dtdr'), strtolower($listing_singular_label) );

		}

		return $output;

	}
	add_shortcode ( 'dtdr_sp_floor_plan', 'dtdr_sp_floor_plan' );
}

?>