<?php

// Floor Plan Field
if(!function_exists('dtdr_listing_floorplan_field')) {
    function dtdr_listing_floorplan_field($item_id) {

        $output = '';

        $output .= '<div class="dtdr-floorplan-box-container">';

            $output .= '<div class="dtdr-floorplan-box-item-holder">';

                $dtdr_floorplan_title = $dtdr_floorplan_description = $dtdr_floorplan_image = $dtdr_floorplan_size = $dtdr_floorplan_rooms = $dtdr_floorplan_baths = $dtdr_floorplan_price = '';
                if($item_id > 0) {
                    $dtdr_floorplan_title       = get_post_meta($item_id, 'dtdr_floorplan_title', true);
                    $dtdr_floorplan_description = get_post_meta($item_id, 'dtdr_floorplan_description', true);
                    $dtdr_floorplan_image       = get_post_meta($item_id, 'dtdr_floorplan_image', true);
                    $dtdr_floorplan_size        = get_post_meta($item_id, 'dtdr_floorplan_size', true);
                    $dtdr_floorplan_rooms       = get_post_meta($item_id, 'dtdr_floorplan_rooms', true);
                    $dtdr_floorplan_baths       = get_post_meta($item_id, 'dtdr_floorplan_baths', true);
                    $dtdr_floorplan_price       = get_post_meta($item_id, 'dtdr_floorplan_price', true);
                }

                $j = 0;
                if(is_array($dtdr_floorplan_title) && !empty($dtdr_floorplan_title)) {
                    foreach($dtdr_floorplan_title as $dtdr_feature_title) {

                        $image_url = wp_get_attachment_image_src($dtdr_floorplan_image[$j], 'full');

                        $output .= '<div class="dtdr-floorplan-box-item">
                                        <div class="dtdr-column dtdr-one-column">
                                            <input name="dtdr_floorplan_title[]" type="text" value="'.esc_attr($dtdr_feature_title).'" placeholder="'.esc_html__('Title', 'dtdr').'" />
                                        </div>
                                        <div class="dtdr-column dtdr-one-column">
                                            <textarea name="dtdr_floorplan_description[]">'.esc_attr($dtdr_floorplan_description[$j]).'</textarea>
                                        </div>
                                        <div class="dtdr-floorplan-box-item-content">
                                            <div class="dtdr-column">
                                                <input name="dtdr_floorplan_size[]" type="text" value="'.esc_attr($dtdr_floorplan_size[$j]).'" placeholder="'.esc_html__('Size', 'dtdr').'" />
                                            </div>
                                            <div class="dtdr-column">
                                                <input name="dtdr_floorplan_rooms[]" type="text" value="'.esc_attr($dtdr_floorplan_rooms[$j]).'" placeholder="'.esc_html__('Rooms', 'dtdr').'" />
                                            </div>
                                            <div class="dtdr-column">
                                                <input name="dtdr_floorplan_baths[]" type="text" value="'.esc_attr($dtdr_floorplan_baths[$j]).'" placeholder="'.esc_html__('Baths', 'dtdr').'" />
                                            </div>
                                            <div class="dtdr-column">
                                                <input name="dtdr_floorplan_price[]" type="text" value="'.esc_attr($dtdr_floorplan_price[$j]).'" placeholder="'.esc_html__('Price', 'dtdr').'" />
                                            </div>
                                        </div>
                                        <div class="dtdr-column dtdr-upload-media-items-container">
                                            <input name="dtdr_floorplan_image_url" type="text" value="'.esc_url($image_url[0]).'" placeholder="'.esc_html__('Image', 'dtdr').'" class="uploadfieldurl" readonly />
                                            <input name="dtdr_floorplan_image[]" type="hidden" value="'.esc_attr($dtdr_floorplan_image[$j]).'" placeholder="'.esc_html__('Image', 'dtdr').'" class="uploadfieldid" readonly />
                                            <input type="button" value="'.esc_html__('Upload', 'dtdr').'" class="dtdr-upload-media-item-button show-preview" />
                                            <input type="button" value="'.esc_html__('Remove', 'dtdr').'" class="dtdr-upload-media-item-reset" />
                                            '.dtdr_adminpanel_image_preview($image_url[0]).'
                                        </div>
                                        <div class="dtdr-floorplan-box-options">
                                            <span class="dtdr-remove-floorplan"><span class="fas fa-times"></span></span>
                                            <span class="dtdr-sort-floorplan"><span class="fas fa-arrows-alt"></span></span>
                                        </div>
                                    </div>';
                        $j++;
                    }
                }

            $output .= '</div>';

            $output .= '<a href="#" class="dtdr-add-floorplan-box custom-button-style">'.esc_html__('Add Floor Plan', 'dtdr').'</a>';

            $output .= '<div class="dtdr-floorplan-box-item-toclone hidden">
                            <div class="dtdr-column dtdr-one-column">
                                <input id="dtdr_floorplan_title" type="text" placeholder="'.esc_html__('Title', 'dtdr').'" />
                            </div>
                            <div class="dtdr-column dtdr-one-column">
                                <textarea id="dtdr_floorplan_description" placeholder="'.esc_html__('Description', 'dtdr').'"></textarea>
                            </div>
                            <div class="dtdr-floorplan-box-item-content">
                                <div class="dtdr-column">
                                    <input id="dtdr_floorplan_size" type="text" placeholder="'.esc_html__('Size', 'dtdr').'" />
                                </div>
                                <div class="dtdr-column">
                                    <input id="dtdr_floorplan_rooms" type="text" placeholder="'.esc_html__('Rooms', 'dtdr').'" />
                                </div>
                                <div class="dtdr-column">
                                    <input id="dtdr_floorplan_baths" type="text" placeholder="'.esc_html__('Baths', 'dtdr').'" />
                                </div>
                                <div class="dtdr-column">
                                    <input id="dtdr_floorplan_price" type="text" placeholder="'.esc_html__('Price', 'dtdr').'" />
                                </div>
                            </div>
                            <div class="dtdr-column dtdr-upload-media-items-container">
                                <input name="dtdr_floorplan_image_url" type="text" placeholder="'.esc_html__('Image', 'dtdr').'" class="uploadfieldurl" readonly />
                                <input id="dtdr_floorplan_image" type="hidden" placeholder="'.esc_html__('Image', 'dtdr').'" class="uploadfieldid" readonly />
                                <input type="button" value="'.esc_html__('Upload', 'dtdr').'" class="dtdr-upload-media-item-button show-preview" />
                                <input type="button" value="'.esc_html__('Remove', 'dtdr').'" class="dtdr-upload-media-item-reset" />
                                '.dtdr_adminpanel_image_preview('').'
                            </div>
                            <div class="dtdr-floorplan-box-options">
                                <span class="dtdr-remove-floorplan"><span class="fas fa-times"></span></span>
                                <span class="dtdr-sort-floorplan"><span class="fas fa-arrows-alt"></span></span>
                            </div>
                        </div>';

        $output .= '</div>';

        return $output;

    }
}

?>