<div class="dtdr-custom-box">

    <label><?php echo esc_html__('Map Image', 'dtdr'); ?></label>
    <?php echo dtdr_upload_promoflash_image($list_id); ?>
    <div class="dtdr-note"><?php echo esc_html__('This image will be used for map icon.', 'dtdr'); ?> </div>

</div>

<div class="dtdr-custom-box">

    <label><?php echo esc_html__('Address', 'dtdr'); ?></label>
    <?php $dtdr_address = get_post_meta($list_id, 'dtdr_address', true); ?>
    <input name="dtdr_address" id="dtdr_address" type="text" value="<?php echo esc_attr($dtdr_address);?>" />
    <div class="dtdr-note"><?php echo sprintf( esc_html__('Add address for your %1$s here.', 'dtdr'), strtolower($listing_singular_label) ); ?> </div>

</div>

<div class="dtdr-custom-box">

    <label><?php echo esc_html__('Zip', 'dtdr'); ?></label>
    <?php $dtdr_zip = get_post_meta($list_id, 'dtdr_zip', true); ?>
    <input name="dtdr_zip" type="text" value="<?php echo esc_attr($dtdr_zip);?>" />
    <div class="dtdr-note"><?php echo sprintf( esc_html__('Add zip code for your %1$s here.', 'dtdr'), strtolower($listing_singular_label) ); ?> </div>

</div>

<div class="dtdr-custom-box">

    <label><?php echo esc_html__('Country', 'dtdr'); ?></label>
    <?php $dtdr_country = get_post_meta($list_id, 'dtdr_country', true); ?>
    <select name="dtdr_country" class="dtdr-chosen-select">
        <?php
        $countries_list = dtdr_countries_list(true);
        foreach( $countries_list as $key => $country ):
            echo '<option value="'.$key.'" '.selected($dtdr_country, $key, false).'>'.$country.'</option>';
        endforeach;
        ?>
    </select>
    <div class="dtdr-note"><?php echo sprintf( esc_html__('Choose country for your %1$s here.', 'dtdr'), strtolower($listing_singular_label) ); ?> </div>

</div>

<div class="dtdr-custom-box">

    <label><?php echo esc_html__('Latitude', 'dtdr'); ?></label>
    <input name="dtdr_latitude" type="text" value="<?php echo esc_attr($dtdr_latitude);?>" id="dtdr_latitude" />
    <div class="dtdr-note"><?php echo sprintf( esc_html__('Add latitude value of your %1$s location here.', 'dtdr'), strtolower($listing_singular_label) ); ?> </div>

</div>

<div class="dtdr-custom-box">

    <label><?php echo esc_html__('Longitude', 'dtdr'); ?></label>
    <input name="dtdr_longitude" type="text" value="<?php echo esc_attr($dtdr_longitude);?>" id="dtdr_longitude" />
    <div class="dtdr-note"><?php echo sprintf( esc_html__('Add longitude value of your %1$s location here.', 'dtdr'), strtolower($listing_singular_label) ); ?> </div>

</div>

<div class="dtdr-custom-box">

    <div id="dtdr-addlist-map-holder"></div>
    <div class="dtdr-note"><?php echo esc_html__('You can also drag and place marker to identify your location.', 'dtdr'); ?></div>

</div>