<?php

namespace DTElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

class WDTDestinationSpMediaAttachments extends Widget_Base {

	public function get_categories() {
		return [ 'wdt-singlepage-widgets' ];
	}

	public function get_name() {
		return 'wdt-widget-sp-media-attachments';
	}

	public function get_title() {
		return esc_html__( 'Media - Attachments','wdt-destination');
	}

	public function get_style_depends() {
		return array ('wdt-media-attachments-frontend');
	}

	public function get_script_depends() {
		return array ();
	}

	protected function register_controls() {

		$destination_listing_singular_label = apply_filters( 'destination_listing_label', 'singular' );

		$this->start_controls_section( 'media_attachments_default_section', array(
			'label' => esc_html__( 'General','wdt-destination'),
		) );

			$this->add_control( 'listing_id', array(
				'label'       => sprintf( esc_html__('%1$s Id','wdt-destination'), $destination_listing_singular_label ),
				'type'        => Controls_Manager::TEXT,
				'description' => sprintf( esc_html__('Provide %1$s id to display your item. No need to provide ID if it is used in %1$s single page.','wdt-destination'), strtolower($destination_listing_singular_label) ),
				'default'     => ''
			) );

			$this->add_control( 'type', array(
				'label'       => esc_html__( 'Type','wdt-destination'),
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					'type1' => esc_html__('Type 1','wdt-destination'),
					'type2' => esc_html__('Type 2','wdt-destination'),
					'type3' => esc_html__('Type 3','wdt-destination'),
					'type4' => esc_html__('Type 4','wdt-destination'),
					'type5' => esc_html__('Type 5','wdt-destination')
				),
				'description' => esc_html__('Choose type of layout you like to display.','wdt-destination'),
				'default'      => 'type1',
			) );

			$this->add_control( 'class', array(
				'label'   => esc_html__( 'Class','wdt-destination'),
				'type'    => Controls_Manager::TEXT,
				'description' => esc_html__( 'If you wish you can add additional class name here.','wdt-destination'),
				'default' => ''
			) );

		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings();
		$attributes = wdtdestination_elementor_instance()->wdt_parse_shortcode_attrs( $settings );
		$output = do_shortcode('[wdt_sp_media_attachments '.$attributes.' /]');

		echo $output;

	}

}