<?php
add_action( 'vc_before_init', 'wdt_sp_media_images_vc_map' );

function wdt_sp_media_images_vc_map() {

	$destination_listing_singular_label = apply_filters( 'destination_listing_label', 'singular' );

	vc_map( array(
		"name"     => esc_html__( 'Media - Images','wdt-destination'),
		"base"     => "wdt_sp_media_images",
		"icon"     => "wdt_sp_media_images",
		"category" => WDT_PB_MODULE_SINGLEPAGE_TITLE,
		"params"   => array(

			// Listing Id
			array(
				'type'             => 'textfield',
				'heading'          => sprintf( esc_html__('%1$s Id','wdt-destination'), $destination_listing_singular_label ),
				'param_name'       => 'listing_id',
				'description'      => sprintf( esc_html__('Provide %1$s id for which you have to display featured image. No need to provide ID if it is used in %1$s single page.','wdt-destination'), strtolower($destination_listing_singular_label) ),
				'edit_field_class' => 'vc_column vc_col-sm-6',
				'admin_label'      => true
			),

			// Thumbnail Sizes
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__('Thumbnail Sizes','wdt-destination'),
				'param_name' => 'image_size',
				'value'      => array(
					esc_html__('Thumbnail','wdt-destination')    => 'thumbnail',
					esc_html__('Medium','wdt-destination')       => 'medium',
					esc_html__('Medium Large','wdt-destination') => 'medium_large',
					esc_html__('Large','wdt-destination')        => 'large',
					esc_html__('Full','wdt-destination')         => 'full',
				),
				'description'      => esc_html__( 'Choose any of the above image sizes.','wdt-destination'),
				'std'              => 'full',
				'edit_field_class' => 'vc_column vc_col-sm-6',
				'admin_label'      => true
			),

			// Show Image Description
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__('Show Image Description','wdt-destination'),
				'description' => esc_html__('Choose "True" if you like to show image description in carousel.','wdt-destination'),
				'param_name'  => 'show_image_description',
				'value'       => array(
					esc_html__( 'False','wdt-destination') => 'false',
					esc_html__( 'True','wdt-destination')  => 'true',
				),
				'edit_field_class' => 'vc_column vc_col-sm-6'
			),

			// Include Feature Image
			array(
				'type'        => 'dropdown',
				'heading'     => esc_html__('Include Feature Image','wdt-destination'),
				'description' => esc_html__('Choose "True" if you like to include featured image in this gallery.','wdt-destination'),
				'param_name'  => 'include_featured_image',
				'value'       => array(
					esc_html__( 'False','wdt-destination') => 'false',
					esc_html__( 'True','wdt-destination')  => 'true',
				),
				'edit_field_class' => 'vc_column vc_col-sm-6'
			),

			// Class
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__( 'Class','wdt-destination'),
				'param_name'       => 'class',
				'description'      => esc_html__( 'If you wish you can add additional class name here.','wdt-destination'),
				'edit_field_class' => 'vc_column vc_col-sm-6'
			),

			/* Carousel Tab */

			// Effect
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__('Effect','wdt-destination'),
				'param_name' => 'carousel_effect',
				'value'      => array(
					esc_html__('Default','wdt-destination') => '',
					esc_html__('Fade','wdt-destination')    => 'fade',
				),
				'description'      => esc_html__( 'Choose effect for your carousel. Slides Per View has to be 1 for Fade effect.','wdt-destination'),
				'edit_field_class' => 'vc_column vc_col-sm-6',
				'group'            => 'Carousel',
				'std'              => ''
			),

			// Auto Play
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__('Auto Play','wdt-destination'),
				'param_name'       => 'carousel_autoplay',
				'description'      => esc_html__( 'Delay between transitions ( in ms ). Leave empty if you don\'t want to auto play.','wdt-destination'),
				'edit_field_class' => 'vc_column vc_col-sm-6',
				'group'            => 'Carousel',
			),

			// Slides Per View
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__('Slides Per View','wdt-destination'),
				'param_name' => 'carousel_slidesperview',
				'value'      => array(
					1 => 1,
					2 => 2,
					3 => 3,
					4 => 4,
				),
				'description'      => esc_html__( 'Number slides of to show in view port.','wdt-destination'),
				'edit_field_class' => 'vc_column vc_col-sm-6',
				'group'            => 'Carousel',
				'std'              => ''
			),

			// Enable loop mode
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__('Enable Loop Mode','wdt-destination'),
				'param_name' => 'carousel_loopmode',
				'value'      => array(
					esc_html__('False','wdt-destination') => 'false',
					esc_html__('True','wdt-destination')  => 'true',
				),
				'description'      => esc_html__( 'If you wish you can enable continous loop mode for your carousel.','wdt-destination'),
				'edit_field_class' => 'vc_column vc_col-sm-6',
				'group'            => 'Carousel',
				'std'              => ''
			),

			// Enable mousewheel control
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__('Enable Mousewheel Control','wdt-destination'),
				'param_name' => 'carousel_mousewheelcontrol',
				'value'      => array(
					esc_html__('False','wdt-destination') => 'false',
					esc_html__('True','wdt-destination')  => 'true',
				),
				'description'      => esc_html__( 'If you wish you can enable mouse wheel control for your carousel.','wdt-destination'),
				'edit_field_class' => 'vc_column vc_col-sm-6',
				'group'            => 'Carousel',
				'std'              => ''
			),

			// Enable vertical direction
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__('Enable Vertical Direction','wdt-destination'),
				'param_name' => 'carousel_verticaldirection',
				'value'      => array(
					esc_html__('False','wdt-destination') => 'false',
					esc_html__('True','wdt-destination')  => 'true',
				),
				'description'      => esc_html__( 'To make your slides to navigate vertically.','wdt-destination'),
				'edit_field_class' => 'vc_column vc_col-sm-6',
				'group'            => 'Carousel',
				'std'              => ''
			),

			// Pagination Type
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__('Pagination Type','wdt-destination'),
				'param_name' => 'carousel_paginationtype',
				'value'      => array(
					esc_html__('None','wdt-destination')         => '',
					esc_html__('Bullets','wdt-destination')      => 'bullets',
					esc_html__('Fraction','wdt-destination')     => 'fraction',
					esc_html__('Progress Bar','wdt-destination') => 'progressbar',
					esc_html__('Scroll Bar','wdt-destination')   => 'scrollbar',
					esc_html__('Thumbnail','wdt-destination')    => 'thumbnail'
				),
				'description'      => esc_html__( 'Choose pagination type you like to use.','wdt-destination'),
				'edit_field_class' => 'vc_column vc_col-sm-6',
				'group'            => 'Carousel',
				'std'              => ''
			),

			// Number of Thumbnails
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__('Number of Thumbnails','wdt-destination'),
				'param_name' => 'carousel_numberofthumbnails',
				'value'      => array(
					3 => 3,
					4 => 4,
					5 => 5,
					6 => 6,
				),
				'description'      => esc_html__( 'Number of thumbnails to show.','wdt-destination'),
				'edit_field_class' => 'vc_column vc_col-sm-6',
				'dependency'       => array( 'element' => 'carousel_paginationtype', 'value' =>'thumbnail' ),
				'group'            => 'Carousel',
				'std'              => 3
			),

			// Enable Arrow Pagination
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__('Enable Arrow Pagination','wdt-destination'),
				'param_name' => 'carousel_arrowpagination',
				'value'      => array(
					esc_html__('False','wdt-destination') => 'false',
					esc_html__('True','wdt-destination')  => 'true',
				),
				'description'      => esc_html__( 'To enable arrow pagination.','wdt-destination'),
				'edit_field_class' => 'vc_column vc_col-sm-6',
				'group'            => 'Carousel',
				'std'              => ''
			),

			// Arrow Type
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__('Arrow Type','wdt-destination'),
				'param_name' => 'carousel_arrowpagination_type',
				'value'      => array(
					esc_html__('Type 1','wdt-destination') => 'type1',
					esc_html__('Type 2','wdt-destination') => 'type2',
					esc_html__('Type 3','wdt-destination') => 'type3'
				),
				'description'      => esc_html__( 'Choose arrow pagination type for your carousel.','wdt-destination'),
				'edit_field_class' => 'vc_column vc_col-sm-6',
				'group'            => 'Carousel',
				'std'              => 'type1'
			),

			// Space Between Sliders
			array(
				'type'             => 'textfield',
				'heading'          => esc_html__('Space Between Sliders','wdt-destination'),
				'param_name'       => 'carousel_spacebetween',
				'description'      => esc_html__( 'Space between sliders can be given here.','wdt-destination'),
				'edit_field_class' => 'vc_column vc_col-sm-6',
				'group'            => 'Carousel',
			),

		)
	) );
}
?>