<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( !class_exists( 'AdvenxPlusBreadCrumbTypo' ) ) {
    class AdvenxPlusBreadCrumbTypo {

        private static $_instance = null;
        private $settings         = null;
        private $selector         = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        function __construct() {
            add_action( 'customize_register', array( $this, 'register' ), 15);
        }

        function register( $wp_customize ) {
            $wp_customize->add_section(
                new Advenx_Customize_Section(
                    $wp_customize,
                    'site-breadcrumb-typo-section',
                    array(
                        'title'    => esc_html__('Typography', 'advenx-plus'),
                        'panel'    => 'site-breadcrumb-main-panel',
                        'priority' => 15,
                    )
                )
            );

                if ( ! defined( 'ADVENX_PRO_VERSION' ) ) {
                    $wp_customize->add_control(
                        new Advenx_Customize_Control_Separator(
                            $wp_customize, ADVENX_CUSTOMISER_VAL . '[advenx-plus-site-breadcrumb-typo-separator]',
                            array(
                                'type'        => 'wdt-separator',
                                'section'     => 'site-breadcrumb-typo-section',
                                'settings'    => array(),
                                'caption'     => ADVENX_PLUS_REQ_CAPTION,
                                'description' => ADVENX_PLUS_REQ_DESC,
                            )
                        )
                    );
                }

        }
    }
}

AdvenxPlusBreadCrumbTypo::instance();