<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( !class_exists( 'AdvenxPlusCustomizerBlogPost' ) ) {
    class AdvenxPlusCustomizerBlogPost {

        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        function __construct() {
			add_action( 'customize_register', array( $this, 'register' ), 15 );
        }

        function register( $wp_customize ) {

            $wp_customize->add_section(
                new Advenx_Customize_Section(
                    $wp_customize,
                    'site-blog-post-section',
                    array(
                        'title'    => esc_html__('Single Post', 'advenx-plus'),
                        'panel'    => 'site-blog-main-panel',
                        'priority' => 20,
                    )
                )
            );

			if ( ! defined( 'ADVENX_PRO_VERSION' ) ) {
				$wp_customize->add_control(
					new Advenx_Customize_Control_Separator(
						$wp_customize, ADVENX_CUSTOMISER_VAL . '[advenx-plus-site-single-blog-separator]',
						array(
							'type'        => 'wdt-separator',
							'section'     => 'site-blog-post-section',
							'settings'    => array(),
							'caption'     => ADVENX_PLUS_REQ_CAPTION,
							'description' => ADVENX_PLUS_REQ_DESC,
						)
					)
				);
			}

        }
    }
}

AdvenxPlusCustomizerBlogPost::instance();