<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if (! class_exists ( 'AdvenxPlusHeaderPostType' ) ) {

	class AdvenxPlusHeaderPostType {

        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

		function __construct() {

			add_action ( 'init', array( $this, 'advenx_register_cpt' ), 5 );
			add_filter ( 'template_include', array ( $this, 'advenx_template_include' ) );
		}

		function advenx_register_cpt() {

			$labels = array (
				'name'				 => __( 'Headers', 'advenx-plus' ),
				'singular_name'		 => __( 'Header', 'advenx-plus' ),
				'menu_name'			 => __( 'Headers', 'advenx-plus' ),
				'add_new'			 => __( 'Add Header', 'advenx-plus' ),
				'add_new_item'		 => __( 'Add New Header', 'advenx-plus' ),
				'edit'				 => __( 'Edit Header', 'advenx-plus' ),
				'edit_item'			 => __( 'Edit Header', 'advenx-plus' ),
				'new_item'			 => __( 'New Header', 'advenx-plus' ),
				'view'				 => __( 'View Header', 'advenx-plus' ),
				'view_item' 		 => __( 'View Header', 'advenx-plus' ),
				'search_items' 		 => __( 'Search Headers', 'advenx-plus' ),
				'not_found' 		 => __( 'No Headers found', 'advenx-plus' ),
				'not_found_in_trash' => __( 'No Headers found in Trash', 'advenx-plus' ),
			);

			$args = array (
				'labels' 				=> $labels,
				'public' 				=> true,
				'exclude_from_search'	=> true,
				'show_in_nav_menus' 	=> false,
				'show_in_rest' 			=> true,
				'menu_position'			=> 25,
				'menu_icon' 			=> 'dashicons-heading',
				'hierarchical' 			=> false,
				'supports' 				=> array ( 'title', 'editor', 'revisions' ),
			);

			register_post_type ( 'wdt_headers', $args );
		}

		function advenx_template_include($template) {
			if ( is_singular( 'wdt_headers' ) ) {
				if ( ! file_exists ( get_stylesheet_directory () . '/single-wdt_headers.php' ) ) {
					$template = ADVENX_PLUS_DIR_PATH . 'post-types/templates/single-wdt_headers.php';
				}
			}

			return $template;
		}
	}
}

AdvenxPlusHeaderPostType::instance();