<?php

// Filter Dashboard Modules
if(!function_exists('dtdr_update_ads_dashboard_modules')) {
	function dtdr_update_ads_dashboard_modules($modules) {

        $modules['ads'] = array (
            'slug' => 'ads',
            'label' => esc_html__('Ads', 'dtdr'),
            'icon' => 'fas fa-ad',
            'callback' => 'dtdr_dashboard_seller_ads_page_content',
            'callback_args' => ''
        );

	    return $modules;

	}
	add_filter( 'dashboard_modules', 'dtdr_update_ads_dashboard_modules', 10, 1 );
}

// Filter Seller Modules
if(!function_exists('dashboard_update_ads_seller_modules')) {
	function dashboard_update_ads_seller_modules($modules) {

	    array_push($modules, 'ads');

	    return $modules;

	}
	add_filter( 'dashboard_seller_modules', 'dashboard_update_ads_seller_modules', 10, 1 );
}


function dtdr_dashboard_seller_ads_page_content() {

	$output = '';

	$output .= '<div class="dtdr-my-ads-container">';

		$output .= '<div class="dtdr-my-ads-item-holder">';

			$output .= '<div class="dtdr-dashbord-section-holder">';

				$output .= '<div class="dtdr-dashbord-section-holder-intro">';
					$output .= '<div class="dtdr-dashbord-section-title">'.esc_html__('Ads', 'dtdr').'</div>';
					$output .= '<div class="dtdr-dashbord-section-title-notes">'.esc_html__('If you like to create ad campaign you can do it here.', 'dtdr').'</div>';
				$output .= '</div>';

				$author_id = get_current_user_id();

				$output .= '<div class="dtdr-dashbord-section-holder-content">';
					$output .= '<a class="custom-button-style dtdr-add-ad-button" onclick="return false;" data-authorid="'.$author_id.'">'.esc_html__('Add New Ad', 'dtdr').'</a>';
				$output .= '</div>';

				$output .= '<div class="dtdr-dashbord-section-holder-content">';
					$output .= '<div class="dtdr-dashbord-ads-listing"></div>';
				$output .= '</div>';

				$output .= '<div class="dtdr-dashbord-section-holder-content">';
					$output .= '<div class="dtdr-dashboard-notices" style="display:none;"></div>';
					$output .= '<div class="dtdr-dashbord-ads-addnew-wrapper" style="display:none;"></div>';
				$output .= '</div>';

			$output .= '</div>';

		$output .= '</div>';

	$output .= '</div>';

	return $output;

}

// Ads Listing
add_action( 'wp_ajax_dtdr_dashbord_ads_listing', 'dtdr_dashbord_ads_listing' );
add_action( 'wp_ajax_nopriv_dtdr_dashbord_ads_listing', 'dtdr_dashbord_ads_listing' );
function dtdr_dashbord_ads_listing() {

	$output = '';

	$author_id = get_current_user_id();

	$seller_incharges = get_users ( array ('role' => 'incharge', 'meta_key' => 'user_seller', 'meta_value' => $author_id, 'fields' => 'ID') );
	if(is_array($seller_incharges) && !empty($seller_incharges)) {
		array_push($seller_incharges, $author_id);
		$sellers = $seller_incharges;
	} else {
		$sellers = array ( $author_id );
	}

	$author_listings_args = array (
		'posts_per_page' => -1,
		'post_type'      => 'dtdr_listings',
		'author'         => $sellers,
		'post_status'    => 'publish',
		'fields'		 => 'ids'
	);
	$author_listings = get_posts( $author_listings_args );
	wp_reset_postdata();

	$output .= '<table class="dtdr-custom-table" style="width:100%">
					<tr>
						<th>'.esc_html__('Listing', 'dtdr').'</th>
						<th>'.esc_html__('Ad Type', 'dtdr').'</th>
						<th>'.esc_html__('Expiry Date', 'dtdr').'</th>
						<th>'.esc_html__('Status', 'dtdr').'</th>
					</tr>';

    $record_exists = false;

	if(is_array($author_listings) && !empty($author_listings)) {
		foreach($author_listings as $author_listing) {

			$dtdr_ad_campaigns = get_post_meta($author_listing, 'dtdr_ad_campaigns', true);

			if(is_array($dtdr_ad_campaigns) && !empty($dtdr_ad_campaigns)) {

				$record_exists = true;

				$dtdr_ad_process_status = get_post_meta($author_listing, 'dtdr_ad_process_status', true);
				$dtdr_enddate           = get_post_meta($author_listing, 'dtdr_enddate', true);

				$dtdr_ad_status = $dtdr_enddate_str = '';
				if($dtdr_ad_process_status == 'incart') {
					$dtdr_ad_status .= '<span class="incart">'.esc_html__('In Cart', 'dtdr').'</span>';
					if(function_exists('wc_get_cart_url')) {
						$dtdr_ad_status .= '<a href="'.wc_get_cart_url().'" title="'.esc_attr__('View Cart', 'dtdr').'">'.esc_html__('View Cart', 'dtdr').'</a>';;
					}
				} else if($dtdr_ad_process_status == 'expired') {
					$dtdr_ad_status .= '<span class="expired">'.esc_html__('Expired', 'dtdr').'</span>';
				} else if($dtdr_ad_process_status == 'active') {
					$dtdr_ad_status .= '<span class="active">'.esc_html__('Active', 'dtdr').'</span>';
					$dtdr_enddate_str = date(get_option('date_format'), (int)$dtdr_enddate);
				}

				$ads_list = array (
								'dtdr_limelight' => esc_html__('Limelight', 'dtdr'),
								'dtdr_singlepage' => esc_html__('Single Page', 'dtdr'),
								'dtdr_topofsearch' => esc_html__('Top Of Search', 'dtdr')
							);
				$ads_list_keys = array_keys($ads_list);

				$dtdr_ad_campaign_str = '';
				foreach($dtdr_ad_campaigns as $dtdr_ad_campaign) {
					if(in_array($dtdr_ad_campaign, $ads_list_keys)) {
						$dtdr_ad_campaign_str .= $ads_list[$dtdr_ad_campaign].', ';
					}
				}
				$dtdr_ad_campaign_str = rtrim($dtdr_ad_campaign_str, ', ');

				$output .= '<tr>
								<td>'.get_the_title($author_listing).'</td>
								<td>'.$dtdr_ad_campaign_str.'</td>
								<td>'.$dtdr_enddate_str.'</td>
								<td>'.$dtdr_ad_status.'</td>
							</tr>';

			}

		}
	}

	if(!$record_exists) {

		$output .= '<tr>
						<td colspan="4">'.esc_html__('No Records Found!', 'dtdr').'</td>
					</tr>';

	}

	$output .= '</table>';

	echo dtdr_html_output($output);

	wp_die();

}

// Populate ad Fields
add_action( 'wp_ajax_dtdr_dashbord_populate_ad_form', 'dtdr_dashbord_populate_ad_form' );
add_action( 'wp_ajax_nopriv_dtdr_dashbord_populate_ad_form', 'dtdr_dashbord_populate_ad_form' );
function dtdr_dashbord_populate_ad_form() {

	extract(dtdr_recursive_sanitize_text_field($_REQUEST));

	$author_id = get_current_user_id();

	$seller_incharges = get_users ( array ('role' => 'incharge', 'meta_key' => 'user_seller', 'meta_value' => $author_id, 'fields' => 'ID') );
	if(is_array($seller_incharges) && !empty($seller_incharges)) {
		array_push($seller_incharges, $author_id);
		$sellers = $seller_incharges;
	} else {
		$sellers = array ( $author_id );
	}

	$output = '';

	// Author Listing Ids
	$author_listings_args = array (
		'posts_per_page' => -1,
		'post_type'      => 'dtdr_listings',
		'author__in'     => $sellers,
		'post_status'    => 'publish',
		'meta_key'       => 'dtdr_ad_process_status',
		'meta_compare'   => 'NOT EXISTS',
		'fields'         => 'ids'
	);

	$author_listings = new WP_Query( $author_listings_args );

	$post_count = $author_listings->found_posts;

	if($post_count > 0) {

		if(dtdr_option('ads','enable-limelight-ads') == 'true' || dtdr_option('ads','enable-singlepage-ads') == 'true' || dtdr_option('ads','enable-topofsearch-ads') == 'true') {

			$output .= '<form name="dtdr-dashbord-ad-form" method="post" action="" class="dtdr-dashbord-ad-form">';

				$output .= '<div class="dtdr-column dtdr-one-column first">';

					if($author_listings->have_posts()) {
						$output .= '<select name="dtdr_ad_listing" class="dtdr-ad-listing dtdr-chosen-select">';
						while($author_listings->have_posts()) {
							$author_listings->the_post();
							$output .= '<option value="'.get_the_ID().'">'.get_the_title().'</option>';
						}
						$output .= '</select>';
						wp_reset_postdata();
					}

				$output .= '</div>';

				$output .= '<div class="dtdr-dashbord-ad-details">';

					if(dtdr_option('ads','enable-limelight-ads') == 'true') {

						$output .= '<div class="dtdr-column dtdr-one-third first">';

							$limelight_ads_product = dtdr_option('ads','limelight-ads-product');

							$output .= '<div class="dtdr-ad-limelight-field">';
								$output .= '<input type="checkbox" name="dtdr_ad_limelight" class="dtdr-ad-limelight" id="dtdr-ad-limelight" value="true" data-productid="'.$limelight_ads_product.'" />';
								$output .= '<label for="dtdr-ad-limelight">'.esc_html__('Limelight', 'dtdr').'</label>';
							$output .= '</div>';

							if($limelight_ads_product != '' && $limelight_ads_product > 0) {
								$output .= '<div class="dtdr-ad-limelight-pricing">';
									$product = dtdr_get_product_object($limelight_ads_product);
									$woo_price = dtdr_get_item_price_html($product);
									$output .= $woo_price.' '.esc_html__('/ day');
								$output .= '</div>';
							}

						$output .= '</div>';

					}

					if(dtdr_option('ads','enable-singlepage-ads') == 'true') {

						$output .= '<div class="dtdr-column dtdr-one-third">';

							$singlepage_ads_product = dtdr_option('ads','singlepage-ads-product');

							$output .= '<div class="dtdr-ad-singlepage-field">';
								$output .= '<input type="checkbox" name="dtdr_ad_singlepage" class="dtdr-ad-singlepage" id="dtdr-ad-singlepage" value="true" data-productid="'.$singlepage_ads_product.'" />';
								$output .= '<label for="dtdr-ad-singlepage">'.esc_html__('Single Page', 'dtdr').'</label>';
							$output .= '</div>';

							if($singlepage_ads_product != '' && $singlepage_ads_product > 0) {
								$output .= '<div class="dtdr-ad-singlepage-pricing">';
									$product = dtdr_get_product_object($singlepage_ads_product);
									$woo_price = dtdr_get_item_price_html($product);
									$output .= $woo_price.' '.esc_html__('/ day');
								$output .= '</div>';
							}

						$output .= '</div>';

					}

					if(dtdr_option('ads','enable-topofsearch-ads') == 'true') {

						$output .= '<div class="dtdr-column dtdr-one-third">';

							$topofsearch_ads_product = dtdr_option('ads','topofsearch-ads-product');

							$output .= '<div class="dtdr-ad-topofsearch-field">';
								$output .= '<input type="checkbox" name="dtdr_ad_topofsearch" class="dtdr-ad-topofsearch" id="dtdr-ad-topofsearch" value="true" data-productid="'.$topofsearch_ads_product.'" />';
								$output .= '<label for="dtdr-ad-topofsearch">'.esc_html__('Top Of Search', 'dtdr').'</label>';
							$output .= '</div>';

							if($topofsearch_ads_product != '' && $topofsearch_ads_product > 0) {
								$output .= '<div class="dtdr-ad-topofsearch-pricing">';
									$product = dtdr_get_product_object($topofsearch_ads_product);
									$woo_price = dtdr_get_item_price_html($product);
									$output .= $woo_price.' '.esc_html__('/ day');
								$output .= '</div>';
							}

						$output .= '</div>';

					}

				$output .= '</div>';

				$output .= '<div class="dtdr-column dtdr-one-column first">';
					$output .= '<label>'.esc_html__('Duration in number of Day(s)', 'dtdr').'</label><input type="number" name="dtdr_ad_duration" class="dtdr-ad-duration" placeholder="" />';
				$output .= '</div>';

				$output .= '<div class="dtdr-column dtdr-one-column first">';
					$output .= '<div class="dtdr-ad-addtocart-purchase-preview"></div>';
				$output .= '</div>';

				$output .= '<a class="custom-button-style dtdr-ad-addtocart-button" onclick="return false;">'.esc_html__('Ad - Add to Cart', 'dtdr').'</a>';

			$output .= '</form>';

		} else {

			$output .= esc_html__('Ad configuration not done. Please contact admin for further details.', 'dtdr');

		}

	} else {

		$output .= esc_html__('No records found to continue the Ad process.', 'dtdr');

	}

	echo dtdr_html_output($output);

	wp_die();

}

// Ad Add to Cart Purhcase Preview
add_action( 'wp_ajax_dtdr_populate_ad_addtocart_purchase_preview', 'dtdr_populate_ad_addtocart_purchase_preview' );
add_action( 'wp_ajax_nopriv_dtdr_populate_ad_addtocart_purchase_preview', 'dtdr_populate_ad_addtocart_purchase_preview' );
function dtdr_populate_ad_addtocart_purchase_preview() {

	extract(dtdr_recursive_sanitize_text_field($_REQUEST));

	$total_amount = 0;
	$output = '';
	$ads = array ();

	if($duration != '' && $duration > 0) {

		global $woocommerce;

		$limelight_class = $singlepage_class = $topofsearch_class = '';

		if($limelight) {

			$product = dtdr_get_product_object($limelight_productid);
			$woo_price = dtdr_get_item_price_html($product);

			$woo_sale_price = $product->get_sale_price();

			$total_amount = $total_amount + $woo_sale_price;

			$limelight_class = 'active';

		}

		if($singlepage) {

			$product = dtdr_get_product_object($singlepage_productid);
			$woo_price = dtdr_get_item_price_html($product);

			$woo_sale_price = $product->get_sale_price();

			$total_amount = $total_amount + $woo_sale_price;

			$singlepage_class = 'active';

		}

		if($topofsearch) {

			$product = dtdr_get_product_object($topofsearch_productid);
			$woo_price = dtdr_get_item_price_html($product);

			$woo_sale_price = $product->get_sale_price();

			$total_amount = $total_amount + $woo_sale_price;

			$topofsearch_class = 'active';

		}

		$total_amount = ( $total_amount * $duration );

		$output .= '<ul class="dtdr-addtocart-purhcase-preview-wrapper">';
			$output .= '<li>'.esc_html__('Limelight', 'dtdr').'<span class="'.esc_attr($limelight_class).'"></span></li>';
			$output .= '<li>'.esc_html__('Single Page', 'dtdr').'<span class="'.esc_attr($singlepage_class).'"></span></li>';
			$output .= '<li>'.esc_html__('Top Of Search', 'dtdr').'<span class="'.esc_attr($topofsearch_class).'"></span></li>';
			$output .= '<li class="duration">'.sprintf(esc_html__('Duration ( in Days ) %1$s', 'dtdr'), '<span>'.esc_attr($duration).'</span>').'</li>';
			$output .= '<li class="total-amount">'.sprintf(esc_html__('Total Amount %1$s', 'dtdr'), '<span>'.esc_attr($total_amount).'</span>').'</li>';
		$output .= '</ul>';

	}

	echo dtdr_html_output($output);

	wp_die();

}

// Ad Add to Cart In Action
add_action( 'wp_ajax_dtdr_ad_addtocart_in_action', 'dtdr_ad_addtocart_in_action' );
add_action( 'wp_ajax_nopriv_dtdr_ad_addtocart_in_action', 'dtdr_ad_addtocart_in_action' );
function dtdr_ad_addtocart_in_action() {

	extract(dtdr_recursive_sanitize_text_field($_REQUEST));

	$total_amount = 0;

	$ads = array ();

	if($duration != '' && $duration > 0) {

		global $woocommerce;

		$ads_in_cart = array ();

		if($limelight) {

			$data['dtdr_ads']['listing_id']    = $listing_id;
			$data['dtdr_ads']['ad_type']       = 'dtdr_limelight';
			$data['dtdr_ads']['ad_product_id'] = $limelight_productid;
			$data['dtdr_ads']['ad_duration']   = $duration;

			$woocommerce->cart->add_to_cart($limelight_productid, 1, 0, array (), $data);

			array_push($ads_in_cart, 'dtdr_limelight');

		}

		if($singlepage) {

			$data['dtdr_ads']['listing_id']    = $listing_id;
			$data['dtdr_ads']['ad_type']       = 'dtdr_singlepage';
			$data['dtdr_ads']['ad_product_id'] = $singlepage_productid;
			$data['dtdr_ads']['ad_duration']   = $duration;

			$woocommerce->cart->add_to_cart($singlepage_productid, 1, 0, array (), $data);

			array_push($ads_in_cart, 'dtdr_singlepage');

		}

		if($topofsearch) {

			$data['dtdr_ads']['listing_id']    = $listing_id;
			$data['dtdr_ads']['ad_type']       = 'dtdr_topofsearch';
			$data['dtdr_ads']['ad_product_id'] = $topofsearch_productid;
			$data['dtdr_ads']['ad_duration']   = $duration;

			$woocommerce->cart->add_to_cart($topofsearch_productid, 1, 0, array (), $data);

			array_push($ads_in_cart, 'dtdr_topofsearch');

		}

		if($limelight || $singlepage || $topofsearch) {

			update_post_meta($listing_id, 'dtdr_ad_campaigns', $ads_in_cart);
			update_post_meta($listing_id, 'dtdr_ad_process_status', 'incart');

		}

	}



	echo dtdr_html_output($output);

	wp_die();

}

?>