<?php

// Filter Dashboard Modules
if(!function_exists('dtdr_update_announcements_dashboard_modules')) {
	function dtdr_update_announcements_dashboard_modules($modules) {

	    $modules['announcements'] = array (
			'slug' => 'announcements',
			'label' => esc_html__('Announcements', 'dtdr'),
			'icon' => 'fas fa-bullhorn',
			'callback' => 'dtdr_dashboard_seller_announcements_page_content',
			'callback_args' => ''
		);

	    return $modules;

	}
	add_filter( 'dashboard_modules', 'dtdr_update_announcements_dashboard_modules', 10, 1 );
}

// Filter Seller Modules
if(!function_exists('dashboard_update_announcements_seller_modules')) {
	function dashboard_update_announcements_seller_modules($modules) {

	    array_push($modules, 'announcements');

	    return $modules;

	}
	add_filter( 'dashboard_seller_modules', 'dashboard_update_announcements_seller_modules', 10, 1 );
}


// Dashboard Content
if(!function_exists('dtdr_dashboard_seller_announcements_page_content')) {
	function dtdr_dashboard_seller_announcements_page_content() {

		$output = '';

		$output .= '<div class="dtdr-my-announcements-container">';

			$output .= '<div class="dtdr-my-announcements-item-holder">';

				$output .= '<div class="dtdr-dashbord-section-holder">';

					$output .= '<div class="dtdr-dashbord-section-holder-intro">';
						$output .= '<div class="dtdr-dashbord-section-title">'.esc_html__('Announcements', 'dtdr').'</div>';
						$output .= '<div class="dtdr-dashbord-section-title-notes">'.esc_html__('If you like to convey any messages or offers or announcements, you can do so here.', 'dtdr').'</div>';
					$output .= '</div>';

					$author_id = get_current_user_id();

					$output .= '<div class="dtdr-dashbord-section-holder-content">';
						$output .= '<a class="custom-button-style dtdr-add-announcements-button" onclick="return false;" data-authorid="'.$author_id.'">'.esc_html__('Add Announcements', 'dtdr').'</a>';
					$output .= '</div>';

					$output .= '<div class="dtdr-dashbord-section-holder-content">';

						$output .= '<div class="dtdr-dashboard-notices" style="display:none;"></div>';

						$output .= '<div class="dtdr-dashbord-announcements-addnew-wrapper" style="display:none;"></div>';

					$output .= '</div>';

					$output .= '<div class="dtdr-dashbord-section-holder-content">';

						$output .= '<div class="dtdr-dashbord-announcements-listing"></div>';

					$output .= '</div>';

				$output .= '</div>';

			$output .= '</div>';

		$output .= '</div>';

		return $output;

	}
}


// Populate Announcement Fields
if(!function_exists('dtdr_dashbord_populate_announcement_fields')) {
	function dtdr_dashbord_populate_announcement_fields() {

		extract(dtdr_recursive_sanitize_text_field($_REQUEST));

		$action = $title = $description = $icon = $button_text = $button_link = '';

		if($mode == 'edit') {

			$dtdr_listing_announcements = get_post_meta($listing_id, 'dtdr_listing_announcements', true);
			$dtdr_listing_announcements = (is_array($dtdr_listing_announcements) && !empty($dtdr_listing_announcements)) ? $dtdr_listing_announcements : array ();

			if(isset($dtdr_listing_announcements[$announcement_id]) && !empty($dtdr_listing_announcements[$announcement_id])) {
				$action      = $dtdr_listing_announcements[$announcement_id]['action'];
				$title       = $dtdr_listing_announcements[$announcement_id]['title'];
				$description = $dtdr_listing_announcements[$announcement_id]['description'];
				$icon        = $dtdr_listing_announcements[$announcement_id]['icon'];
				$button_text = $dtdr_listing_announcements[$announcement_id]['button_text'];
				$button_link = $dtdr_listing_announcements[$announcement_id]['button_link'];
			}

		}

		$author_id = get_current_user_id();

		$output = '';

		$output .= '<form name="dtdr-dashbord-submit-announcement" method="post" action="" class="dtdr-dashbord-submit-announcement">';

			$output .= '<div class="dtdr-column dtdr-one-column">';
			$output .= '</div>';

			if($mode == 'add') {

				$output .= '<div class="dtdr-column dtdr-one-half first">';

					$announcement_actions = array ('announcement' => esc_html__('Announcement', 'dtdr'), 'booknow' => esc_html__('Book Now', 'dtdr'), 'contactus' => esc_html__('Contact Us', 'dtdr'));

					$output .= '<select name="dtdr_announcement_action" class="dtdr-chosen-select">';
						foreach($announcement_actions as $key => $announcement_action) {
							$output .= '<option value="'.esc_attr($key).'">'.esc_html($announcement_action).'</option>';
						}
					$output .= '</select>';

				$output .= '</div>';

				$output .= '<div class="dtdr-column dtdr-one-half">';

					// Author Listing Ids
					$author_listings_args = array (
						'posts_per_page' => -1,
						'post_type'      => 'dtdr_listings',
						'author'         => $author_id,
						'post_status'    => 'publish',
						'fields'		 => 'ids'
					);
					$author_listings = get_posts( $author_listings_args );
					wp_reset_postdata();

					if(is_array($author_listings) && !empty($author_listings)) {
						$output .= '<select name="dtdr_announcement_listing" class="dtdr-chosen-select">';
							foreach($author_listings as $author_listing) {
								$output .= '<option value="'.esc_attr($author_listing).'">'.get_the_title($author_listing).'</option>';
							}
						$output .= '</select>';
					}

				$output .= '</div>';

			}

			$output .= '<div class="dtdr-column dtdr-one-column first">';
				$output .= '<input type="text" name="dtdr_announcement_title" placeholder="'.esc_html__('Title', 'dtdr').'" value="'.esc_attr($title).'" />';
				$output .= '<textarea name="dtdr_announcement_description" placeholder="'.esc_html__('Description', 'dtdr').'">'.esc_html($description).'</textarea>';
			$output .= '</div>';

			$output .= '<div class="dtdr-column dtdr-one-half first">';
				$output .= '<input type="text" name="dtdr_announcement_icon" placeholder="'.esc_html__('Icon', 'dtdr').'" value="'.esc_attr($icon).'" />';
			$output .= '</div>';

			$output .= '<div class="dtdr-column dtdr-one-half">';
				$output .= '<input type="text" name="dtdr_announcement_button_text" placeholder="'.esc_html__('Button Text', 'dtdr').'" value="'.esc_attr($button_text).'" />';
			$output .= '</div>';

			$output .= '<div class="dtdr-column dtdr-one-column first">';
				$output .= '<input type="text" name="dtdr_announcement_button_link" placeholder="'.esc_html__('Button Link', 'dtdr').'" value="'.esc_attr($button_link).'" />';
			$output .= '</div>';

			$output .= '<input type="hidden" name="mode" value="'.esc_attr($mode).'" />';
			$output .= '<input type="hidden" name="listing_id" value="'.esc_attr($listing_id).'" />';
			$output .= '<input type="hidden" name="announcement_id" value="'.esc_attr($announcement_id).'" />';

			$output .= '<a class="custom-button-style dtdr-submit-announcement-button" onclick="return false;">'.esc_html__('Submit Announcement', 'dtdr').'</a>';
			$output .= '<a class="custom-button-style dtdr-close-announcement-button" onclick="return false;">'.esc_html__('Close', 'dtdr').'</a>';

		$output .= '</form>';

		echo dtdr_html_output($output);

		wp_die();

	}
	add_action( 'wp_ajax_dtdr_dashbord_populate_announcement_fields', 'dtdr_dashbord_populate_announcement_fields' );
	add_action( 'wp_ajax_nopriv_dtdr_dashbord_populate_announcement_fields', 'dtdr_dashbord_populate_announcement_fields' );
}

// Add announcement from frontend
if(!function_exists('dtdr_submit_announcement')) {
	function dtdr_submit_announcement() {

		extract(dtdr_recursive_sanitize_text_field($_REQUEST));

		if($mode == 'edit') {
			$dtdr_announcement_listing = $listing_id;
		}

		if($dtdr_announcement_listing !='') {

			$dtdr_listing_announcements = get_post_meta($dtdr_announcement_listing, 'dtdr_listing_announcements', true);
			$dtdr_listing_announcements = (is_array($dtdr_listing_announcements) && !empty($dtdr_listing_announcements)) ? $dtdr_listing_announcements : array ();

			if($mode == 'edit') {

				if($announcement_id != ''){
					if(isset($dtdr_listing_announcements[$announcement_id]) && !empty($dtdr_listing_announcements[$announcement_id])) {
						$dtdr_listing_announcements[$announcement_id]['title']       = $dtdr_announcement_title;
						$dtdr_listing_announcements[$announcement_id]['description'] = $dtdr_announcement_description;
						$dtdr_listing_announcements[$announcement_id]['icon']        = $dtdr_announcement_icon;
						$dtdr_listing_announcements[$announcement_id]['button_text'] = $dtdr_announcement_button_text;
						$dtdr_listing_announcements[$announcement_id]['button_link'] = $dtdr_announcement_button_link;
					}
				}

			} else {

				$announcementData                = array ();
				$announcementData['listing_id']  = $dtdr_announcement_listing;
				$announcementData['action']      = $dtdr_announcement_action;
				$announcementData['title'] 	     = $dtdr_announcement_title;
				$announcementData['description'] = $dtdr_announcement_description;
				$announcementData['icon']        = $dtdr_announcement_icon;
				$announcementData['button_text'] = $dtdr_announcement_button_text;
				$announcementData['button_link'] = $dtdr_announcement_button_link;
				$announcementData['status']      = 1;

				array_unshift($dtdr_listing_announcements, $announcementData);

			}

			update_post_meta($dtdr_announcement_listing, 'dtdr_listing_announcements', $dtdr_listing_announcements);

		}

		wp_die();

	}
	add_action( 'wp_ajax_dtdr_submit_announcement', 'dtdr_submit_announcement' );
	add_action( 'wp_ajax_nopriv_dtdr_submit_announcement', 'dtdr_submit_announcement' );
}

// Announcements Listing
if(!function_exists('dtdr_dashbord_announcements_listing')) {
	function dtdr_dashbord_announcements_listing() {

		$author_id = get_current_user_id();

		$output = '';

		$announcement_actions = array ('announcement' => esc_html__('Announcement', 'dtdr'), 'booknow' => esc_html__('Book Now', 'dtdr'), 'contactus' => esc_html__('Contact Us', 'dtdr'));

		// Author Listing Ids based on Announcement meta key
		$author_listings_args = array (
			'posts_per_page' => -1,
			'post_type'      => 'dtdr_listings',
			'author'         => $author_id,
			'post_status'    => 'publish',
			'fields'		 => 'ids',
			'meta_query'     => array (),
		);

		$author_listings_args['meta_query'][] = array (

			'relation' => 'AND',
			array (
				'key'     => 'dtdr_listing_announcements',
				'compare' => 'EXISTS',
			),
			array (
				'key'     => 'dtdr_listing_announcements',
				'value'   => '',
				'compare' => '!='
			)

		);

		$author_listings = get_posts( $author_listings_args );
		wp_reset_postdata();

		if(is_array($author_listings) && !empty($author_listings)) {

			$output .= '<table class="dtdr-custom-table" style="width:100%">
							<tr>
								<th>'.esc_html__('Listing', 'dtdr').'</th>
								<th>'.esc_html__('Action', 'dtdr').'</th>
								<th>'.esc_html__('Title', 'dtdr').'</th>
								<th>'.esc_html__('Description', 'dtdr').'</th>
								<th>'.esc_html__('Activate', 'dtdr').'</th>
								<th>'.esc_html__('Options', 'dtdr').'</th>
							</tr>';

			foreach($author_listings as $author_listing) {

				$dtdr_listing_announcements = get_post_meta( $author_listing, 'dtdr_listing_announcements', true);
				$dtdr_listing_announcements = (is_array($dtdr_listing_announcements) && !empty($dtdr_listing_announcements)) ? $dtdr_listing_announcements : array ();

				foreach($dtdr_listing_announcements as $key => $dtdr_listing_announcement) {

					if($dtdr_listing_announcement['status']) {
						$status_str = '<a class="dtdr-dashboard-announcement-status-marker" data-tooltip="'.esc_html__('Active', 'dtdr').'" href="#" onclick="return false;" data-announcement-id="'.esc_attr($key).'" data-listing-id="'.esc_attr($dtdr_listing_announcement['listing_id']).'"><i class="fas fa-toggle-on"></i></a>';
					} else {
						$status_str = '<a class="dtdr-dashboard-announcement-status-marker" data-tooltip="'.esc_html__('Disabled', 'dtdr').'" href="#" onclick="return false;" data-announcement-id="'.esc_attr($key).'" data-listing-id="'.esc_attr($dtdr_listing_announcement['listing_id']).'"><i class="fas fa-toggle-off"></i></a>';
					}

					$options = '<a class="dtdr-dashboard-announcement-edit" data-tooltip="'.esc_html__('Edit %1$s', 'dtdr').'" href="#" onclick="return false;" data-nonce="'.wp_create_nonce('dtdr-edit-announcement-'.$dtdr_listing_announcement['listing_id'].'-'.$key).'" data-announcement-id="'.esc_attr($key).'" data-listing-id="'.esc_attr($dtdr_listing_announcement['listing_id']).'">
									<i class="far fa-edit"></i>
								</a>';

					$options .= '<a class="dtdr-dashboard-announcement-delete" data-tooltip="'.esc_html__('Delete %1$s', 'dtdr').'" href="#" onclick="return false;" data-nonce="'.wp_create_nonce('dtdr-delete-announcement-'.$dtdr_listing_announcement['listing_id'].'-'.$key).'" data-announcement-id="'.esc_attr($key).'" data-listing-id="'.esc_attr($dtdr_listing_announcement['listing_id']).'">
									<i class="far fa-times-circle"></i>
								</a>';

					$output .= '<tr>
									<td>'.get_the_title($dtdr_listing_announcement['listing_id']).'</td>
									<td>'.$announcement_actions[$dtdr_listing_announcement['action']].'</td>
									<td>'.$dtdr_listing_announcement['title'].'</td>
									<td>'.$dtdr_listing_announcement['description'].'</td>
									<td>'.$status_str.'</td>
									<td>'.$options.'</td>
								</tr>';

				}

			}

			$output .= '</table>';

		}

		echo dtdr_html_output($output);

		wp_die();

	}
	add_action( 'wp_ajax_dtdr_dashbord_announcements_listing', 'dtdr_dashbord_announcements_listing' );
	add_action( 'wp_ajax_nopriv_dtdr_dashbord_announcements_listing', 'dtdr_dashbord_announcements_listing' );
}

// Announcement Listing - Status Switch
if(!function_exists('dtdr_dashboard_announcement_status_marker')) {
	function dtdr_dashboard_announcement_status_marker() {

		extract(dtdr_recursive_sanitize_text_field($_REQUEST));

		$output = '';

		if($listing_id > 0 && $announcement_id != '') {

			if($action_type == 'add') {

				$dtdr_listing_announcements = get_post_meta($listing_id, 'dtdr_listing_announcements', true);
				$dtdr_listing_announcements = (is_array($dtdr_listing_announcements) && !empty($dtdr_listing_announcements)) ? $dtdr_listing_announcements : array ();

				$dtdr_listing_announcements[$announcement_id]['status'] = 1;

				update_post_meta($listing_id, 'dtdr_listing_announcements', $dtdr_listing_announcements);

				$output .= 'success-add';

			} else if($action_type == 'remove') {

				$dtdr_listing_announcements = get_post_meta($listing_id, 'dtdr_listing_announcements', true);
				$dtdr_listing_announcements = (is_array($dtdr_listing_announcements) && !empty($dtdr_listing_announcements)) ? $dtdr_listing_announcements : array ();

				$dtdr_listing_announcements[$announcement_id]['status'] = 0;

				update_post_meta($listing_id, 'dtdr_listing_announcements', $dtdr_listing_announcements);

				$output .= 'success-remove';

			}

		}

		echo dtdr_html_output($output);

		wp_die();

	}
	add_action( 'wp_ajax_dtdr_dashboard_announcement_status_marker', 'dtdr_dashboard_announcement_status_marker' );
	add_action( 'wp_ajax_nopriv_dtdr_dashboard_announcement_status_marker', 'dtdr_dashboard_announcement_status_marker' );
}

// Announcement Listing - Delete
if(!function_exists('dtdr_dashboard_announcement_delete')) {
	function dtdr_dashboard_announcement_delete() {

		extract(dtdr_recursive_sanitize_text_field($_REQUEST));

		$has_error = false;
		$errors = array ();

		if(wp_verify_nonce($nonce, 'dtdr-delete-announcement-'.$listing_id.'-'.$announcement_id)) {

			if($listing_id > 0 && $announcement_id != ''){

				$dtdr_listing_announcements = get_post_meta($listing_id, 'dtdr_listing_announcements', true);
				$dtdr_listing_announcements = (is_array($dtdr_listing_announcements) && !empty($dtdr_listing_announcements)) ? $dtdr_listing_announcements : array ();

				unset($dtdr_listing_announcements[$announcement_id]);

				update_post_meta($listing_id, 'dtdr_listing_announcements', $dtdr_listing_announcements);

				echo 'success';

			} else {

				$has_error = true;
				$errors[] = '<p>A'.esc_html__('Something went wrong!, Please try again.', 'dtdr').'</p>';

			}

		} else {

			$has_error = true;
			$errors[] = '<p>B'.esc_html__('Something went wrong!, Please try again.', 'dtdr').'</p>';

		}

		if($has_error) {
			echo json_encode($errors);
		}

		wp_die();

	}
	add_action( 'wp_ajax_dtdr_dashboard_announcement_delete', 'dtdr_dashboard_announcement_delete' );
	add_action( 'wp_ajax_nopriv_dtdr_dashboard_announcement_delete', 'dtdr_dashboard_announcement_delete' );
}

?>