<?php

if (!class_exists ( 'DTDirectoryRegisterFloorPlanModule' )) {

	class DTDirectoryRegisterFloorPlanModule extends DTDirectoryAddon {

		private $module_name;
		private $module_url;

		/**
		 * Instance variable
		 */
		private static $_instance = null;

		/**
		 * Instance
		 *
		 * Ensures only one instance of the class is loaded or can be loaded.
		 */
		public static function instance() {

			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}

			return self::$_instance;
		}

		function __construct() {

			$this->dtdr_define_constants( 'DTDR_FLOORPLAN_PLUGIN_PATH', DTDR_PLUGIN_PATH . 'modules/floor-plan/' );
			$this->dtdr_define_constants( 'DTDR_FLOORPLAN_PLUGIN_URL', DTDR_PLUGIN_URL . 'modules/floor-plan/' );

			add_filter ( 'dtdr_metabox_tabs', array ( $this, 'dtdr_metabox_tabs_tab' ) );

			add_action ( 'admin_enqueue_scripts', array ( $this, 'dtdr_admin_enqueue_scripts' ), 120 );
			add_action ( 'wp_enqueue_scripts', array ( $this, 'dtdr_enqueue_scripts' ), 130 );

			add_action ( 'dtdr_addorupdate_listing_module', array ( $this, 'dtdr_addorupdate_listing_floorplan_module' ), 10, 2 );

			require_once DTDR_FLOORPLAN_PLUGIN_PATH . 'shortcodes.php';
			require_once DTDR_FLOORPLAN_PLUGIN_PATH . 'utils.php';
			require_once DTDR_FLOORPLAN_PLUGIN_PATH . 'dashboard.php';

		}

		function dtdr_metabox_tabs_tab($tabs) {

			$tabs['floor-plan'] = array (
				'label' => esc_html__('Floor Plan', 'dtdr'),
				'icon' => 'fas fa-columns',
				'path' => DTDR_FLOORPLAN_PLUGIN_PATH . 'metabox-tab-listing.php'
			);

			return $tabs;

		}

		function dtdr_admin_enqueue_scripts() {

			$this->dtdr_register_dependent_files();

			$current_screen = get_current_screen();
			if($current_screen->id == 'dtdr_listings') {
				wp_enqueue_style ( 'dtdr-floor-plan-fields' );
				wp_enqueue_script ( 'dtdr-floor-plan-fields' );
			}

		}

		function dtdr_enqueue_scripts() {

			$this->dtdr_register_dependent_files();
			$this->dtdr_enqueue_registered_files();

			if(is_page_template('tpl-dashboard.php')) {
				wp_enqueue_style ( 'dtdr-floor-plan-fields' );
				wp_enqueue_script ( 'dtdr-floor-plan-fields' );
			}

		}

		function dtdr_register_dependent_files() {

			wp_register_style ( 'dtdr-floor-plan-fields', DTDR_FLOORPLAN_PLUGIN_URL . 'assets/floor-plan-fields.css', array ( 'dtdr-fields' ) );
			wp_register_style ( 'dtdr-floor-plan-frontend', DTDR_FLOORPLAN_PLUGIN_URL . 'assets/floor-plan-frontend.css', array ( 'fontawesome', 'material-icon', 'dtdr-base', 'dtdr-common' ) );

			wp_register_script ( 'dtdr-toggle-click', DTDR_FLOORPLAN_PLUGIN_URL . 'assets/jquery.toggle.click.js', array ('jquery'), false, true );
			wp_register_script ( 'dtdr-floor-plan-fields', DTDR_FLOORPLAN_PLUGIN_URL . 'assets/fields.js', array ('jquery', 'dtdr-fields'), false, true );
			wp_register_script ( 'dtdr-floor-plan-frontend', DTDR_FLOORPLAN_PLUGIN_URL . 'assets/frontend.js', array ('jquery', 'dtdr-modules-singlepage'), false, true );

		}

		function dtdr_enqueue_registered_files() {

			wp_enqueue_style ( 'dtdr-floor-plan-frontend' );

			wp_enqueue_script ( 'dtdr-toggle-click' );
			wp_enqueue_script ( 'dtdr-floor-plan-frontend' );

		}

		function dtdr_addorupdate_listing_floorplan_module($data, $listing_id) {

			extract($data);

			update_post_meta($listing_id, 'dtdr_floorplan_title', $dtdr_floorplan_title);
			update_post_meta($listing_id, 'dtdr_floorplan_description', $dtdr_floorplan_description);
			update_post_meta($listing_id, 'dtdr_floorplan_image', $dtdr_floorplan_image);
			update_post_meta($listing_id, 'dtdr_floorplan_size', $dtdr_floorplan_size);
			update_post_meta($listing_id, 'dtdr_floorplan_rooms', $dtdr_floorplan_rooms);
			update_post_meta($listing_id, 'dtdr_floorplan_baths', $dtdr_floorplan_baths);
			update_post_meta($listing_id, 'dtdr_floorplan_price', $dtdr_floorplan_price);

		}

	}

}

if( !function_exists('dtdrFloorPlanModule') ) {
	function dtdrFloorPlanModule() {
		return DTDirectoryRegisterFloorPlanModule::instance();
	}
}

dtdrFloorPlanModule();
?>