<?php

// Filter Listing Fields
if(!function_exists('dtdr_add_listing_fields_from_location_modules')) {
	function dtdr_add_listing_fields_from_location_modules( $edit_item_id , $output = '') {

		$listing_singular_label = apply_filters( 'listing_label', 'singular' );

		$dtdr_listings_city_array         = get_the_terms($edit_item_id, 'dtdr_listings_city');
		$dtdr_listings_neighborhood_array = get_the_terms($edit_item_id, 'dtdr_listings_neighborhood');
		$dtdr_listings_countystate_array  = get_the_terms($edit_item_id, 'dtdr_listings_countystate');

		$dtdr_address                     = get_post_meta($edit_item_id, 'dtdr_address', true);
		$dtdr_zip                         = get_post_meta($edit_item_id, 'dtdr_zip', true);
		$dtdr_country                     = get_post_meta($edit_item_id, 'dtdr_country', true);

		$dtdr_latitude                    = get_post_meta($edit_item_id, 'dtdr_latitude', true);
		$dtdr_longitude                   = get_post_meta($edit_item_id, 'dtdr_longitude', true);

		$dtdr_virtual_tour                = get_post_meta($edit_item_id, 'dtdr_virtual_tour', true);

		// Setting ids for location fields
		$dtdr_address_id = $dtdr_city_id = $dtdr_neighborhood_id = $dtdr_zip_id = $dtdr_countystate_id = $dtdr_country_id = $dtdr_latitude_id = $dtdr_longitude_id = '';
		if('true' ==  dtdr_option('map','enable-autocomplete-frontend-formsubmission')) {
				$dtdr_address_id = 'id="dtdr_address"';
				$dtdr_city_id = 'id="dtdr_city"';
				$dtdr_neighborhood_id = 'id="dtdr_neighborhood"';
				$dtdr_zip_id = 'id="dtdr_zip"';
				$dtdr_countystate_id = 'id="dtdr_countystate"';
				$dtdr_country_id = 'id="dtdr_country"';
		}

		$dtdr_latitude_id = 'id="dtdr_latitude"';
		$dtdr_longitude_id = 'id="dtdr_longitude"';

		wp_enqueue_script ( 'dtdr-map' );


		// Address and Location
		$output .= '<div class="dtdr-dashbord-section-holder">';

			$output .= '<div class="dtdr-dashbord-section-holder-intro">';
				$output .= '<div class="dtdr-dashbord-section-title">'.esc_html__('Location', 'dtdr').'</div>';
				$output .= '<div class="dtdr-dashbord-section-title-notes">'.sprintf( esc_html__('Add address and location for your %1$s.', 'dtdr'), strtolower($listing_singular_label) ).'</div>';
			$output .= '</div>';

			$output .= '<div class="dtdr-dashbord-section-holder-content">';

				$output .= '<div class="dtdr-column dtdr-one-column first">';
					$output .= '<div class="dtdr-dashboard-option-item">
					              	<label for="dtdr_description">'.esc_html__('Map Image', 'dtdr').'</label>
					               	<div class="dtdr-dashboard-option-item-data">
				   						'.dtdr_upload_promoflash_image($edit_item_id).'
				   					</div>
				   				</div>';
			   	$output .= '</div>';

				$output .= '<div class="dtdr-column dtdr-one-column first">';
					$output .= '<div class="dtdr-dashboard-option-item">
					                <label for="dtdr_address">'.esc_html__('Address', 'dtdr').'</label>
					               	<div class="dtdr-dashboard-option-item-data">';

					   					$output .= '<input type="text" value="'.esc_attr($dtdr_address).'" name="dtdr_address" '.$dtdr_address_id.' placeholder="'.esc_html__('Enter Address', 'dtdr').'" />

					            	</div>
					            </div>';
				$output .= '</div>';

				$output .= '<div class="dtdr-column dtdr-one-half first">';
					$output .= '<div class="dtdr-dashboard-option-item">
					               <label for="dtdr_city">'.esc_html__('City', 'dtdr').'</label>
					               <div class="dtdr-dashboard-option-item-data">';

						               if('true' ==  dtdr_option('map','enable-autocomplete-frontend-formsubmission')) {

						               		$dtdr_city = '';
										    if(isset($dtdr_listings_city_array[0])) {
										          $dtdr_city = $dtdr_listings_city_array[0]->name;
										    }

						               		$output .= '<input type="text" value="'.esc_attr($dtdr_city).'" name="dtdr_city" '.$dtdr_city_id.' placeholder="'.esc_html__('Enter City', 'dtdr').'" />';

						               } else {

						               		$dtdr_listings_city_terms = array ();
						               		if(is_array($dtdr_listings_city_array) && !empty($dtdr_listings_city_array)) {
							               		foreach($dtdr_listings_city_array as $dtdr_listing_city_array) {
							               			array_push($dtdr_listings_city_terms, $dtdr_listing_city_array->name);
							               		}
						               		}

						               		$dtdr_listings_city = get_categories('taxonomy=dtdr_listings_city&hide_empty=0');

					                        $output .= '<select name="dtdr_city[]" class="dtdr-chosen-select" data-placeholder="'.esc_html__('None', 'dtdr').'" multiple="multiple">';
						                        if(count($dtdr_listings_city) > 0) {
						                            foreach($dtdr_listings_city as $dtdr_listing_city) {
						                            	$selected_attribute = '';
								                    	if(in_array($dtdr_listing_city->name, $dtdr_listings_city_terms)) {
						                            		$selected_attribute = 'selected="selected"';
						                            	}
						                                $output .= '<option value="'.esc_attr($dtdr_listing_city->name).'" '.$selected_attribute.'>'.esc_html( $dtdr_listing_city->name).'</option>';
						                            }
						                        }
					                        $output .= '</select>';

						               }

						$output .= '</div>';
					$output .= '</div>';
				$output .= '</div>';

				$output .= '<div class="dtdr-column dtdr-one-half">';
					$output .= '<div class="dtdr-dashboard-option-item">
					               <label for="dtdr_neighborhood">'.esc_html__('Neighborhood', 'dtdr').'</label>
					               <div class="dtdr-dashboard-option-item-data">';

					               if('true' ==  dtdr_option('map','enable-autocomplete-frontend-formsubmission')) {

					               		$dtdr_neighborhood = '';
									    if(isset($dtdr_listings_neighborhood_array[0])) {
									          $dtdr_neighborhood = $dtdr_listings_neighborhood_array[0]->name;
									    }

					               		$output .= '<input type="text" value="'.esc_attr($dtdr_neighborhood).'" name="dtdr_neighborhood" '.$dtdr_neighborhood_id.' />';

					               } else {

					               		$dtdr_listings_neighborhood_terms = array ();
					               		if(is_array($dtdr_listings_neighborhood_array) && !empty($dtdr_listings_neighborhood_array)) {
						               		foreach($dtdr_listings_neighborhood_array as $dtdr_listing_neighbor_array) {
						               			array_push($dtdr_listings_neighborhood_terms, $dtdr_listing_neighbor_array->name);
						               		}
					               		}

					               		$dtdr_listings_neighborhood = get_categories('taxonomy=dtdr_listings_neighborhood&hide_empty=0');

				                        $output .= '<select name="dtdr_neighborhood[]" class="dtdr-chosen-select" data-placeholder="'.esc_html__('None', 'dtdr').'" multiple="multiple">';
					                        if(count($dtdr_listings_neighborhood) > 0) {
					                            foreach($dtdr_listings_neighborhood as $dtdr_listing_neighbor) {
					                            	$selected_attribute = '';
							                    	if(in_array($dtdr_listing_neighbor->name, $dtdr_listings_neighborhood_terms)) {
					                            		$selected_attribute = 'selected="selected"';
					                            	}
					                                $output .= '<option value="'.esc_attr($dtdr_listing_neighbor->name).'" '.$selected_attribute.'>'.esc_html( $dtdr_listing_neighbor->name).'</option>';
					                            }
					                        }
				                        $output .= '</select>';

					               }

					    $output .= '</div>';
					$output .= '</div>';
				$output .= '</div>';

				$output .= '<div class="dtdr-column dtdr-one-half first">';
					$output .= '<div class="dtdr-dashboard-option-item">
					               	<label for="dtdr_zip">'.esc_html__('Zip', 'dtdr').'</label>
					               	<div class="dtdr-dashboard-option-item-data">
					               		<input type="text" name="dtdr_zip" value="'.esc_attr($dtdr_zip).'" '.$dtdr_zip_id.' />
					               	</div>
					            </div>';
				$output .= '</div>';

				$output .= '<div class="dtdr-column dtdr-one-half">';
					$output .= '<div class="dtdr-dashboard-option-item">
					               <label for="dtdr_neighborhood">'.esc_html__('County / State', 'dtdr').'</label>
					               <div class="dtdr-dashboard-option-item-data">';

						               if('true' ==  dtdr_option('map','enable-autocomplete-frontend-formsubmission')) {

						               		$dtdr_countystate = '';
										    if(isset($dtdr_listings_countystate_array[0])) {
										          $dtdr_countystate = $dtdr_listings_countystate_array[0]->name;
										    }

						               		$output .= '<input type="text" value="'.esc_attr($dtdr_countystate).'" name="dtdr_countystate" '.$dtdr_countystate_id.' />';

						               } else {

						               		$dtdr_listings_countystate_terms = array ();
						               		if(is_array($dtdr_listings_countystate_array) && !empty($dtdr_listings_countystate_array)) {
							               		foreach($dtdr_listings_countystate_array as $dtdr_listing_countystate_array) {
							               			array_push($dtdr_listings_countystate_terms, $dtdr_listing_countystate_array->name);
							               		}
						               		}

						               		$dtdr_listings_countystate = get_categories('taxonomy=dtdr_listings_countystate&hide_empty=0');

					                        $output .= '<select name="dtdr_countystate[]" class="dtdr-chosen-select" data-placeholder="'.esc_html__('None', 'dtdr').'" multiple="multiple">';
						                        if(count($dtdr_listings_countystate) > 0) {
						                            foreach($dtdr_listings_countystate as $dtdr_listing_countystate) {
						                            	$selected_attribute = '';
								                    	if(in_array($dtdr_listing_countystate->name, $dtdr_listings_countystate_terms)) {
						                            		$selected_attribute = 'selected="selected"';
						                            	}
						                                $output .= '<option value="'.esc_attr($dtdr_listing_countystate->name).'" '.$selected_attribute.'>'.esc_html($dtdr_listing_countystate->name).'</option>';
						                            }
						                        }
					                        $output .= '</select>';

						               }

						$output .= '</div>';
					$output .= '</div>';
				$output .= '</div>';

				$output .= '<div class="dtdr-column dtdr-one-column first">';
					$output .= '<div class="dtdr-dashboard-option-item">
					                <label for="dtdr_country">'.esc_html__('Country', 'dtdr').'</label>
					                <div class="dtdr-dashboard-option-item-data">
						               <select name="dtdr_country" class="dtdr-chosen-select" '.$dtdr_country_id.'>';
		                                    $countries_list = dtdr_countries_list(true);
		                                    foreach( $countries_list as $key => $country ):
		                                        $output .= '<option value="'.$key.'" '.selected($dtdr_country, $key, false).'>'.$country.'</option>';
		                                    endforeach;
		                    $output .= '</select>
		                    		</div>
	                    </div>';
				$output .= '</div>';

				$output .= '<div class="dtdr-column dtdr-one-half first">';
					$output .= '<div class="dtdr-dashboard-option-item">
					               	<label for="dtdr_latitude">'.esc_html__('Latitude', 'dtdr').'</label>
					              	<div class="dtdr-dashboard-option-item-data">
					               		<input type="text" name="dtdr_latitude" value="'.esc_attr($dtdr_latitude).'" '.$dtdr_latitude_id.' />
					               	</div>
					            </div>';
				$output .= '</div>';

				$output .= '<div class="dtdr-column dtdr-one-half">';
					$output .= '<div class="dtdr-dashboard-option-item">
					               	<label for="dtdr_longitude">'.esc_html__('Longitude', 'dtdr').'</label>
					               	<div class="dtdr-dashboard-option-item-data">
					               		<input type="text" name="dtdr_longitude" value="'.esc_attr($dtdr_longitude).'" '.$dtdr_longitude_id.' />
					               	</div>
					            </div>';
				$output .= '</div>';

				$output .= '<div class="dtdr-column dtdr-one-column first">';
					$output .= '<div class="dtdr-dashboard-option-item">
									<div class="dtdr-dashboard-option-item-data">
					              		<div id="dtdr-addlist-map-holder"></div>
					              	</div>
					            </div>';
				$output .= '</div>';

				$output .= '<div class="dtdr-notes">'.esc_html__('You can also drag and place marker to identify your location.', 'dtdr').'</div>';

			$output .= '</div>';

		$output .= '</div>';

		// Virtual Tour
		$output .= '<div class="dtdr-dashbord-section-holder">';

			$output .= '<div class="dtdr-dashbord-section-holder-intro">';
				$output .= '<div class="dtdr-dashbord-section-title">'.esc_html__('Virtual Tour', 'dtdr').'</div>';
				$output .= '<div class="dtdr-dashbord-section-title-notes">'.sprintf( esc_html__('Add iframe code of your %1$s virtual tour.', 'dtdr'), strtolower($listing_singular_label) ).'</div>';
			$output .= '</div>';

			$output .= '<div class="dtdr-dashbord-section-holder-content">';
				$output .= '<div class="dtdr-dashboard-option-item">
				               	<label for="dtdr_virtual_tour">'.esc_html__('Virtual Tour Code', 'dtdr').'</label>
				               	<div class="dtdr-dashboard-option-item-data">
				               		<input type="text" value="'.esc_attr($dtdr_virtual_tour).'" name="dtdr_virtual_tour" />
				               	</div>
				            </div>';
			$output .= '</div>';

		$output .= '</div>';

	    return $output;

	}
	add_filter( 'dtdr_add_listing_fields_from_modules', 'dtdr_add_listing_fields_from_location_modules', 10, 2 );
}

?>