<?php

namespace DTElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

class DTDirectorySfOutputMapContainer extends Widget_Base {

	public function get_categories() {
		return [ 'dtdr-searchform-widgets' ];
	}

	public function get_name() {
		return 'dtdr-widget-sf-output-map-container';
	}

	public function get_title() {
		return esc_html__( 'Output Map Container', 'dtdr' );
	}

	public function get_style_depends() {
		return array ('swiper', 'dtdr-location-frontend');
	}

	public function get_script_depends() {
		return array ('swiper', 'dtdr-map', 'dtdr-frontend');
	}

	protected function register_controls(){

        $listing_singular_label = apply_filters( 'listing_label', 'singular' );

		$this->start_controls_section( 'output_map_container_default_section', array(
			'label' => esc_html__( 'General', 'dtdr' ),
		) );

            $this->add_control( 'type', array(
                'label'       => esc_html__( 'Type', 'dtdr' ),
                'type'        => Controls_Manager::SELECT,
                'options'     => array(
                    'type1' => esc_html__('Type 1', 'dtdr'),
                    'type2' => esc_html__('Type 2', 'dtdr'),
                    'type3' => esc_html__('Type 3', 'dtdr')
                ),
                'description' => esc_html__('Choose type of layout you like to display.', 'dtdr'),
                'default'      => 'type1',
            ) );

            $this->add_control( 'gallery', array(
                'label'       => esc_html__( 'Gallery', 'dtdr' ),
                'type'        => Controls_Manager::SELECT,
                'options'     => array(
                    'featured_image'        => esc_html__('Featured Image', 'dtdr'),
                    'image_gallery'         => esc_html__('Image Gallery', 'dtdr'),
                    'gallery_with_featured' => esc_html__('Image Gallery With Featured Image', 'dtdr'),
                ),
                'description' => esc_html__( 'Choose how you like to display image gallery.', 'dtdr' ),
                'default'      => 'featured_image',
            ) );

            $this->add_control( 'additional_info', array(
                'label'       => esc_html__( 'Additional Info', 'dtdr' ),
                'type'        => Controls_Manager::SELECT,
                'options'     => array(
                    ''               => esc_html__('None', 'dtdr'),
                    'totalviews'     => esc_html__('Total Views', 'dtdr'),
                    'averageratings' => esc_html__('Average Ratings', 'dtdr'),
                    'categoryimage'  => esc_html__('Category Image', 'dtdr'),
                    'categoryicon'   => esc_html__('Category Icon', 'dtdr'),
                    'distance'       => esc_html__('Distance', 'dtdr'),
                ),
                'description' => esc_html__( 'Choose additional info that you like to display along with location marker.', 'dtdr' ),
                'default'      => '',
            ) );

            $this->add_control( 'category_background_color', array(
                'label'       => esc_html__( 'Background Color', 'dtdr' ),
                'type'        => Controls_Manager::COLOR,
                'description' => esc_html__( 'Select background color for your icon. icon will be taken from the category settings.', 'dtdr' ),
                'condition'   => array( 'additional_info' => array ('categoryimage', 'categoryicon') )
            ) );

            $this->add_control( 'category_color', array(
                'label'       => esc_html__( 'Color', 'dtdr' ),
                'type'        => Controls_Manager::COLOR,
                'description' => esc_html__( 'Select background color for your icon. icon will be taken from the category settings.', 'dtdr' ),
                'condition'   => array( 'additional_info' => array ('categoryimage', 'categoryicon') )
            ) );

            $this->add_control( 'zoom_level', array(
                'label'   => esc_html__( 'Zoom Level', 'dtdr' ),
                'type'    => Controls_Manager::TEXT,
                'description' => esc_html__( 'Add map zoom level here. This will overwrite the default map zoom level. Ex: ... 9, 10, 11...', 'dtdr' ),
                'default' => ''
            ) );

            $this->add_control( 'map_type', array(
                'label'       => esc_html__( 'Map Type', 'dtdr' ),
                'type'        => Controls_Manager::SELECT,
                'options'     => array(
                    ''          => esc_html__('Default', 'dtdr'),
                    'SATELLITE' => esc_html__('SATELLITE', 'dtdr'),
                    'HYBRID'    => esc_html__('HYBRID', 'dtdr'),
                    'TERRAIN'   => esc_html__('TERRAIN', 'dtdr'),
                    'ROADMAP'   => esc_html__('ROADMAP', 'dtdr'),
                ),
                'description' => esc_html__( 'Choose map type for this item.', 'dtdr' ),
                'default'      => '',
            ) );

            $this->add_control( 'map_color', array(
                'label'       => esc_html__( 'Map Color', 'dtdr' ),
                'type'        => Controls_Manager::COLOR,
                'description' => esc_html__( 'Select color for your map. This will override the default map color.', 'dtdr' )
            ) );

            $this->add_responsive_control( 'height', array(
                'label' => esc_html__( 'Height', 'dtdr' ),
                'type' => Controls_Manager::TEXT,
                'description' => esc_html__( 'Provide height for your map in "px" here.', 'dtdr' ),
                'devices' => array( 'desktop', 'tablet', 'mobile' ),
                'selectors' => array(
					'{{WRAPPER}} .dtdr-listing-output-map' => 'height: {{SIZE}}px;',
				),
            ) );

			$this->add_control( 'class', array(
				'label'   => esc_html__( 'Class', 'dtdr' ),
				'type'    => Controls_Manager::TEXT,
				'description' => esc_html__( 'If you wish you can add additional class name here.', 'dtdr' ),
				'default' => ''
			) );

        $this->end_controls_section();

        $this->start_controls_section( 'output_map_container_filter_section', array(
			'label' => esc_html__( 'Filter Options', 'dtdr' ),
		) );

			$this->add_control( 'category_ids', array(
				'label'   => sprintf( esc_html__('%1$s Category Ids', 'dtdr'), $listing_singular_label ),
				'type'    => Controls_Manager::TEXT,
				'description' => sprintf( esc_html__( 'Enter %1$s category ids separated by commas.', 'dtdr' ), $listing_singular_label ),
				'default' => ''
			) );

        $this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings();
		$attributes = dtdirectory_elementor_instance()->dtdr_parse_shortcode_attrs( $settings );
		echo do_shortcode('[dtdr_sf_output_map_container '.$attributes.' /]');

	}

}