<?php

namespace DTElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

class DTDirectorySfRadius extends Widget_Base {

	public function get_categories() {
		return [ 'dtdr-searchform-widgets' ];
	}

	public function get_name() {
		return 'dtdr-widget-sf-radius';
	}

	public function get_title() {
		return esc_html__( 'Radius', 'dtdr' );
	}

	public function get_style_depends() {
		return array ( 'jquery-ui', 'dtdr-location-search' );
	}

	public function get_script_depends() {
		return array ( 'jquery-ui-slider', 'dtdr-map', 'dtdr-location-search' );
	}

	protected function register_controls(){

		$this->start_controls_section( 'radius_default_section', array(
			'label' => esc_html__( 'General', 'dtdr' ),
		) );

			$this->add_control( 'ajax_load', array(
				'label'       => esc_html__( 'Ajax Load', 'dtdr' ),
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					'false' => esc_html__('False', 'dtdr'),
					'true'  => esc_html__('True', 'dtdr'),
				),
				'description' => esc_html__('If you want to display the output in same page choose "True" here.', 'dtdr'),
				'default'      => 'false'
			) );

			$this->add_control( 'min_radius', array(
				'label'   => esc_html__( 'Minimum Radius', 'dtdr' ),
				'type'    => Controls_Manager::TEXT,
				'description' => esc_html__( 'Set minimum radius here.', 'dtdr' ),
				'default' => 1
			) );

			$this->add_control( 'max_radius', array(
				'label'   => esc_html__( 'Maximum Radius', 'dtdr' ),
				'type'    => Controls_Manager::TEXT,
				'description' => esc_html__( 'Set maximum radius here.', 'dtdr' ),
				'default' => 100
			) );

			$this->add_control( 'default_radius', array(
				'label'   => esc_html__( 'Default Radius', 'dtdr' ),
				'type'    => Controls_Manager::TEXT,
				'description' => esc_html__( 'Set default radius value to search.', 'dtdr' ),
				'default' => 20
			) );

			$this->add_control( 'radius_unit', array(
				'label'       => esc_html__( 'Radius Unit', 'dtdr' ),
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					'mi' => esc_html__( 'mi', 'dtdr' ),
					'km' => esc_html__( 'km', 'dtdr' ),
					'm'  => esc_html__( 'm', 'dtdr' ),
				),
				'description' => esc_html__('You can specify radius unit that you like to calculate distance.', 'dtdr'),
				'default'      => 'km'
			) );

			$this->add_control( 'class', array(
				'label'   => esc_html__( 'Class', 'dtdr' ),
				'type'    => Controls_Manager::TEXT,
				'description' => esc_html__( 'If you wish you can add additional class name here.', 'dtdr' ),
				'default' => ''
			) );

		$this->end_controls_section();
	}

	protected function render() {

		$settings = $this->get_settings();
		$attributes = dtdirectory_elementor_instance()->dtdr_parse_shortcode_attrs( $settings );
		echo do_shortcode('[dtdr_sf_radius_field '.$attributes.' /]');

	}

}