<?php
add_action( 'vc_before_init', 'dtdr_listings_map_vc_map' );

function dtdr_listings_map_vc_map() {

	$listing_singular_label = apply_filters( 'listing_label', 'singular' );
	$listing_plural_label = apply_filters( 'listing_label', 'plural' );
	$contracttype_plural_label = apply_filters( 'contracttype_label', 'plural' );
	$seller_singular_label = apply_filters( 'seller_label', 'singular' );
	$incharge_singular_label = apply_filters( 'incharge_label', 'singular' );

	$countries_list = dtdr_countries_list(false);
	$countries_list = array_flip($countries_list);

	$countries_list = array(esc_html__('All', 'dtdr') => '') + $countries_list;

	vc_map( array(
		"name" => sprintf( esc_html__('%1$s Map', 'dtdr'), $listing_plural_label ),
		"base" => "dtdr_listings_map",
		"icon" => "dtdr_listings_map",
		"category" => DTDR_PB_MODULE_DEFAULT_TITLE,
		"params" => array_merge (

						array(

							// Type
							array(
								'type' => 'dropdown',
								'heading' => esc_html__('Type','dtdr'),
								'param_name' => 'type',
								'value' => array(
									esc_html__( 'Type 1', 'dtdr' ) => 'type1',
									esc_html__( 'Type 2', 'dtdr' ) => 'type2',
									esc_html__( 'Type 3', 'dtdr' ) => 'type3'
								),
								'description' => esc_html__('Choose type of layout you like to display.', 'dtdr'),
								'edit_field_class' => 'vc_column vc_col-sm-6',
							),

							// Additional Info
							array (
								'type' => 'dropdown',
								'heading' => esc_html__('Additional Info','dtdr'),
								'param_name' => 'additional_info',
								'value' => array(
									esc_html__('None', 'dtdr') => '',
									esc_html__('Total Views', 'dtdr') => 'totalviews',
									esc_html__('Average Ratings', 'dtdr') => 'averageratings',
									esc_html__('Category Image', 'dtdr') => 'categoryimage',
									esc_html__('Category Icon', 'dtdr') => 'categoryicon'
								),
								'description' => esc_html__( 'Choose additional info that you like to display along with location marker.', 'dtdr' ),
								'std' => '',
								'edit_field_class' => 'vc_column vc_col-sm-6',
								'admin_label' => true
							),

							// Background Color
				      		array(
				      			'type' => 'colorpicker',
				      			'heading' => esc_html__( 'Background Color', 'dtdr' ),
				      			'param_name' => 'category_background_color',
								'dependency' => array( 'element' => 'additional_info', 'value' => array ('categoryimage', 'categoryicon') ),
				      			'description' => esc_html__( 'Select background color for your Category Icon. Icon will be taken from the category settings.', 'dtdr' ),
				      			'edit_field_class' => 'vc_column vc_col-sm-6',
				      		),

							// Color
				      		array(
				      			'type' => 'colorpicker',
				      			'heading' => esc_html__( 'Color', 'dtdr' ),
				      			'param_name' => 'category_color',
								'dependency' => array( 'element' => 'additional_info', 'value' => array ('categoryimage', 'categoryicon') ),
				      			'description' => esc_html__( 'Select icon color for your Category Image / Icon. Image / Icon will be taken from the category settings.', 'dtdr' ),
				      			'edit_field_class' => 'vc_column vc_col-sm-6',
				      		),

							// Zoom Level
							array(
								'type' => 'textfield',
								'heading' => esc_html__( 'Zoom Level', 'dtdr' ),
								'param_name' => 'zoom_level',
								'description' => esc_html__( 'Add map zoom level here. This will overwrite the default map zoom level. Ex: ... 9, 10, 11...', 'dtdr' ),
								'edit_field_class' => 'vc_column vc_col-sm-6',
							),

							// Map Type
							array (
								'type' => 'dropdown',
								'heading' => esc_html__('Map Type','dtdr'),
								'param_name' => 'map_type',
								'value' => array(
									esc_html__('Default', 'dtdr') => '',
									esc_html__('SATELLITE', 'dtdr') => 'SATELLITE',
									esc_html__('HYBRID', 'dtdr') => 'HYBRID',
									esc_html__('TERRAIN', 'dtdr') => 'TERRAIN',
									esc_html__('ROADMAP', 'dtdr') => 'ROADMAP',
								),
								'description' => esc_html__( 'Choose map type for this item.', 'dtdr' ),
								'edit_field_class' => 'vc_column vc_col-sm-6',
							),

							// Map Color
				      		array(
				      			'type' => 'colorpicker',
				      			'heading' => esc_html__( 'Map Color', 'dtdr' ),
				      			'param_name' => 'map_color',
				      			'description' => esc_html__( 'Select color for your map. This will override the default map color.', 'dtdr' ),
				      			'edit_field_class' => 'vc_column vc_col-sm-6',
				      		),

							// Height
							array (
								'type' => 'textfield',
								'heading' => esc_html__( 'Height', 'dtdr' ),
								'param_name' => 'vc_height',
								'description' => esc_html__( 'Provide height for your map in "px" here.', 'dtdr' ),
								'edit_field_class' => 'vc_column vc_col-sm-6'
							),

							// Class
							array (
								'type' => 'textfield',
								'heading' => esc_html__( 'Class', 'dtdr' ),
								'param_name' => 'class',
								'description' => esc_html__( 'If you wish you can add additional class name here.', 'dtdr' ),
							),


							// Filter Options

							// Listing Item Ids
							array(
								'type' => 'textfield',
								'heading' => sprintf( esc_html__('%1$s Item Ids', 'dtdr'), $listing_singular_label ),
								'param_name' => 'list_item_ids',
								'value' => '',
								'description' => sprintf( esc_html__( 'Enter %1$s item ids separated by commas.', 'dtdr' ), $listing_singular_label ),
								'edit_field_class' => 'vc_column vc_col-sm-6',
								'group' => 'Filters',
								'std' => ''
							),

							// Category Ids
							array(
								'type' => 'textfield',
								'heading' => sprintf( esc_html__('%1$s Category Ids', 'dtdr'), $listing_singular_label ),
								'param_name' => 'category_ids',
								'value' => '',
								'description' => esc_html__( 'Enter category ids separated by comma.', 'dtdr' ),
								'edit_field_class' => 'vc_column vc_col-sm-6',
								'group' => 'Filters',
								'std' => ''
							),

							// Cities Ids
							array(
								'type' => 'textfield',
								'heading' => sprintf( esc_html__('%1$s Cities Ids', 'dtdr'), $listing_singular_label ),
								'param_name' => 'cities_ids',
								'value' => '',
								'description' => esc_html__( 'Enter cities ids separated by comma.', 'dtdr' ),
								'edit_field_class' => 'vc_column vc_col-sm-6',
								'group' => 'Filters',
								'std' => ''
							),

							// Neighborhoods Ids
							array(
								'type' => 'textfield',
								'heading' => sprintf( esc_html__('%1$s Neighborhoods Ids', 'dtdr'), $listing_singular_label ),
								'param_name' => 'neighborhoods_ids',
								'value' => '',
								'description' => esc_html__( 'Enter neighborhoods ids separated by commas.', 'dtdr' ),
								'edit_field_class' => 'vc_column vc_col-sm-6',
								'group' => 'Filters',
								'std' => ''
							),

							// Counties / States Ids
							array(
								'type' => 'textfield',
								'heading' => sprintf( esc_html__('%1$s Counties / States Ids', 'dtdr'), $listing_singular_label ),
								'param_name' => 'countiesstates_ids',
								'value' => '',
								'description' => esc_html__( 'Enter countiesstates ids separated by commas.', 'dtdr' ),
								'edit_field_class' => 'vc_column vc_col-sm-6',
								'group' => 'Filters',
								'std' => ''
							),

							// Contract Types Ids
							array(
								'type' => 'textfield',
								'heading' => sprintf( esc_html__('%1$s %2$s', 'dtdr'), $listing_singular_label, $contracttype_plural_label ),
								'param_name' => 'contracttypes_ids',
								'value' => '',
								'description' => esc_html__( 'Enter contract types ids separated by commas.', 'dtdr' ),
								'edit_field_class' => 'vc_column vc_col-sm-6',
								'group' => 'Filters',
								'std' => ''
							),

							// Tag Ids
							array(
								'type' => 'textfield',
								'heading' => sprintf( esc_html__('%1$s Tag Ids', 'dtdr'), $listing_singular_label ),
								'param_name' => 'tag_ids',
								'value' => '',
								'description' => esc_html__( 'Enter tag ids separated by comma.', 'dtdr' ),
								'edit_field_class' => 'vc_column vc_col-sm-6',
								'group' => 'Filters',
								'std' => ''
							),

							// Countries
							array(
								'type' => 'dropdown',
								'heading' => esc_html__('Countries','dtdr'),
								'param_name' => 'country_id',
								'value' => $countries_list,
								'description' => esc_html__( 'Choose countries for which you like to display items.', 'dtdr' ),
								'edit_field_class' => 'vc_column vc_col-sm-6',
								'group' => 'Filters',
								'std' => ''
							),

							// Seller Ids
							array(
								'type' => 'textfield',
								'heading' => sprintf( esc_html__('%1$s %2$s Ids', 'dtdr'), $listing_singular_label, $seller_singular_label ),
								'param_name' => 'seller_ids',
								'value' => '',
								'description' => sprintf( esc_html__('Enter %1$s ids separated by commas.', 'dtdr'), strtolower($seller_singular_label) ),
								'edit_field_class' => 'vc_column vc_col-sm-6',
								'group' => 'Filters',
								'std' => ''
							),

							// Incharge Ids
							array(
								'type' => 'textfield',
								'heading' => sprintf( esc_html__('%1$s %2$s Ids', 'dtdr'), $listing_singular_label, $incharge_singular_label ),
								'param_name' => 'incharge_ids',
								'value' => '',
								'description' => esc_html__( 'Enter incharge ids separated by commas.', 'dtdr' ),
								'edit_field_class' => 'vc_column vc_col-sm-6',
								'group' => 'Filters',
								'std' => ''
							),

						)

					)


	) );
}
?>