<?php
add_action( 'vc_before_init', 'dtdr_sf_nearby_field_vc_map' );

function dtdr_sf_nearby_field_vc_map() {

	$listing_singular_label = apply_filters( 'listing_label', 'singular' );

	vc_map( array(
		"name" => esc_html__( 'Near By', 'dtdr' ),
		"base" => "dtdr_sf_nearby_field",
		"icon" => "dtdr_sf_nearby_field",
		"category" => DTDR_PB_MODULE_SEARCHFORM_TITLE,
		"params" => array(

			// Ajax Load
			array(
				'type' => 'dropdown',
				'heading' => esc_html__('Ajax Load', 'dtdr'),
				'description' => esc_html__('If you want to display the output in same page choose "True" here.', 'dtdr'),
				'param_name' => 'ajax_load',
				'value' => array(
					esc_html__( 'False', 'dtdr' ) => 'false',
					esc_html__( 'True', 'dtdr' ) => 'true',
				),
			),

			// Maximum Radius
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Maximum Radius', 'dtdr' ),
				'param_name' => 'max_radius',
				'description' => esc_html__( 'Set maximum radius to search for.', 'dtdr' ),
				'value' => 100,
				'edit_field_class' => 'vc_column vc_col-sm-6'
			),

			// Radius Unit
			array(
				'type' => 'dropdown',
				'heading' => esc_html__('Radius Unit', 'dtdr'),
				'description' => esc_html__('You can specify radius unit that you like to calculate distance.', 'dtdr'),
				'param_name' => 'radius_unit',
				'value' => array(
					esc_html__( 'mi', 'dtdr' ) => 'mi',
					esc_html__( 'km', 'dtdr' ) => 'km',
					esc_html__( 'm', 'dtdr' ) => 'm',
				),
				'std' => 'km',
				'edit_field_class' => 'vc_column vc_col-sm-6'
			),

			// Class
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Class', 'dtdr' ),
				'param_name' => 'class',
				'description' => esc_html__( 'If you wish you can add additional class name here.', 'dtdr' ),
			),

		)
	) );
}
?>