<?php
add_action( 'vc_before_init', 'dtdr_sf_radius_field_vc_map' );

function dtdr_sf_radius_field_vc_map() {

	vc_map( array(
		"name" => esc_html__( 'Radius', 'dtdr' ),
		"base" => "dtdr_sf_radius_field",
		"icon" => "dtdr_sf_radius_field",
		"category" => DTDR_PB_MODULE_SEARCHFORM_TITLE,
		"params" => array(

			// Ajax Load
			array(
				'type' => 'dropdown',
				'heading' => esc_html__('Ajax Load', 'dtdr'),
				'description' => esc_html__('If you want to display the output in same page choose "True" here.', 'dtdr'),
				'param_name' => 'ajax_load',
				'value' => array(
					esc_html__( 'False', 'dtdr' ) => 'false',
					esc_html__( 'True', 'dtdr' ) => 'true',
				),
				'edit_field_class' => 'vc_column vc_col-sm-6'
			),

			// Minimum Radius
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Minimum Radius', 'dtdr' ),
				'param_name' => 'min_radius',
				'description' => esc_html__( 'Set minimum radius here.', 'dtdr' ),
				'value' => 1,
				'edit_field_class' => 'vc_column vc_col-sm-6'
			),

			// Maximum Radius
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Maximum Radius', 'dtdr' ),
				'param_name' => 'max_radius',
				'description' => esc_html__( 'Set maximum radius here.', 'dtdr' ),
				'value' => 100,
				'edit_field_class' => 'vc_column vc_col-sm-6'
			),

			// Default Radius
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Default Radius', 'dtdr' ),
				'param_name' => 'default_radius',
				'description' => esc_html__( 'Set default radius value to search.', 'dtdr' ),
				'value' => 20,
				'edit_field_class' => 'vc_column vc_col-sm-6'
			),

			// Radius Unit
			array(
				'type' => 'dropdown',
				'heading' => esc_html__('Radius Unit', 'dtdr'),
				'description' => esc_html__('You can specify radius unit that you like to calculate distance.', 'dtdr'),
				'param_name' => 'radius_unit',
				'value' => array(
					esc_html__( 'mi', 'dtdr' ) => 'mi',
					esc_html__( 'km', 'dtdr' ) => 'km',
					esc_html__( 'm', 'dtdr' ) => 'm',
				),
				'std' => 'km',
				'edit_field_class' => 'vc_column vc_col-sm-6'
			),

			// Class
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Class', 'dtdr' ),
				'param_name' => 'class',
				'description' => esc_html__( 'If you wish you can add additional class name here.', 'dtdr' ),
				'edit_field_class' => 'vc_column vc_col-sm-6'
			)

		)
	) );
}
?>