<?php

if (!class_exists ( 'DTDirectoryRegisterLocationModule' )) {

	class DTDirectoryRegisterLocationModule extends DTDirectoryAddon {

		/**
		 * Instance variable
		 */
		private static $_instance = null;

		/**
		 * Instance
		 *
		 * Ensures only one instance of the class is loaded or can be loaded.
		 */
		public static function instance() {

			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}

			return self::$_instance;
		}

		function __construct() {

			$this->dtdr_define_constants( 'DTDR_LOCATION_PLUGIN_PATH', DTDR_PLUGIN_PATH . 'modules/location/' );
			$this->dtdr_define_constants( 'DTDR_LOCATION_PLUGIN_URL', DTDR_PLUGIN_URL . 'modules/location/' );

			add_filter ( 'dtdr_metabox_tabs', array ( $this, 'dtdr_metabox_tabs_tab' ) );
			add_filter ( 'dtdr_settings', array ( $this, 'dtdr_add_settings' ) );

			add_action ( 'admin_enqueue_scripts', array ( $this, 'dtdr_admin_enqueue_scripts' ), 120 );
			add_action ( 'wp_enqueue_scripts', array ( $this, 'dtdr_enqueue_scripts' ), 130 );

			add_action ( 'dtdr_addorupdate_listing_module', array ( $this, 'dtdr_addorupdate_listing_location_module' ), 10, 2 );

			require_once DTDR_LOCATION_PLUGIN_PATH . 'taxonomies.php';
			require_once DTDR_LOCATION_PLUGIN_PATH . 'shortcodes.php';
			require_once DTDR_LOCATION_PLUGIN_PATH . 'dashboard.php';
			require_once DTDR_LOCATION_PLUGIN_PATH . 'utils.php';

		}

		function dtdr_metabox_tabs_tab($tabs) {

			$tabs['location'] = array (
				'label' => esc_html__('Location', 'dtdr'),
				'icon' => 'fas fa-map',
				'path' => DTDR_LOCATION_PLUGIN_PATH . 'metabox-tab-location.php'
			);
			$tabs['virtual-tour'] = array (
				'label' => esc_html__('Virtual Tour', 'dtdr'),
				'icon' => 'fas fa-eye',
				'path' => DTDR_LOCATION_PLUGIN_PATH . 'metabox-tab-virtual-tour.php'
			);

			return $tabs;

		}

		function dtdr_add_settings($tabs) {

			$tabs['location-map'] = array (
				'label' => esc_html__('Location / Map', 'dtdr'),
				'path' => DTDR_LOCATION_PLUGIN_PATH . 'settings.php'
			);

			return $tabs;

		}

		function dtdr_admin_enqueue_scripts() {

			$this->dtdr_register_dependent_files();
			$this->dtdr_localize_registered_dependent_files();

			$current_screen = get_current_screen();
			if($current_screen->id == 'dtdr_listings') {

				wp_enqueue_script ( 'dtdr-admin-map' );

			}

			// For Taxonomies

			if(in_array($current_screen->id, array ('edit-dtdr_listings_city', 'edit-dtdr_listings_neighborhood', 'edit-dtdr_listings_countystate'))) {

				// CSS

				wp_enqueue_style ( 'wp-color-picker' );
				wp_enqueue_style ( 'dtdr-fields' );

				wp_enqueue_style ( 'dtdr-backend' );
				wp_enqueue_style ( 'dtdr-common' );


				// JS

				wp_enqueue_script ( 'wp-color-picker' );
				wp_enqueue_script ( 'wp-color-picker-alpha' );
				wp_enqueue_script ( 'dtdr-fields' );

				wp_enqueue_script ( 'dtdr-common' );
				wp_enqueue_script ( 'dtdr-backend' );


			}

		}

		function dtdr_enqueue_scripts() {

			$this->dtdr_register_dependent_files();
			$this->dtdr_localize_registered_dependent_files();
			$this->dtdr_enqueue_registered_files();

			if(is_page_template('tpl-dashboard.php')) {
				wp_enqueue_media();
				wp_enqueue_script ( 'dtdr-map' );
			}

		}

		function dtdr_register_dependent_files() {

			// CSS

			wp_register_style ( 'dtdr-location-frontend', DTDR_LOCATION_PLUGIN_URL . 'assets/location-frontend.css', array ( 'fontawesome', 'material-icon', 'dtdr-base', 'dtdr-common' ) );

			wp_register_style ( 'dtdr-location-search', DTDR_LOCATION_PLUGIN_URL . 'assets/location-search.css', array ( 'dtdr-search-frontend' ) );


			// JS

			$googlemap_api_key = dtdr_option('map', 'googlemap-api-key');
			$enable_ssl = (dtdr_option('map', 'enable-ssl') == 'true') ? true : false;

			$googlemap_url = ( $enable_ssl ) ? 'https://maps-api-ssl.google.com/maps/api/js': 'http://maps.googleapis.com/maps/api/js';
			$googlemap_url = add_query_arg( array( 'key' => $googlemap_api_key , 'libraries' => 'places' ) , $googlemap_url );

			wp_register_script ( 'dtdr-google-map', $googlemap_url, array( 'jquery' ), false, true );

			wp_register_script ( 'dtdr-map-cluster', DTDR_LOCATION_PLUGIN_URL . 'assets/markerclusterer.min.js', array( 'jquery' ), false, true );
			wp_register_script ( 'dtdr-map-info', DTDR_LOCATION_PLUGIN_URL . 'assets/infobox.min.js', array( 'jquery' ), false, true );
			wp_register_script ( 'dtdr-map-overlay', DTDR_LOCATION_PLUGIN_URL . 'assets/map-overlay.js', array( 'jquery' ), false, true );

			wp_register_script ( 'dtdr-map', DTDR_LOCATION_PLUGIN_URL . 'assets/map.js', array( 'jquery', 'dtdr-google-map', 'dtdr-map-cluster', 'dtdr-map-info', 'dtdr-map-overlay' ), false, true );

			wp_register_script ( 'dtdr-admin-map', DTDR_LOCATION_PLUGIN_URL . 'assets/map.js', array( 'jquery', 'dtdr-google-map' ), false, true );

			wp_register_script ( 'dtdr-location-search', DTDR_LOCATION_PLUGIN_URL . 'assets/search.js', array ('jquery', 'dtdr-search-frontend'), false, true );
			wp_register_script ( 'dtdr-location-frontend', DTDR_LOCATION_PLUGIN_URL . 'assets/frontend.js', array ('jquery', 'dtdr-frontend'), false, true );

			wp_enqueue_script ( 'dtdr-google-map', $googlemap_url, array('jquery'), false, true );

		}

		function dtdr_localize_registered_dependent_files() {

			$default_latitude          = dtdr_option('map', 'default-latitude');
			$default_longitude         = dtdr_option('map', 'default-longitude');
			$default_zoom_level        = dtdr_option('map', 'default-zoom-level');
			$default_map_type          = dtdr_option('map', 'default-map-type');
			$default_map_color         = dtdr_option('map', 'default-map-color');

			$enable_maptype_control    = dtdr_option('map', 'enable-maptype-control');
			$enable_zoom_control       = dtdr_option('map', 'enable-zoom-control');
			$enable_scale_control      = dtdr_option('map', 'enable-scale-control');
			$enable_streetview_control = dtdr_option('map', 'enable-streetview-control');
			$enable_fullscreen_control = dtdr_option('map', 'enable-fullscreen-control');

			wp_localize_script ( 'dtdr-google-map', 'dtdrmapobject', array (
				'defaultLatitude'         => $default_latitude,
				'defaultLongitude'        => $default_longitude,
				'defaultZoomLevel'        => $default_zoom_level,
				'defaultMapType'          => $default_map_type,
				'defaultMapColor'         => $default_map_color,
				'enableMapTypeControl'    => $enable_maptype_control,
				'enableZoomControl'       => $enable_zoom_control,
				'enableScaleControl'      => $enable_scale_control,
				'enableStreetViewControl' => $enable_streetview_control,
				'enableFullscreenControl' => $enable_fullscreen_control
			));

		}

		function dtdr_enqueue_registered_files() {

			wp_enqueue_style ( 'chosen' );
			wp_enqueue_style ( 'jquery-ui' );
			wp_enqueue_style ( 'dtdr-location-frontend' );
			wp_enqueue_style ( 'dtdr-location-search' );

			wp_enqueue_script ( 'chosen' );
			wp_enqueue_script ( 'jquery-ui-slider' );
			wp_enqueue_script ( 'dtdr-map' );
			wp_enqueue_script ( 'dtdr-location-search' );
			wp_enqueue_script ( 'dtdr-location-frontend' );

		}

		function dtdr_addorupdate_listing_location_module($data, $listing_id) {

			extract($data);

			// Location

			if( isset( $dtdr_map_image ) && $dtdr_map_image != '') {
				update_post_meta ( $listing_id, 'dtdr_map_image', $dtdr_map_image );
			} else {
				delete_post_meta ( $listing_id, 'dtdr_map_image' );
			}

			if( isset( $dtdr_address ) && $dtdr_address != '') {
				update_post_meta ( $listing_id, 'dtdr_address', $dtdr_address );
			} else {
				delete_post_meta ( $listing_id, 'dtdr_address' );
			}

			if( isset( $dtdr_zip ) && $dtdr_zip != '') {
				update_post_meta ( $listing_id, 'dtdr_zip', $dtdr_zip );
			} else {
				delete_post_meta ( $listing_id, 'dtdr_zip' );
			}

			if( isset( $dtdr_country ) && $dtdr_country != '') {
				update_post_meta ( $listing_id, 'dtdr_country', $dtdr_country );
			} else {
				delete_post_meta ( $listing_id, 'dtdr_country' );
			}

			if( isset( $dtdr_latitude ) && $dtdr_latitude != '') {
				update_post_meta ( $listing_id, 'dtdr_latitude', $dtdr_latitude );
			} else {
				delete_post_meta ( $listing_id, 'dtdr_latitude' );
			}

			if( isset( $dtdr_longitude ) && $dtdr_longitude != '') {
				update_post_meta ( $listing_id, 'dtdr_longitude', $dtdr_longitude );
			} else {
				delete_post_meta ( $listing_id, 'dtdr_longitude' );
			}


			// Virtual Tour

			if( isset( $dtdr_virtual_tour ) && $dtdr_virtual_tour != '') {
				update_post_meta ( $listing_id, 'dtdr_virtual_tour', $dtdr_virtual_tour );
			} else {
				delete_post_meta ( $listing_id, 'dtdr_virtual_tour' );
			}


			// Taxonomies

			if( is_array( $dtdr_city ) && !empty($dtdr_city) ) {
				wp_set_object_terms($listing_id, $dtdr_city, 'dtdr_listings_city');
			}

			if( is_array( $dtdr_neighborhood ) && !empty($dtdr_neighborhood) ) {
				wp_set_object_terms($listing_id, $dtdr_neighborhood, 'dtdr_listings_neighborhood');
			}

			if( is_array( $dtdr_countystate ) && !empty($dtdr_countystate) ) {
				wp_set_object_terms($listing_id, $dtdr_countystate, 'dtdr_listings_countystate');
			}

		}

	}

}

if( !function_exists('dtdrLocationModule') ) {
	function dtdrLocationModule() {
		return DTDirectoryRegisterLocationModule::instance();
	}
}

dtdrLocationModule();

?>