<?php

// Update Directory Menu
if(!function_exists('dtdr_configure_admin_menu_from_location_module')) {
    function dtdr_configure_admin_menu_from_location_module() {

        $listing_singular_label = apply_filters( 'listing_label', 'singular' );

        $city_title = sprintf( esc_html__('%1$s City', 'dtdr'), $listing_singular_label );
        $neighborhood_title = sprintf( esc_html__('%1$s Neighborhood', 'dtdr'), $listing_singular_label );
        $countystate_title = sprintf( esc_html__('%1$s County / State', 'dtdr'), $listing_singular_label );

        add_submenu_page( 'dtdr', $city_title, $city_title, 'edit_posts', 'edit-tags.php?taxonomy=dtdr_listings_city&post_type=dtdr_listings' );
        add_submenu_page( 'dtdr', $neighborhood_title, $neighborhood_title, 'edit_posts', 'edit-tags.php?taxonomy=dtdr_listings_neighborhood&post_type=dtdr_listings' );
        add_submenu_page( 'dtdr', $countystate_title, $countystate_title, 'edit_posts', 'edit-tags.php?taxonomy=dtdr_listings_countystate&post_type=dtdr_listings' );

    }
    add_action ( 'admin_menu', 'dtdr_configure_admin_menu_from_location_module', 20 );
}

// Update active menu
if(!function_exists('dtdr_change_active_menu_from_location_module')) {
    function dtdr_change_active_menu_from_location_module($parent_file) {

        global $submenu_file, $current_screen;
        $taxonomy = $current_screen->taxonomy;

        if ($taxonomy == 'dtdr_listings_city') {
            $submenu_file = 'edit-tags.php?taxonomy=dtdr_listings_city&post_type=dtdr_listings';
            $parent_file = 'dtdr';
        } else if ($taxonomy == 'dtdr_listings_neighborhood') {
            $submenu_file = 'edit-tags.php?taxonomy=dtdr_listings_neighborhood&post_type=dtdr_listings';
            $parent_file = 'dtdr';
        } else if ($taxonomy == 'dtdr_listings_countystate') {
            $submenu_file = 'edit-tags.php?taxonomy=dtdr_listings_countystate&post_type=dtdr_listings';
            $parent_file = 'dtdr';
        }

        return $parent_file;

    }
    add_action ( 'parent_file', 'dtdr_change_active_menu_from_location_module' );
}


// Create Taxonomies
if(!function_exists('dtdr_init_taxonomies_from_location_module')) {
    function dtdr_init_taxonomies_from_location_module() {

        $listing_singular_label = apply_filters( 'listing_label', 'singular' );

        $listing_city_slug = trim(dtdr_option('map','listing-city-slug'));
        $listing_neighborhood_slug = trim(dtdr_option('map','listing-neighborhood-slug'));
        $listing_countystate_slug = trim(dtdr_option('map','listing-countystate-slug'));


        register_taxonomy ( 'dtdr_listings_city', array (
                    'dtdr_listings'
            ), array (
                    'hierarchical' => true,
                    'labels' => array(
                        'name' 					=> sprintf( esc_html__('%1$s Cities', 'dtdr'), $listing_singular_label ),
                        'singular_name' 		=> sprintf( esc_html__('%1$s City', 'dtdr'), $listing_singular_label ),
                        'search_items'			=> sprintf( esc_html__('Search %1$s Cities', 'dtdr'), $listing_singular_label ),
                        'popular_items'			=> sprintf( esc_html__('Popular %1$s Cities', 'dtdr'), $listing_singular_label ),
                        'all_items'				=> sprintf( esc_html__('All %1$s Cities', 'dtdr'), $listing_singular_label ),
                        'parent_item'			=> sprintf( esc_html__('Parent %1$s City', 'dtdr'), $listing_singular_label ),
                        'parent_item_colon'		=> sprintf( esc_html__('Parent %1$s City', 'dtdr'), $listing_singular_label ),
                        'edit_item'				=> sprintf( esc_html__('Edit %1$s City', 'dtdr'), $listing_singular_label ),
                        'update_item'			=> sprintf( esc_html__('Update %1$s City', 'dtdr'), $listing_singular_label ),
                        'add_new_item'			=> sprintf( esc_html__('Add New %1$s City', 'dtdr'), $listing_singular_label ),
                        'new_item_name'			=> sprintf( esc_html__('New %1$s City', 'dtdr'), $listing_singular_label ),
                        'add_or_remove_items'	=> sprintf( esc_html__('Add or remove', 'dtdr'), $listing_singular_label ),
                        'choose_from_most_used'	=> sprintf( esc_html__('Choose from most used', 'dtdr'), $listing_singular_label ),
                        'menu_name'				=> sprintf( esc_html__('%1$s Cities', 'dtdr'), $listing_singular_label ),
                    ),
                    'show_admin_column' => true,
                    'rewrite' => array( 'slug' => $listing_city_slug, 'hierarchical' => true, 'with_front' => false ),
                    'query_var' => true
            )
        );

        register_taxonomy ( 'dtdr_listings_neighborhood', array (
                    'dtdr_listings'
            ), array (
                    'hierarchical' => true,
                    'labels' => array(
                        'name' 					=> sprintf( esc_html__('%1$s Neighborhoods', 'dtdr'), $listing_singular_label ),
                        'singular_name' 		=> sprintf( esc_html__('%1$s Neighborhood', 'dtdr'), $listing_singular_label ),
                        'search_items'			=> sprintf( esc_html__('Search %1$s Neighborhoods', 'dtdr'), $listing_singular_label ),
                        'popular_items'			=> sprintf( esc_html__('Popular %1$s Neighborhoods', 'dtdr'), $listing_singular_label ),
                        'all_items'				=> sprintf( esc_html__('All %1$s Neighborhoods', 'dtdr'), $listing_singular_label ),
                        'parent_item'			=> sprintf( esc_html__('Parent %1$s Neighborhood', 'dtdr'), $listing_singular_label ),
                        'parent_item_colon'		=> sprintf( esc_html__('Parent %1$s Neighborhood', 'dtdr'), $listing_singular_label ),
                        'edit_item'				=> sprintf( esc_html__('Edit %1$s Neighborhood', 'dtdr'), $listing_singular_label ),
                        'update_item'			=> sprintf( esc_html__('Update %1$s Neighborhood', 'dtdr'), $listing_singular_label ),
                        'add_new_item'			=> sprintf( esc_html__('Add New %1$s Neighborhood', 'dtdr'), $listing_singular_label ),
                        'new_item_name'			=> sprintf( esc_html__('New %1$s Neighborhood', 'dtdr'), $listing_singular_label ),
                        'add_or_remove_items'	=> sprintf( esc_html__('Add or remove', 'dtdr'), $listing_singular_label ),
                        'choose_from_most_used'	=> sprintf( esc_html__('Choose from most used', 'dtdr'), $listing_singular_label ),
                        'menu_name'				=> sprintf( esc_html__('%1$s Neighborhoods', 'dtdr'), $listing_singular_label ),
                    ),
                    'show_admin_column' => true,
                    'rewrite' => array( 'slug' => $listing_neighborhood_slug, 'hierarchical' => true, 'with_front' => false ),
                    'query_var' => true
            )
        );

        register_taxonomy ( 'dtdr_listings_countystate', array (
                    'dtdr_listings'
            ), array (
                    'hierarchical' => true,
                    'labels' => array(
                        'name' 					=> sprintf( esc_html__('%1$s Counties / States', 'dtdr'), $listing_singular_label ),
                        'singular_name' 		=> sprintf( esc_html__('%1$s County / State', 'dtdr'), $listing_singular_label ),
                        'search_items'			=> sprintf( esc_html__('Search %1$s Counties /  States', 'dtdr'), $listing_singular_label ),
                        'popular_items'			=> sprintf( esc_html__('Popular %1$s Counties /  States', 'dtdr'), $listing_singular_label ),
                        'all_items'				=> sprintf( esc_html__('All %1$s Counties /  States', 'dtdr'), $listing_singular_label ),
                        'parent_item'			=> sprintf( esc_html__('Parent %1$s County / State', 'dtdr'), $listing_singular_label ),
                        'parent_item_colon'		=> sprintf( esc_html__('Parent %1$s County / State', 'dtdr'), $listing_singular_label ),
                        'edit_item'				=> sprintf( esc_html__('Edit %1$s County / State', 'dtdr'), $listing_singular_label ),
                        'update_item'			=> sprintf( esc_html__('Update %1$s County / State', 'dtdr'), $listing_singular_label ),
                        'add_new_item'			=> sprintf( esc_html__('Add New %1$s County / State', 'dtdr'), $listing_singular_label ),
                        'new_item_name'			=> sprintf( esc_html__('New %1$s County / State', 'dtdr'), $listing_singular_label ),
                        'add_or_remove_items'	=> sprintf( esc_html__('Add or remove', 'dtdr'), $listing_singular_label ),
                        'choose_from_most_used'	=> sprintf( esc_html__('Choose from most used', 'dtdr'), $listing_singular_label ),
                        'menu_name'				=> sprintf( esc_html__('%1$s Counties /  States', 'dtdr'), $listing_singular_label ),
                    ),
                    'show_admin_column' => true,
                    'rewrite' => array( 'slug' => $listing_countystate_slug, 'hierarchical' => true, 'with_front' => false ),
                    'query_var' => true
            )
        );


        /* Taxomony custom fields */
        require_once DTDR_LOCATION_PLUGIN_PATH . 'taxonomy-custom-fields.php';

    }
    add_action ( 'init', 'dtdr_init_taxonomies_from_location_module' );
}

// Include Templates
if(!function_exists('dtdr_template_include_from_location_module')) {
    function dtdr_template_include_from_location_module($template) {

        if (is_tax ( 'dtdr_listings_city' )) {
            $template = DTDR_LOCATION_PLUGIN_PATH . 'templates/taxonomy-dtdr_listings_city.php';
        } elseif (is_tax ( 'dtdr_listings_neighborhood' )) {
            $template = DTDR_LOCATION_PLUGIN_PATH . 'templates/taxonomy-dtdr_listings_neighborhood.php';
        } elseif (is_tax ( 'dtdr_listings_countystate' )) {
            $template = DTDR_LOCATION_PLUGIN_PATH . 'templates/taxonomy-dtdr_listings_countystate.php';
        }

        return $template;

    }
    add_filter ( 'template_include', 'dtdr_template_include_from_location_module' );
}

// Update taxonomy array for custom options
if(!function_exists('dtdr_update_taxonomies_from_location_module')) {
    function dtdr_update_taxonomies_from_location_module($taxonomies) {

        $taxonomies['dtdr_listings_city']         = esc_html__('City', 'dtdr');
        $taxonomies['dtdr_listings_neighborhood'] = esc_html__('Neighborhood', 'dtdr');
        $taxonomies['dtdr_listings_countystate']  = esc_html__('County / State', 'dtdr');

        return $taxonomies;

    }
    add_filter ( 'dtdr_taxonomies', 'dtdr_update_taxonomies_from_location_module', 20, 1 );
}

?>