<?php

if( !class_exists('DTDirectoryLocationTaxonomyCustomFields') ) {

	class DTDirectoryLocationTaxonomyCustomFields {

		/**
		 * Instance variable
		 */
		private static $_instance = null;

		/**
		 * Instance
		 *
		 * Ensures only one instance of the class is loaded or can be loaded.
		 */
		public static function instance() {

			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}

			return self::$_instance;
		}

		function __construct() {

			$taxonomies = apply_filters( 'dtdr_taxonomies', array () );

			foreach($taxonomies as $taxonomy => $taxonomy_label) {
				add_action ( $taxonomy.'_add_form_fields', array ( $this, 'dtdr_add_taxonomy_form_fields' ), 10, 2 );
				add_action ( 'created_'.$taxonomy, array ( $this, 'dtdr_save_taxonomy_form_fields' ), 10, 2 );
				add_action ( $taxonomy.'_edit_form_fields', array ( $this, 'dtdr_update_taxonomy_form_fields' ), 10, 2 );
				add_action ( 'edited_'.$taxonomy, array ( $this, 'dtdr_updated_taxonomy_form_fields' ), 10, 2 );
			}

		}

		function dtdr_add_taxonomy_form_fields ( $taxonomy ) {

			echo '<div class="form-field term-group">
					<label for="taxonomy-map-image">'.esc_html__('Map Image', 'dtdr').'</label>
					<div class="dtdr-upload-media-items-container">
						<input name="dtdr-taxonomy-map-image-url" type="hidden" class="uploadfieldurl" readonly value=""/>
						<input name="dtdr-taxonomy-map-image-id" type="hidden" class="uploadfieldid" readonly value=""/>
						<input type="button" value="'.esc_html__( 'Add Image', 'dtdr' ).'" class="dtdr-upload-media-item-button show-preview with-image-holder" />
						'.dtdr_adminpanel_image_preview('').'
					</div>
					<p>'.esc_html__('This image will be used in Maps.', 'dtdr').'</p>
				</div>';

		}

		function dtdr_save_taxonomy_form_fields ( $term_id, $tt_id ) {

			if( isset( $_POST['dtdr-taxonomy-map-image-url'] ) ){
				$image_url = dtdr_recursive_sanitize_text_field ($_POST['dtdr-taxonomy-map-image-url']);
				add_term_meta( $term_id, 'dtdr-taxonomy-map-image-url', $image_url, true );
			}

			if( isset( $_POST['dtdr-taxonomy-map-image-id'] ) ){
				$image_id = dtdr_recursive_sanitize_text_field ($_POST['dtdr-taxonomy-map-image-id']);
				add_term_meta( $term_id, 'dtdr-taxonomy-map-image-id', $image_url, true );
			}

		}

		function dtdr_update_taxonomy_form_fields ( $term, $taxonomy ) {

			echo '<tr class="form-field term-group-wrap">
					<th scope="row">
						<label for="taxonomy-map-image">'.esc_html__('Map Image', 'dtdr').'</label>
					</th>
					<td>';
						$image_url = get_term_meta( $term->term_id, 'dtdr-taxonomy-map-image-url', true );
						$image_id = get_term_meta( $term->term_id, 'dtdr-taxonomy-map-image-id', true );
					echo '<div class="dtdr-upload-media-items-container">
							<input name="dtdr-taxonomy-map-image-url" type="hidden" class="uploadfieldurl" readonly value="'.$image_url.'"/>
							<input name="dtdr-taxonomy-map-image-id" type="hidden" class="uploadfieldid" readonly value="'.$image_id.'"/>
							<input type="button" value="'.esc_html__( 'Add Image', 'dtdr' ).'" class="dtdr-upload-media-item-button show-preview with-image-holder" />
							<input type="button" value="'.esc_html__('Remove Image', 'dtdr').'" class="dtdr-upload-media-item-reset" />
							'.dtdr_adminpanel_image_preview($image_url).'
						</div>
						<p>'.esc_html__('This image will be used in Maps.', 'dtdr').'</p>
					</td>
				</tr>';

		}

		function dtdr_updated_taxonomy_form_fields ( $term_id, $tt_id ) {

			//Don't update on Quick Edit
			if (defined('DOING_AJAX') ) {
				return $post_id;
			}

			if( isset( $_POST['dtdr-taxonomy-map-image-url'] ) && '' !== $_POST['dtdr-taxonomy-map-image-url'] ){
				$image_url = dtdr_recursive_sanitize_text_field ($_POST['dtdr-taxonomy-map-image-url']);
				update_term_meta ( $term_id, 'dtdr-taxonomy-map-image-url', $image_url );
			} else {
				update_term_meta ( $term_id, 'dtdr-taxonomy-map-image-url', '' );
			}

			if( isset( $_POST['dtdr-taxonomy-map-image-id'] ) && '' !== $_POST['dtdr-taxonomy-map-image-id'] ){
				$image_id = dtdr_recursive_sanitize_text_field ($_POST['dtdr-taxonomy-map-image-id']);
				update_term_meta ( $term_id, 'dtdr-taxonomy-map-image-id', $image_id );
			} else {
				update_term_meta ( $term_id, 'dtdr-taxonomy-map-image-id', '' );
			}

		}


	}

	DTDirectoryLocationTaxonomyCustomFields::instance();

}

?>