<?php

if (!class_exists ( 'DTDirectoryRegisterStatisticsModule' )) {

	class DTDirectoryRegisterStatisticsModule extends DTDirectoryAddon {

		private $module_name;
		private $module_url;

		/**
		 * Instance variable
		 */
		private static $_instance = null;

		/**
		 * Instance
		 *
		 * Ensures only one instance of the class is loaded or can be loaded.
		 */
		public static function instance() {

			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}

			return self::$_instance;
		}

		function __construct() {

			$this->dtdr_define_constants( 'DTDR_STATISTICS_PLUGIN_PATH', DTDR_PLUGIN_PATH . 'modules/statistics/' );
			$this->dtdr_define_constants( 'DTDR_STATISTICS_PLUGIN_URL', DTDR_PLUGIN_URL . 'modules/statistics/' );

			add_action ( 'admin_menu', array ( $this, 'dtdr_configure_statistics_admin_menu' ), 40 );

			add_action ( 'admin_enqueue_scripts', array ( $this, 'dtdr_admin_enqueue_scripts' ), 120 );

			require_once DTDR_STATISTICS_PLUGIN_PATH . 'statistics-listings.php';
			require_once DTDR_STATISTICS_PLUGIN_PATH . 'statistics-sellers.php';

		}

		function dtdr_configure_statistics_admin_menu() {
			add_submenu_page( 'dtdr', 'Statistics', 'Statistics', 'edit_posts', 'dtdr-statistics-options', array ( $this, 'dtdr_statistics_options' ) );
		}

		function dtdr_statistics_options() {

			$listing_plural_label = apply_filters( 'listing_label', 'plural' );
			$seller_plural_label = apply_filters( 'seller_label', 'plural' );

			$tabs = array (
				'listings'   => array (
					'label' => $listing_plural_label,
					'callback' => 'dtdr_statistics_listings_content'
				),
				'sellers'     =>  array (
					'label' => $seller_plural_label,
					'callback' => 'dtdr_statistics_sellers_content'
				)
			);

			$tabs = apply_filters( 'dtdr_statistics', $tabs );

			$current = isset( $_GET['parenttab'] ) ? dtdr_recursive_sanitize_text_field($_GET['parenttab']) : 'listings';

			$this->dtdr_get_statistics_submenus($current, $tabs);
			$this->dtdr_get_statistics_tab($current, $tabs);

		}

		function dtdr_get_statistics_submenus($current, $tabs) {

			echo '<h2 class="dtdr-custom-nav nav-tab-wrapper">';
				foreach( $tabs as $key => $tab ) {
					$class = ( $key == $current ) ? 'nav-tab-active' : '';
					echo '<a class="nav-tab '.$class.'" href="?page=dtdr-statistics-options&parenttab='.$key.'">'.$tab['label'].'</a>';
				}
			echo '</h2>';

		}

		function dtdr_get_statistics_tab($current, $tabs) {
			call_user_func($tabs[$current]['callback']);
		}

		function dtdr_admin_enqueue_scripts() {
			$this->dtdr_register_dependent_files();

			$current_screen = get_current_screen();
			if($current_screen->id == 'directory_page_dtdr-statistics-options') {
				wp_enqueue_style ( 'dtdr-statistics-backend' );

				wp_enqueue_script ( 'dtdr-statistics-backend' );
			}
		}

		function dtdr_register_dependent_files() {

			wp_register_style ( 'dtdr-statistics-backend', DTDR_STATISTICS_PLUGIN_URL . 'assets/statistics-backend.css', array ( 'fontawesome', 'chosen', 'dtdr-fields', 'dtdr-backend', 'dtdr-common' ) );

			wp_register_script ( 'dtdr-statistics-backend', DTDR_STATISTICS_PLUGIN_URL . 'assets/backend.js', array ( 'jquery', 'dtdr-fields', 'dtdr-common', 'dtdr-backend' ), false, true );

		}

	}

}

if( !function_exists('dtdrStatisticsModule') ) {
	function dtdrStatisticsModule() {
		return DTDirectoryRegisterStatisticsModule::instance();
	}
}

dtdrStatisticsModule();

?>