<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if (! class_exists ( 'AdvenxPlusFooterPostType' ) ) {

	class AdvenxPlusFooterPostType {

        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

		function __construct() {

			add_action ( 'init', array( $this, 'advenx_register_cpt' ) );
			add_filter ( 'template_include', array ( $this, 'advenx_template_include' ) );
		}

		function advenx_register_cpt() {

			$labels = array (
				'name'				 => __( 'Footers', 'advenx-plus' ),
				'singular_name'		 => __( 'Footer', 'advenx-plus' ),
				'menu_name'			 => __( 'Footers', 'advenx-plus' ),
				'add_new'			 => __( 'Add Footer', 'advenx-plus' ),
				'add_new_item'		 => __( 'Add New Footer', 'advenx-plus' ),
				'edit'				 => __( 'Edit Footer', 'advenx-plus' ),
				'edit_item'			 => __( 'Edit Footer', 'advenx-plus' ),
				'new_item'			 => __( 'New Footer', 'advenx-plus' ),
				'view'				 => __( 'View Footer', 'advenx-plus' ),
				'view_item' 		 => __( 'View Footer', 'advenx-plus' ),
				'search_items' 		 => __( 'Search Footers', 'advenx-plus' ),
				'not_found' 		 => __( 'No Footers found', 'advenx-plus' ),
				'not_found_in_trash' => __( 'No Footers found in Trash', 'advenx-plus' ),
			);

			$args = array (
				'labels' 				=> $labels,
				'public' 				=> true,
				'exclude_from_search'	=> true,
				'show_in_nav_menus' 	=> false,
				'show_in_rest' 			=> true,
				'menu_position'			=> 26,
				'menu_icon' 			=> 'dashicons-editor-insertmore',
				'hierarchical' 			=> false,
				'supports' 				=> array ( 'title', 'editor', 'revisions' ),
			);

			register_post_type ( 'wdt_footers', $args );
		}

		function advenx_template_include($template) {
			if ( is_singular( 'wdt_footers' ) ) {
				if ( ! file_exists ( get_stylesheet_directory () . '/single-wdt_footers.php' ) ) {
					$template = ADVENX_PLUS_DIR_PATH . 'post-types/templates/single-wdt_footers.php';
				}
			}

			return $template;
		}
	}
}

AdvenxPlusFooterPostType::instance();