<?php

namespace DTElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

class WDTDestinationSpMediaImages extends Widget_Base {

	public function get_categories() {
		return [ 'wdt-singlepage-widgets' ];
	}

	public function get_name() {
		return 'wdt-widget-sp-media-images';
	}

	public function get_title() {
		return esc_html__( 'Media - Images','wdt-destination');
	}

	public function get_style_depends() {
		return array ('wdt-media-images-frontend');
	}

	public function get_script_depends() {
		return array ('wdt-media-images-frontend');
	}

	protected function register_controls() {

		$destination_listing_singular_label = apply_filters( 'destination_listing_label', 'singular' );

		$this->start_controls_section( 'media_images_default_section', array(
			'label' => esc_html__( 'General','wdt-destination'),
		) );

			$this->add_control( 'listing_id', array(
				'label'       => sprintf( esc_html__('%1$s Id','wdt-destination'), $destination_listing_singular_label ),
				'type'        => Controls_Manager::TEXT,
				'description' => sprintf( esc_html__('Provide %1$s id to display your item. No need to provide ID if it is used in %1$s single page.','wdt-destination'), strtolower($destination_listing_singular_label) ),
				'default'     => ''
			) );

			$this->add_control( 'image_size', array(
				'label'       => esc_html__( 'Thumbnail Sizes','wdt-destination'),
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					'thumbnail'    => esc_html__('Thumbnail','wdt-destination'),
					'medium'       => esc_html__('Medium','wdt-destination'),
					'medium_large' => esc_html__('Medium Large','wdt-destination'),
					'large'        => esc_html__('Large','wdt-destination'),
					'full'         => esc_html__('Full','wdt-destination'),
				),
				'description' => esc_html__( 'Choose any of the above image sizes.','wdt-destination'),
				'default'      => 'full',
			) );

			$this->add_control( 'show_image_description', array(
				'label'       => esc_html__( 'Show Image Description','wdt-destination'),
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					'false' => esc_html__('False','wdt-destination'),
					'true'  => esc_html__('True','wdt-destination'),
				),
				'description' => esc_html__('Choose "True" if you like to show image description in carousel.','wdt-destination'),
				'default'      => 'false'
			) );

			$this->add_control( 'include_featured_image', array(
				'label'       => esc_html__( 'Include Feature Image','wdt-destination'),
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					'false' => esc_html__('False','wdt-destination'),
					'true'  => esc_html__('True','wdt-destination'),
				),
				'description' => esc_html__('Choose "True" if you like to include featured image in this gallery.','wdt-destination'),
				'default'      => 'false'
			) );

			$this->add_control( 'class', array(
				'label'       => esc_html__( 'Class','wdt-destination'),
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__( 'If you wish you can add additional class name here.','wdt-destination'),
				'default'     => ''
			) );

		$this->end_controls_section();


		$this->start_controls_section( 'media_images_carousel_section', array(
			'label' => esc_html__( 'Carousel Options','wdt-destination'),
		) );

			$this->add_control( 'carousel_effect', array(
				'label'       => esc_html__( 'Effect','wdt-destination'),
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					'' => esc_html__('Default','wdt-destination'),
					'fade'  => esc_html__('Fade','wdt-destination'),
				),
				'description' => esc_html__( 'Choose effect for your carousel. Slides Per View has to be 1 for Fade effect.','wdt-destination'),
				'default'      => ''
			) );

			$this->add_control( 'carousel_autoplay', array(
				'label'   => esc_html__( 'Auto Play','wdt-destination'),
				'type'    => Controls_Manager::TEXT,
				'description' => esc_html__( 'Delay between transitions ( in ms ). Leave empty if you don\'t want to auto play.','wdt-destination'),
				'default' => ''
			) );

			$this->add_control( 'carousel_slidesperview', array(
				'label'       => esc_html__( 'Slides Per View','wdt-destination'),
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					1 => 1,
					2 => 2,
					3 => 3,
					4 => 4,
				),
				'description' => esc_html__( 'Number slides of to show in view port.','wdt-destination'),
				'default'      => 2
			) );

			$this->add_control( 'carousel_loopmode', array(
				'label'   => esc_html__( 'Enable Loop Mode','wdt-destination'),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'false' => esc_html__('False','wdt-destination'),
					'true'  => esc_html__('True','wdt-destination'),
				),
				'description' => esc_html__( 'If you wish you can enable continous loop mode for your carousel.','wdt-destination'),
				'default'     => 'false'
			) );

			$this->add_control( 'carousel_mousewheelcontrol', array(
				'label'   => esc_html__( 'Enable Mousewheel Control','wdt-destination'),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'false' => esc_html__('False','wdt-destination'),
					'true'  => esc_html__('True','wdt-destination'),
				),
				'description' => esc_html__( 'If you wish you can enable mouse wheel control for your carousel.','wdt-destination'),
				'default'     => 'false'
			) );

			$this->add_control( 'carousel_verticaldirection', array(
				'label'   => esc_html__('Enable Vertical Direction','wdt-destination'),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'false' => esc_html__('False','wdt-destination'),
					'true'  => esc_html__('True','wdt-destination'),
				),
				'description' => esc_html__( 'To make your slides to navigate vertically.','wdt-destination'),
				'default'     => 'false'
			) );

			$this->add_control( 'carousel_paginationtype', array(
				'label'   => esc_html__( 'Pagination Type','wdt-destination'),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					''            => esc_html__('None','wdt-destination'),
					'bullets'     => esc_html__('Bullets','wdt-destination'),
					'fraction'    => esc_html__('Fraction','wdt-destination'),
					'progressbar' => esc_html__('Progress Bar','wdt-destination'),
					'scrollbar'   => esc_html__('Scroll Bar','wdt-destination'),
					'thumbnail'   => esc_html__('Thumbnail','wdt-destination')
				),
				'description' => esc_html__( 'Choose pagination type you like to use.','wdt-destination'),
				'default'      => ''
			) );

			$this->add_control( 'carousel_numberofthumbnails', array(
				'label'   => esc_html__('Number of Thumbnails','wdt-destination'),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					3 => 3,
					4 => 4,
					5 => 5,
					6 => 6,
				),
				'description' => esc_html__( 'Number of thumbnails to show.','wdt-destination'),
				'condition'   => array( 'carousel_paginationtype' => 'thumbnail' ),
				'default'     => 3
			) );

			$this->add_control( 'carousel_arrowpagination', array(
				'label'   => esc_html__( 'Enable Arrow Pagination','wdt-destination'),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'false' => esc_html__('False','wdt-destination'),
					'true'  => esc_html__('True','wdt-destination'),
				),
				'description' => esc_html__( 'To enable arrow pagination.','wdt-destination'),
				'default'     => 'false'
			) );

			$this->add_control( 'carousel_arrowpagination_type', array(
				'label'   => esc_html__( 'Arrow Type','wdt-destination'),
				'type'    => Controls_Manager::SELECT,
				'options' => array(
					'type1' => esc_html__('Type 1','wdt-destination'),
					'type2' => esc_html__('Type 2','wdt-destination'),
					'type3' => esc_html__('Type 3','wdt-destination')
				),
				'description' => esc_html__( 'Choose arrow pagination type for your carousel.','wdt-destination'),
				'default'     => 'type1'
			) );

			$this->add_control( 'carousel_spacebetween', array(
				'label'       => esc_html__( 'Space Between Sliders','wdt-destination'),
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__( 'Space between sliders can be given here.','wdt-destination'),
				'default'     => ''
			) );

		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings();
		$attributes = wdtdestination_elementor_instance()->wdt_parse_shortcode_attrs( $settings );
		$output = do_shortcode('[wdt_sp_media_images '.$attributes.' /]');

		echo $output;

	}

}