<?php

namespace DTElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

class WDTDestinationSpAddToCart extends Widget_Base {

	public function get_categories() {
		return [ 'wdt-singlepage-widgets' ];
	}

	public function get_name() {
		return 'wdt-widget-sp-addtocart';
	}

	public function get_title() {
		return esc_html__( 'Add To Cart','wdt-destination');
	}

	public function get_style_depends() {
		return array ( 'wdt-pricing-frontend' );
	}

	public function get_script_depends() {
		return array ();
	}

	protected function register_controls() {

		$destination_listing_singular_label = apply_filters( 'destination_listing_label', 'singular' );

		$this->start_controls_section( 'addtocart_default_section', array(
			'label' => esc_html__( 'General','wdt-destination'),
		) );

			$this->add_control( 'listing_id', array(
				'label'       => sprintf( esc_html__('%1$s Id','wdt-destination'), $destination_listing_singular_label ),
				'type'        => Controls_Manager::TEXT,
				'description' => sprintf( esc_html__('Provide %1$s id to display your item. No need to provide ID if it is used in %1$s single page.','wdt-destination'), strtolower($destination_listing_singular_label) ),
				'default'     => ''
			) );

			$this->add_control( 'class', array(
				'label'       => esc_html__( 'Class','wdt-destination'),
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__( 'If you wish you can add additional class name here.','wdt-destination'),
				'default'     => ''
			) );

		$this->end_controls_section();
	}

	protected function render() {

		$settings   = $this->get_settings();
		$attributes = wdtdestination_elementor_instance()->wdt_parse_shortcode_attrs( $settings );
		$output     = do_shortcode('[wdt_sp_add_to_cart '.$attributes.' /]');

		echo $output;

	}

}