<?php
add_action( 'vc_before_init', 'wdt_sp_features_vc_map' );

function wdt_sp_features_vc_map() {

	$destination_listing_singular_label = apply_filters( 'destination_listing_label', 'singular' );

	vc_map( array(
		"name" => esc_html__( 'Features','wdt-destination'),
		"base" => "wdt_sp_features",
		"icon" => "wdt_sp_features",
		"category" => WDT_PB_MODULE_SINGLEPAGE_TITLE,
		"params" => array(

			// Listing Id
			array(
				'type' => 'textfield',
				'heading' => sprintf( esc_html__('%1$s Id','wdt-destination'), $destination_listing_singular_label ),
				'param_name' => 'listing_id',
				'description' => sprintf( esc_html__('Provide %1$s id for which you have to display features. No need to provide ID if it is used in %1$s single page.','wdt-destination'), strtolower($destination_listing_singular_label) ),
				'edit_field_class' => 'vc_column vc_col-sm-6',
				'admin_label' => true
			),

			// Type
			array(
				'type' => 'dropdown',
				'heading' => esc_html__('Type','wdt-destination'),
				'param_name' => 'type',
				'value' => array(
					esc_html__('Type 1','wdt-destination') => 'type1',
					esc_html__('Type 2','wdt-destination') => 'type2',
					esc_html__('Type 3','wdt-destination') => 'type3',
					esc_html__('Type 4','wdt-destination') => 'type4',
					esc_html__('Type 5','wdt-destination') => 'type5',
					esc_html__('Type 6','wdt-destination') => 'type6',
					esc_html__('Type 7','wdt-destination') => 'type7'
				),
				'description' => esc_html__( 'Choose any of the available type.','wdt-destination'),
				'edit_field_class' => 'vc_column vc_col-sm-6',
				'admin_label' => true,
				'std' => 'type1'
			),

			// Include
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Include','wdt-destination'),
				'param_name' => 'include',
				'description' => esc_html__( 'If you like, you can include only certain items. Leave empty if you like to display all.','wdt-destination'),
				'edit_field_class' => 'vc_column vc_col-sm-6'
			),

			// Columns
			array(
				'type' => 'dropdown',
				'heading' => esc_html__('Columns','wdt-destination'),
				'param_name' => 'columns',
				'value' => array(
							esc_html__('No Column','wdt-destination') => -1,
							esc_html__('I Column','wdt-destination') => 1,
							esc_html__('II Columns','wdt-destination') => 2,
							esc_html__('III Columns','wdt-destination') => 3,
							esc_html__('IV Columns','wdt-destination') => 4,
						),
				'description' => esc_html__( 'Number of columns you like to display your features.','wdt-destination'),
				'edit_field_class' => 'vc_column vc_col-sm-6',
				'std' => 4
			),

			// Class
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Class','wdt-destination'),
				'param_name' => 'class',
				'description' => esc_html__( 'If you wish you can add additional class name here.','wdt-destination'),
				'edit_field_class' => 'vc_column vc_col-sm-6'
			)

		)
	) );
}
?>