<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( !class_exists( 'Advenx_Shop_Single_Metabox_Options' ) ) {
    class Advenx_Shop_Single_Metabox_Options {

        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        function __construct() {
            add_filter( 'advenx_shop_product_custom_settings', array( $this, 'advenx_shop_product_custom_settings' ), 20 );
        }

        function advenx_shop_product_custom_settings( $options ) {

			$product_options = array(

				# Product New Label
					array(
						'id'         => 'product-new-label',
						'type'       => 'switcher',
						'title'      => esc_html__('Add "New" label', 'advenx-shop'),
					),

					array(
						'id'         => 'product-notes',
						'type'       => 'textarea',
						'title'      => esc_html__('Product Notes', 'advenx-shop')
					)

			);

			$options = array_merge( $options, $product_options );

			return $options;

        }

    }
}

Advenx_Shop_Single_Metabox_Options::instance();