<?php
use AdvenxElementor\Widgets\AdvenxElementorWidgetBase;
use Elementor\Controls_Manager;
use Elementor\Utils;

class Elementor_Post_Socials extends AdvenxElementorWidgetBase {

    public function get_name() {
        return 'wdt-post-socials';
    }

    public function get_title() {
        return esc_html__('Post - Socials', 'advenx-pro');
    }

    protected function register_controls() {

        $this->start_controls_section( 'wdt_section_general', array(
            'label' => esc_html__( 'General', 'advenx-pro'),
        ) );

            $this->add_control( 'style', array(
                'type'    => Controls_Manager::SELECT,
				'label'   => esc_html__('Style', 'advenx-pro'),
                'default' => '',
                'options' => array(
                    ''  => esc_html__('Default', 'advenx-pro'),
                    'meta-elements-space'		 => esc_html__('Space', 'advenx-pro'),
                    'meta-elements-boxed'  		 => esc_html__('Boxed', 'advenx-pro'),
                    'meta-elements-boxed-curvy'  => esc_html__('Curvy', 'advenx-pro'),
                    'meta-elements-boxed-round'  => esc_html__('Round', 'advenx-pro'),
					'meta-elements-filled'  	 => esc_html__('Filled', 'advenx-pro'),
					'meta-elements-filled-curvy' => esc_html__('Filled Curvy', 'advenx-pro'),
					'meta-elements-filled-round' => esc_html__('Filled Round', 'advenx-pro'),
                ),
            ) );

            $this->add_control( 'el_class', array(
                'type'        => Controls_Manager::TEXT,
                'label'       => esc_html__('Extra class name', 'advenx-pro'),
                'description' => esc_html__('Style particular element differently - add a class name and refer to it in custom CSS', 'advenx-pro')
            ) );

        $this->end_controls_section();

    }

    protected function render() {

        $settings = $this->get_settings_for_display();

        extract($settings);

		$out = '';

        global $post;
        $post_id =  $post->ID;

        $template_args['post_ID'] = $post_id;

		$out .= '<div class="entry-social-share-wrapper '.$style.' '.$el_class.'">';
			$out .= advenx_get_template_part( 'post', 'templates/post-extra/social', '', $template_args );
		$out .= '</div>';

		echo $out;
	}

}