<?php
add_action( 'vc_before_init', 'wdt_sp_opening_hours_vc_map' );

function wdt_sp_opening_hours_vc_map() {

	$destination_listing_singular_label = apply_filters( 'destination_listing_label', 'singular' );

	vc_map( array(
		"name" => esc_html__( 'Opening Hours','wdt-destination'),
		"base" => "wdt_sp_opening_hours",
		"icon" => "wdt_sp_opening_hours",
		"category" => WDT_PB_MODULE_SINGLEPAGE_TITLE,
		"params" => array(

			// Listing Id
			array(
				'type' => 'textfield',
				'heading' => sprintf( esc_html__('%1$s Id','wdt-destination'), $destination_listing_singular_label ),
				'param_name' => 'listing_id',
				'description' => sprintf( esc_html__('Provide %1$s id for which you have to display featured image. No need to provide ID if it is used in %1$s single page.','wdt-destination'), strtolower($destination_listing_singular_label) ),
				'edit_field_class' => 'vc_column vc_col-sm-6',
				'admin_label' => true
			),

			// Show Current Time
			array(
				'type' => 'dropdown',
				'heading' => esc_html__('Show Current Time','wdt-destination'),
				'description' => esc_html__('Choose "True" if you like to show current time.','wdt-destination'),
				'param_name' => 'show_current_time',
				'value' => array(
					esc_html__( 'False','wdt-destination') => 'false',
					esc_html__( 'True','wdt-destination') => 'true',
				),
			),

			// Class
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Class','wdt-destination'),
				'param_name' => 'class',
				'description' => esc_html__( 'If you wish you can add additional class name here.','wdt-destination'),
				'edit_field_class' => 'vc_column vc_col-sm-6'
			)

		)
	) );
}
?>