<?php

namespace DTElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

class WDTDestinationSfOutputDataContainer extends Widget_Base {

	public function get_categories() {
		return [ 'wdt-searchform-widgets' ];
	}

	public function get_name() {
		return 'wdt-widget-sf-output-data-container';
	}

	public function get_title() {
		return esc_html__( 'Output Data Container','wdt-destination');
	}

	public function get_style_depends() {
		return array ( 'wdt-fields', 'wdt-search-frontend');
	}

	public function get_script_depends() {
		return array ( 'wdt-search-frontend');
	}

	public function wdt_dynamic_register_controls() {

	}

	protected function register_controls() {

		$destination_listing_singular_label = apply_filters( 'destination_listing_label', 'singular' );

		$this->start_controls_section( 'output_data_container_default_section', array(
			'label' => esc_html__( 'General','wdt-destination'),
		) );

            $this->add_control( 'type', array(
                'label'       => esc_html__( 'Type','wdt-destination'),
                'type'        => Controls_Manager::SELECT,
                'options'     => array(
                    'type1' => esc_html__('Type 1','wdt-destination'),
                    'type2' => esc_html__('Type 2','wdt-destination'),
                    'type3' => esc_html__('Type 3','wdt-destination'),
                    'type4' => esc_html__('Type 4','wdt-destination'),
                    'type5' => esc_html__('Type 5','wdt-destination'),
					'type6' => esc_html__('Type 6','wdt-destination')
                ),
                'description' => esc_html__('Choose type of layout you like to display.','wdt-destination'),
                'default'      => 'type1',
            ) );

            $this->add_control( 'gallery', array(
                'label'       => esc_html__( 'Gallery','wdt-destination'),
                'type'        => Controls_Manager::SELECT,
                'options'     => array(
                    'featured_image'        => esc_html__('Featured Image','wdt-destination'),
                    'image_gallery'         => esc_html__('Image Gallery','wdt-destination'),
                    'gallery_with_featured' => esc_html__('Image Gallery With Featured Image','wdt-destination'),
                ),
                'description' => esc_html__( 'Choose how you like to display image gallery.','wdt-destination'),
                'default'      => 'featured_image',
            ) );

            $this->add_control( 'post_per_page', array(
                'label'   => esc_html__( 'Post Per Page','wdt-destination'),
                'type'    => Controls_Manager::TEXT,
                'description' => esc_html__( 'Number of posts to show per page. Rest of the posts will be displayed in pagination.','wdt-destination'),
                'default' => -1
            ) );

            $this->add_control( 'columns', array(
                'label'       => esc_html__( 'Columns','wdt-destination'),
                'type'        => Controls_Manager::SELECT,
                'options'     => array(
                    1  => esc_html__('I Column','wdt-destination'),
					2  => esc_html__('II Columns','wdt-destination'),
					3  => esc_html__('III Columns','wdt-destination')
                ),
				'description' => esc_html__( 'Number of columns you like to display your items.','wdt-destination'),
				'condition'   => array( 'type' => array( 'type1', 'type2', 'type4', 'type6', 'type8') ),
                'default'      => 1,
            ) );

            $this->add_control( 'apply_isotope', array(
                'label'       => esc_html__( 'Apply Isotope','wdt-destination'),
                'type'        => Controls_Manager::SELECT,
                'options'     => array(
                    'false' => esc_html__('False','wdt-destination'),
                    'true'  => esc_html__('True','wdt-destination'),
                ),
                'description' => esc_html__('Choose true if you like to apply isotope for your items.  Isotope won\'t work along with Carousel.','wdt-destination'),
                'default'      => 'false'
            ) );

			$this->add_control( 'excerpt_length', array(
				'label'   => esc_html__( 'Excerpt Length','wdt-destination'),
				'type'    => Controls_Manager::TEXT,
				'description' => esc_html__( 'Provide excerpt length here.','wdt-destination'),
				'default' => 20
			) );

            $this->add_control( 'features_image_or_icon', array(
				'label'       => esc_html__( 'Features Image or Icon','wdt-destination'),
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					''      => esc_html__('None','wdt-destination'),
					'image' => esc_html__('Image','wdt-destination'),
					'icon'  => esc_html__('Icon','wdt-destination')
				),
				'description' => esc_html__('Choose any of the option available to display features.','wdt-destination'),
				'default'      => '',
			) );

			$this->add_control( 'features_include', array(
				'label'       => esc_html__( 'Features Include','wdt-destination'),
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__('Give features id separated by comma. Only 4 maximum number of features allowed.','wdt-destination'),
				'default'      => '',
			) );

			$this->add_control( 'no_of_cat_to_display', array(
				'label'       => esc_html__( 'No. Of Categories to Display','wdt-destination'),
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					1  => 1,
					2  => 2,
					3  => 3,
					4  => 4
				),
				'description' => esc_html__( 'Number of categories you like to display on your items.','wdt-destination'),
				'default'      => 2,
			) );

			$this->add_control( 'apply_equal_height', array(
				'label'       => esc_html__( 'Apply Equal Height','wdt-destination'),
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					'false' => esc_html__('False','wdt-destination'),
					'true'  => esc_html__('True','wdt-destination'),
				),
				'condition'   => array( 'apply_isotope' => 'false' ),
				'description' => esc_html__('Apply equal height for you items.','wdt-destination'),
				'default'      => 'false'
			) );

			$this->add_control( 'apply_custom_height', array(
				'label'       => esc_html__( 'Apply Custom Height','wdt-destination'),
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					'false' => esc_html__('False','wdt-destination'),
					'true'  => esc_html__('True','wdt-destination'),
				),
				'description' => esc_html__('Apply custom height for your entire section.','wdt-destination'),
				'default'      => 'false'
			) );

			$this->add_responsive_control( 'height', array(
                'label' => esc_html__( 'Height','wdt-destination'),
                'type' => Controls_Manager::TEXT,
				'description' => esc_html__( 'Provide height for your section in "px" here.','wdt-destination'),
				'condition'   => array( 'apply_custom_height' => 'true' ),
                'devices' => array( 'desktop', 'tablet', 'mobile' ),
                'selectors' => array(
					'{{WRAPPER}} .wdt-listing-output-data-container' => 'height: {{SIZE}}px;',
				),
			) );

			$this->add_control( 'sidebar_widget', array(
				'label'       => esc_html__( 'Sidebar Widget','wdt-destination'),
				'type'        => Controls_Manager::SELECT,
				'options'     => array(
					'false' => esc_html__('False','wdt-destination'),
					'true'  => esc_html__('True','wdt-destination'),
				),
				'description' => sprintf( esc_html__('%1$s 1) If you wish to show these items in sidebar set this to "True". %2$s %1$s 2) This options is not applicable for "Type 3", "Type 5" and "Type 7". %2$s','wdt-destination'), '<p>', '</p>' ),
				'default'      => 'false'
			) );

			$this->add_control( 'class', array(
				'label'   => esc_html__( 'Class','wdt-destination'),
				'type'    => Controls_Manager::TEXT,
				'description' => esc_html__( 'If you wish you can add additional class name here.','wdt-destination'),
				'default' => ''
			) );

		$this->end_controls_section();

		$this->wdt_dynamic_register_controls();

		$this->start_controls_section( 'output_data_container_filter_section', array(
			'label' => esc_html__( 'Filter Options','wdt-destination'),
		) );

			$this->add_control( 'category_ids', array(
				'label'   => sprintf( esc_html__('%1$s Category Ids','wdt-destination'), $destination_listing_singular_label ),
				'type'    => Controls_Manager::TEXT,
				'description' => sprintf( esc_html__( 'Enter %1$s category ids separated by commas.','wdt-destination'), $destination_listing_singular_label ),
				'default' => ''
			) );

		$this->end_controls_section();

	}

	protected function render() {

		$settings   = $this->get_settings();
		$attributes = wdtdestination_elementor_instance()->wdt_parse_shortcode_attrs( $settings );
		$output     = do_shortcode('[wdt_sf_output_data_container '.$attributes.' /]');

		echo $output;

	}

}