<?php

// Single Page - Announcements
if(!function_exists('dtdr_sp_announcements')) {
	function dtdr_sp_announcements( $attrs, $content = null ) {

		$attrs = shortcode_atts ( array (

					'listing_id' => '',
					'class' => '',

				), $attrs, 'dtdr_sp_announcements' );


		$output = '';

		if($attrs['listing_id'] == '' && is_singular('dtdr_listings')) {
			global $post;
			$attrs['listing_id'] = $post->ID;
		}

		if($attrs['listing_id'] != '') {

			$dtdr_listing_announcements = get_post_meta( $attrs['listing_id'], 'dtdr_listing_announcements', true);
			$dtdr_listing_announcements = (is_array($dtdr_listing_announcements) && !empty($dtdr_listing_announcements)) ? $dtdr_listing_announcements : array ();

			if(is_array($dtdr_listing_announcements) && !empty($dtdr_listing_announcements)) {

				foreach($dtdr_listing_announcements as $key => $dtdr_listing_announcement) {
					if($dtdr_listing_announcement['status']) {
						$output .= '<div class="dtdr-announcement-listing-holder '.$dtdr_listing_announcement['action'].'">';

							if($dtdr_listing_announcement['action'] == 'booknow') {
								$output .= '<div class="column dt-sc-four-fifth first">';
							}

								if($dtdr_listing_announcement['icon'] != '') {
									$output .= '<span class="'.$dtdr_listing_announcement['icon'].'"></span>';
								}

								if($dtdr_listing_announcement['action'] == 'booknow') {
									$output .= '<div class="dtdr-announcement-listing-inner">';
								}
									$output .= '<h2>'.$dtdr_listing_announcement['title'].'</h2>';
									$output .= '<p>'.$dtdr_listing_announcement['description'].'</p>';
								if($dtdr_listing_announcement['action'] == 'booknow') {
									$output .= '</div>';
								}

							if($dtdr_listing_announcement['action'] == 'booknow') {
								$output .= '</div>';
								$output .= '<div class="column dt-sc-one-fifth">';
							}

								if($dtdr_listing_announcement['button_text'] != '' && $dtdr_listing_announcement['button_link'] != '') {
									$output .= '<a href="'.esc_url($dtdr_listing_announcement['button_link']).'">'.$dtdr_listing_announcement['button_text'].'</a>';
								}

							if($dtdr_listing_announcement['action'] == 'booknow') {
								$output .= '</div>';
							}

						$output .= '</div>';
					}
				}

			}

		} else {

			$listing_singular_label = apply_filters( 'listing_label', 'singular' );

			$output .= sprintf( esc_html__('Please provide %1$s id to display corresponding data!', 'dtdr'), strtolower($listing_singular_label) );

		}

		return $output;

	}
	add_shortcode ( 'dtdr_sp_announcements', 'dtdr_sp_announcements' );
}

?>