<?php
add_action( 'vc_before_init', 'dtdr_sp_claim_listing_vc_map' );

function dtdr_sp_claim_listing_vc_map() {

	$listing_singular_label = apply_filters( 'listing_label', 'singular' );

	vc_map( array(
		"name" => esc_html__( 'Claim Listing', 'dtdr' ),
		"base" => "dtdr_sp_claim_listing",
		"icon" => "dtdr_sp_claim_listing",
		"category" => DTDR_PB_MODULE_SINGLEPAGE_TITLE,
		"params" => array(

			// Listing Id
			array(
				'type' => 'textfield',
				'heading' => sprintf( esc_html__('%1$s Id', 'dtdr'), $listing_singular_label ),
				'param_name' => 'listing_id',
				'description' => sprintf( esc_html__('Provide %1$s id for which you have to display claim link. No need to provide ID if it is used in %1$s single page.', 'dtdr'), strtolower($listing_singular_label) ),
				'edit_field_class' => 'vc_column vc_col-sm-6',
				'admin_label' => true
			),

			// Type
			array(
				'type' => 'dropdown',
				'heading' => esc_html__('Type','dtdr'),
				'param_name' => 'type',
				'value' => array(
					esc_html__( 'Claim Link', 'dtdr' ) => 'claim_link',
					esc_html__( 'Claim Verfied Notice', 'dtdr' ) => 'claim_verified_notice'
				),
				'std' => 'claim_link',
				'description' => esc_html__('Choose type of you like to display.', 'dtdr'),
				'edit_field_class' => 'vc_column vc_col-sm-6',
			),

			// Show Verified Notice
			array(
				'type' => 'dropdown',
				'heading' => esc_html__('Show Verified Notice','dtdr'),
				'param_name' => 'show_verified_notice',
				'value' => array(
					esc_html__( 'False', 'dtdr' ) => 'false',
					esc_html__( 'True', 'dtdr' ) => 'true',
				),
				'std' => 'false',
				'description' => esc_html__('Show verified notice after successfull claim.', 'dtdr'),
				'dependency' => array( 'element' => 'type', 'value' =>'claim_link' ),
				'edit_field_class' => 'vc_column vc_col-sm-6',
			),

			// Class
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Class', 'dtdr' ),
				'param_name' => 'class',
				'description' => esc_html__( 'If you wish you can add additional class name here.', 'dtdr' ),
				'edit_field_class' => 'vc_column vc_col-sm-6'
			)

		)
	) );
}
?>