<?php

function dtdr_dashboard_seller_inbox_page_content() {

	$output = '';

	$output .= '<div class="dtdr-my-inbox-container">';

		$output .= '<div class="dtdr-my-inbox-item-holder">';

			$output .= '<div class="dtdr-column dtdr-one-half first">';

				$output .= '<div class="dtdr-dashbord-section-holder">';

					// Inbox Messages

					$output .= '<div class="dtdr-dashbord-section-holder-intro">';
						$output .= '<div class="dtdr-dashbord-section-title">'.esc_html__('Messages', 'dtdr').'</div>';
						$output .= '<div class="dtdr-dashbord-section-title-notes">'.esc_html__('Messages added by users from frontend contact form.', 'dtdr').'</div>';
					$output .= '</div>';

					$output .= '<div class="dtdr-dashbord-section-holder-content">';

						$author_id = get_current_user_id();

						$dtdr_lead_messages = get_user_meta($author_id, 'dtdr_lead_messages', true);

						if(is_array($dtdr_lead_messages) && !empty($dtdr_lead_messages)) {
							foreach($dtdr_lead_messages as $listing_id => $dtdr_lead_listing_messages) {
								if($listing_id > 0) {
									$output .= '<h5 class="dtdr-dashbord-inbox-listing-title">'.get_the_title($listing_id).'</h5>';
									$output .= '<ul class="dtdr-dashbord-inbox-listing-messages-wrapper">';
										foreach($dtdr_lead_listing_messages as $user_emailid => $dtdr_lead_user_messages) {

											$unread_cnt = 0;
											$unread_class = '';
											foreach($dtdr_lead_user_messages['leads']['conversation'] as $dtdr_lead_user_data) {
												if($dtdr_lead_user_data['status'] == 'unread') {
													$unread_cnt++;
												}
											}
											if($unread_cnt > 0) {
												$unread_class = 'unread';
											}
											$output .= '<li class="dtdr-dashbord-inbox-conversation-loader '.esc_attr($unread_class).'" data-authorid="'.esc_attr($author_id).'"  data-listingid="'.esc_attr($listing_id).'" data-useremail="'.esc_attr($user_emailid).'">'.esc_html($dtdr_lead_user_messages['leads']['name']).'<span class="dtdr-inbox-listing-user-email">'.esc_url($user_emailid).'</span><span class="dtdr-inbox-listing-user-unread-count">'.esc_html($unread_cnt).'</span></li>';
										}
									$output .= '</ul>';
								}
							}
						}

					$output .= '</div>';

				$output .= '</div>';

			$output .= '</div>';

			$output .= '<div class="dtdr-column dtdr-one-half">';

			$output .= '<div class="dtdr-dashbord-inbox-listing-conversation-wrapper"></div>';

			$output .= '</div>';

		$output .= '</div>';

	$output .= '</div>';


	return $output;

}

// Inbox Load Conversation

add_action( 'wp_ajax_dtdr_inbox_conversation_loader', 'dtdr_inbox_conversation_loader' );
add_action( 'wp_ajax_nopriv_dtdr_inbox_conversation_loader', 'dtdr_inbox_conversation_loader' );
function dtdr_inbox_conversation_loader() {

	extract(dtdr_recursive_sanitize_text_field($_REQUEST));

	$dtdr_lead_messages = get_user_meta($author_id, 'dtdr_lead_messages', true);

	$dtdr_conversations = array_reverse($dtdr_lead_messages[$listing_id][$user_email]['leads']['conversation'], true);

	$output = '';
	if(is_array($dtdr_conversations) && !empty($dtdr_conversations)) {
		$output .= '<ul class="dtdr-dashbord-inbox-conversation-list">';
		foreach($dtdr_conversations as $conversation_id => $dtdr_conversation) {
			if($dtdr_conversation['leadData']['message'] != '') {

				$unread_class = '';
				if($dtdr_conversation['status'] == 'unread') {
					$unread_class = 'unread';
				}

				$output .= '<li class="'.$unread_class.'">';

					$output .= $dtdr_conversation['leadData']['message'];
					$output .= '<span>'.$dtdr_conversation['leadData']['date'].'</span>';

					$output .= '<a class="dtdr-dashbord-inbox-conversation-reply-loader">'.esc_html__('Reply').'</a>';

					$output .= '<div class="dtdr-dashbord-inbox-conversation-reply-wrapper hidden">';

						$output .= '<form method="post" class="dtdr-inbox-conversation-reply-form" name="dtdr-inbox-conversation-reply-form">';

							$output .= '<textarea class="message" name="message" rows="5" placeholder="'.esc_html__('Give a Reply', 'dtdr').'"></textarea>';

							$output .= '<input class="author_id" name="author_id" type="hidden" value="'.esc_attr($author_id).'" />';
							$output .= '<input class="listing_id" name="listing_id" type="hidden" value="'.esc_attr($listing_id).'" />';
							$output .= '<input class="user_email" name="user_email" type="hidden" value="'.esc_attr($user_email).'" />';
							$output .= '<input class="conversation_id" name="conversation_id" type="hidden" value="'.esc_attr($conversation_id).'" />';

							$output .= '<div class="dtdr-inbox-conversation-reply-notification-box"></div>';

							$output .= '<a class="dtdr-inbox-conversation-reply-submit">'.esc_html__('Send Reply', 'dtdr').'</a>';

						$output .= '</form>';

					$output .= '</div>';

					$output .= '<div class="dtdr-dashbord-inbox-conversation-reply-list-wrapper">';

						$dtdr_conversation_replies = $dtdr_conversation['replyData'];
						if(is_array($dtdr_conversation_replies) && !empty($dtdr_conversation_replies)) {
							$output .= '<ul class="dtdr-dashbord-inbox-conversation-reply-list">';
							foreach($dtdr_conversation_replies as $key => $dtdr_conversation_reply) {
								$output .= '<li>';
									$output .= $dtdr_conversation_reply['message'];
									$output .= '<span>'.$dtdr_conversation_reply['date'].'</span>';
								$output .= '</li>';
							}
							$output .= '</ul>';
						}

					$output .= '</div>';

				$output .= '</li>';
			}
		}
		$output .= '</ul>';
	}

	echo dtdr_html_output($output);

	die();

}

// Inbox Reply Conversation

add_action( 'wp_ajax_dtdr_process_inbox_conversation_reply_form', 'dtdr_process_inbox_conversation_reply_form' );
add_action( 'wp_ajax_nopriv_dtdr_process_inbox_conversation_reply_form', 'dtdr_process_inbox_conversation_reply_form' );
function dtdr_process_inbox_conversation_reply_form() {

	extract(dtdr_recursive_sanitize_text_field($_REQUEST));

	$errors = false;
	$error_msg = array ();

	$message = sanitize_text_field($message);
	if(empty($message)) {
		$errors = true;
		array_push($error_msg, esc_html__('Your message is empty!', 'dtdr'));
	}

	// Throw error message
	if($errors) {

		$error_content = '<div class="dtdr-inbox-conversation-reply-form-errorlist">';
			$error_content .= implode("\n", $error_msg);
		$error_content .= '</div>';

		echo json_encode(array(
			'success' => false,
			'message' => $error_content
		));
		wp_die();

	}


    $dtdr_subject  = sprintf(esc_html__('Reply for your message from %1$s', 'dtdr'), get_the_title($listing_id));
    $dtdr_body     = sprintf(esc_html__('Reply for your message from %1$s', 'dtdr'), get_the_title($listing_id)) . " <br/>";
    $dtdr_body 	 .= $message;
    $dtdr_header   = 'Content-type: text/html; charset = utf-8' . "\r\n";

    if (wp_mail($user_email, $dtdr_subject, $dtdr_body, $dtdr_header)) {

		$dtdr_lead_messages = get_user_meta($author_id, 'dtdr_lead_messages', true);

		$conversationData = $dtdr_lead_messages[$listing_id][$user_email]['leads']['conversation'][$conversation_id];

		if(!empty($conversationData)) {

			$replyDate = date(get_option('date_format'));

			$leadReply['message'] = $message;
			$leadReply['date']    = $replyDate;


			if (array_key_exists('replyData', $conversationData)) { // If message already exists

				$replyData = $conversationData['replyData'];

				array_push($replyData, $leadReply);


				$conversationData['replyData'] = $replyData;

			} else {

				$conversationData['replyData'][0] = $leadReply;

			}

		}

		$dtdr_lead_messages[$listing_id][$user_email]['leads']['conversation'][$conversation_id] = $conversationData;
		$dtdr_lead_messages[$listing_id][$user_email]['leads']['conversation'][$conversation_id]['status'] = 'read';

		update_user_meta($author_id, 'dtdr_lead_messages', $dtdr_lead_messages);


		$dtdr_conversation_replies = $dtdr_lead_messages[$listing_id][$user_email]['leads']['conversation'][$conversation_id]['replyData'];

		$replay_message = '<div class="dtdr-dashbord-inbox-conversation-reply-list-wrapper">';
		if(is_array($dtdr_conversation_replies) && !empty($dtdr_conversation_replies)) {
			$replay_message .= '<ul class="dtdr-dashbord-inbox-conversation-reply-list">';
			foreach($dtdr_conversation_replies as $key => $dtdr_conversation_reply) {
				$replay_message .= '<li>';
					$replay_message .= $dtdr_conversation_reply['message'];
					$replay_message .= '<span>'.$dtdr_conversation_reply['date'].'</span>';
				$replay_message .= '</li>';
			}
			$replay_message .= '</ul>';
		}
		$replay_message .= '</div>';

        echo json_encode(array (
            'success' 		   => true,
			'message'          => esc_html__('Your Message Conveyed Successfully!', 'dtdr'),
			'replay_message'   => $replay_message
		));

	}

	wp_die();

}


?>